<?php
// Register custom REST API route
add_action('rest_api_init', function () {

    // SEO

    register_rest_route('head', '/seo_meta', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_head_seo_meta',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('head', '/seo_schema', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_head_seo_schema',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('web', '/redirection', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_web_redirection',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    // Endpoints for Header

    register_rest_route('global', '/header', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_global_header',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('global', '/header/submenu', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_global_header_submenu',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('global', '/header/featured-post', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_global_header_featured_post',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('global', '/header/search-product', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_global_header_search_post',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Endpoints for footer
    register_rest_route('global', '/footer-explore', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_global_footer_explore',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('global', '/footer', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_global_footer',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Endpoints for homepage metal building section

    register_rest_route('home', '/data', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_home_data',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('home', '/metal-buildings', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_home_meta_buildings',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('home', '/metal-buildings/load-more', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_home_meta_buildings_load_more',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('home', '/metal-buildings/content', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_home_meta_buildings_content',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('home', '/product-category', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_home_product_category',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Endpoint for homepage blog section
    register_rest_route('home', '/latest-blog', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_home_latest_blog',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // product category page

    register_rest_route('product-category', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_pc_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('product-category', '/metal-buildings', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_pc_metal_buildings',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('product-category', '/about', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_pc_about_category',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('product-category', '/faqs', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_pc_faq',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('product-category', '/filter-options', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_pc_filter_options',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Product Detail

    register_rest_route('product', '/data', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_product_detail_data',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('product', '/similar-buildings', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_product_similar_buildings',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('product', '/views', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_product_views',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // RTO page

    register_rest_route('rto', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('rto', '/calculateSection', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_calculateSection',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('rto', '/topbuilding', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_topbuilding',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('rto', '/about', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_about',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('rto', '/partners', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_partners',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('rto', '/faq', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_rto_faq',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('rto', '/previously_viewed', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_rto_previously_viewed',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Manufacturer page


    register_rest_route('manufacturer', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_manufacturer_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('manufacturer', '/metal-building', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_manufacturer_metal_building',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('manufacturer', '/about', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_manufacturer_about',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Finance section

    register_rest_route('finance', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('finance', '/smart-finance', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_smart_finance',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('finance', '/finance-process', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_process',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('finance', '/metal-partners', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_partners',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('finance', '/metal-building', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_metal_building',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('finance', '/why-financing', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_finance_why_financing',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Offer page
    register_rest_route('offers', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_offers_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('offers', '/about', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_offers_about',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('offers', '/metal-building', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_offers_metal_building',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // State page

    register_rest_route('state', '/banner', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_state_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('state', '/metal-building', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_state_metal_building',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('state', '/about', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_state_about',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('state', '/rto-finance', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_state_rto_finance',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    // Contact form

    register_rest_route('cfe/v1', '/request-quote', [
        'methods' => 'POST',
        'callback' => 'cfe_register_submission',
        'permission_callback' => 'vmg_home_meta_permission_check', // public endpoint
        'args' => [
            'name' => ['required' => true, 'type' => 'string'],
            'phone_number' => ['required' => true, 'type' => 'string'],
            'email' => ['required' => true, 'type' => 'string'],
            'state' => ['required' => true, 'type' => 'string'],
            'zipcode' => ['required' => true, 'type' => 'string'],
            'comment' => ['required' => false, 'type' => 'string'],
            'terms' => ['required' => true, 'type' => 'boolean'],
        ],
    ]);
    register_rest_route('cfe/v1', '/offer', [
        'methods' => 'POST',
        'callback' => 'cfe_offer_submission',
        'permission_callback' => 'vmg_home_meta_permission_check', // public endpoint
        'args' => [
            'name' => ['required' => true, 'type' => 'string'],
            'phone_number' => ['required' => true, 'type' => 'string'],
            'email' => ['required' => true, 'type' => 'string'],
            'comment' => ['required' => false, 'type' => 'string'],
        ],
    ]);

    // contact page

    register_rest_route('contact', '/data', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_contact_banner',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('blog', '/data', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_data',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('blog', '/list', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_list',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('blog', '/related', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_related',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('blog', '/load_more', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_blog_load_more',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('blog', '/details', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_detail',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('blog', '/views', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_views',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('blog', '/popular', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_popular',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('blog', '/categories', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_blog_category',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('infographics', '/list', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_infographics_list',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
    register_rest_route('infographics', '/load_more', array(
        'methods'  => 'POST',
        'callback' => 'vmg_get_infographics_load_more',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));

    register_rest_route('infographics', '/details', array(
        'methods'  => 'GET',
        'callback' => 'vmg_get_infographic_detail',
        'permission_callback' => 'vmg_home_meta_permission_check',
    ));
});