<?php


function vmg_get_head_seo_schema(WP_REST_Request $request){
    $slug = $request->get_param('slug');
    $data = [];
    // Check empty
    $og_site_name = get_bloginfo('name');
    $base_url = esc_url(home_url());

    $logo_id    = get_theme_mod('custom_logo');
    $logo_data  = wp_get_attachment_image_src($logo_id, 'full');
    $logo_url   = $logo_data ? $logo_data[0] : '';
    $logo_width = $logo_data ? $logo_data[1] : '';
    $logo_height = $logo_data ? $logo_data[2] : '';
    $date_published = '';
    $date_modified  = '';
    $webpage = '';
    $faq = '';
    $collectionPage = '';
    $script = '';
    $product_sc = '';
    $ImageObject = '';

    if (empty($slug)) {
        $post_id = get_option('page_on_front');

        if (! $post_id) {
            return new WP_Error('no_homepage', 'Homepage not set', array('status' => 404));
        }

        $yoast_title       = get_post_meta($post_id, '_yoast_wpseo_title', true);
        $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
        $yoast_description = get_post_meta($post_id, '_yoast_wpseo_metadesc', true);
        $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';
        $yoast_canonical   = get_post_meta($post_id, '_yoast_wpseo_canonical', true);
        $yoast_canonical = !empty($yoast_canonical) ? $yoast_canonical : home_url();
        $current_url = get_the_permalink($post_id);
        $date_published = get_the_date('c', $post_id);
        $date_modified  = get_the_modified_date('c', $post_id);

        $webpage = '{
                        "@context": "https://schema.org",
                        "@type": "WebPage",
                        "@id": "[site_url]#webpage",
                        "url": "[site_url]",
                        "inLanguage": "en-US",
                        "name": "'.$yoast_title.'",
                        "isPartOf": {
                            "@id": "[site_url]#website"
                        },
                        "about": {
                            "@id": "[site_url]#organization"
                        },';
                        if(has_post_thumbnail($post_id)){
                        $webpage .= '"primaryImageOfPage": {
                            "@id": "[site_url]/'.$slug.'#primaryimage"
                        },';
                        }
                        $webpage .= '"datePublished": "'.$date_published.'",
                        "dateModified": "'.$date_modified.'",
                        "description": "'.$yoast_description.'"
                        }';


    } else{
        $result = identify_slug_type($slug);
        $post_types = array('page', 'blog', 'infographics', 'manufacturer', 'product');
        if ( in_array($result['type'], $post_types)) {
            $post = get_page_by_path($slug, OBJECT, $result['type']);
            $post_id = $post->ID;

            $yoast_title       = get_post_meta($post_id, '_yoast_wpseo_title', true);
            $yoast_title = !empty($yoast_title) ? $yoast_title : get_the_title($post_id).' - '.$og_site_name;
            $yoast_description = get_post_meta($post_id, '_yoast_wpseo_metadesc', true);
            $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
            $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';
            $yoast_canonical   = get_post_meta($post_id, '_yoast_wpseo_canonical', true);
            $yoast_canonical = !empty($yoast_canonical) ? $yoast_canonical : get_the_permalink($post_id);
            $current_url = get_the_permalink($post_id);
            $date_published = get_the_date('c', $post->ID);
            $date_modified  = get_the_modified_date('c', $post->ID);
            $slug = get_post_field('post_name', $post->ID);

            $image_id  = get_post_thumbnail_id( $post->ID );
            $image_url = get_the_post_thumbnail_url( $post->ID, 'full' );
            $image_meta = wp_get_attachment_metadata( $image_id );

            $width  = isset( $image_meta['width'] ) ? $image_meta['width'] : '';
            $height = isset( $image_meta['height'] ) ? $image_meta['height'] : '';
            $alt_text   = get_post_meta( $image_id, '_wp_attachment_image_alt', true );


            if($result['type'] === 'product'){

                $yoast_meta = get_post_meta($post->ID, '_yoast_wpseo_metadesc', true);
                $yoast_meta = str_replace('"', " ", $yoast_meta);
                $medium_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'medium_large');
                $sku = get_post_meta($post->ID, 'sku', true );
                $prices = get_post_meta($post->ID, 'prices', true );


                $product_sc = '<script type="application/ld+json">
                                {
                                "@context": "https://schema.org/",
                                "@type": "Product",
                                "name": "'.$post->post_title.'",
                                "Image": "'.$medium_image_url[0].'",
                                "description": "'.$yoast_meta.'",
                                "brand": {
                                    "@type": "Brand",
                                    "name": "'.$og_site_name.'"
                                },
                                "sku": "'.$sku.'",
                                "offers": {
                                    "@type": "Offer",
                                    "url": "[site_url]/'.$slug.'",
                                    "priceCurrency": "USD",
                                    "price": "'.$prices.'"
                                }
                                }
                                </script>';

            }

            $webpage = '{
                        "@context": "https://schema.org",
                        "@type": "WebPage",
                        "@id": "[site_url]#webpage",
                        "url": "[site_url]",
                        "inLanguage": "en-US",
                        "name": "'.$yoast_title.'",
                        "isPartOf": {
                            "@id": "[site_url]#website"
                        },
                        "about": {
                            "@id": "[site_url]#organization"
                        },';
                        if(has_post_thumbnail($post->ID)){
                        $webpage .= '"primaryImageOfPage": {
                            "@id": "[site_url]/'.$slug.'#primaryimage"
                        },';
                        }
                        $webpage .= '"datePublished": "'.$date_published.'",
                        "dateModified": "'.$date_modified.'",
                        "description": "'.$yoast_description.'"
                        }';

                        if(has_post_thumbnail($post->ID)){
                            $ImageObject = '
                                {
                                "@type": "ImageObject",
                                "@id": "[site_url]/'.$slug.'#primaryimage",
                                "url": "'.$image_url.'",
                                "width": '.$width.',
                                "height": '.$height.',
                                "caption": "'.esc_html( $alt_text ?: html_entity_decode(get_the_title( $post->ID )) ).'"
                                }';
                        }


        } else if($result['type'] == 'product-taxonomy'){
            $term = get_term_by('slug', $slug, 'product-taxonomy');
            $term_id = $term->term_id;

            $tax_meta = get_option('wpseo_taxonomy_meta');
            // print_r($tax_meta);
            if (isset($tax_meta['product-taxonomy'][$term_id])) {
                $data =  $tax_meta['product-taxonomy'][$term_id];
                $yoast_title       = isset($data['wpseo_title']) ? $data['wpseo_title'] : $term->name;
                $yoast_description = isset($data['wpseo_desc']) ? $data['wpseo_desc'] : $term->description;
                $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
                $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';
                $yoast_canonical   = isset($data['wpseo_canonical']) ? $data['wpseo_canonical'] : get_term_link($term);
            }
            $term_meta = get_option("taxonomy_term_$term_id");
            $faq_list = isset($term_meta['faq_list']) ? $term_meta['faq_list'] : array();

                $current_url = get_term_link($term);
                $permalink = get_term_link($term);
                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

                if(!empty($faq_list)){
                    $faq .= '<script type="application/ld+json">
                                     {
                                        "@context": "https://schema.org",
                                        "@type": "FAQPage",
                                        "mainEntity": [';
                                        foreach ($faq_list['question'] as $index => $question) {
                                            $question = !empty($question) ? html_entity_decode(stripslashes($question))  : '';
                                            $answer = !empty($faq_list['answer'][$index]) ? html_entity_decode(stripslashes($faq_list['answer'][$index]))  : '';
                                            $faq .= '{
                                                        "@type": "Question",
                                                        "name": "'.esc_attr($question).'",
                                                        "acceptedAnswer": {
                                                            "@type": "Answer",
                                                            "text": "'.esc_attr($answer).'"
                                                        }
                                                    }';
                                        }

                    $faq .= ']
                                }
                                </script>';

                }




                $collectionPage = '{
                        "@type": "CollectionPage",
                        "@id": "[site_url]'.$item_url.'#webpage",
                        "url": "[site_url]'.$item_url.'",
                        "inLanguage": "en-US",
                        "name": "'.$yoast_title.'",
                        "isPartOf": {
                            "@id": "[site_url]#website"
                        },
                        "description": "'.$yoast_description.'"
                        }';

        } else {
            return new WP_Error('not_found', 'Page/Post/Category not found', array('status' => 404));
        }




    }

            $organization_website = '{
                            "@type": "Organization",
                            "@id": "[site_url]/#organization",
                            "name": "'.$og_site_name.'",
                            "url": "[site_url]",
                            "sameAs": [],
                            "logo": {
                                "@type": "ImageObject",
                                "@id": "[site_url]#logo",
                                "url": "'.$logo_url.'",
                                "width": '.$logo_width.',
                                "height": '.$logo_height.',
                                "caption": "'.$og_site_name.'"
                            },
                            "image": {
                                "@id": "[site_url]#logo"
                            }
                        },
                        {
                            "@type": "WebSite",
                            "@id": "[site_url]#website",
                            "url": "[site_url]",
                            "name": "'.$og_site_name.'",
                            "publisher": {
                                "@id": "[site_url]#organization"
                            },
                            "potentialAction": {
                                "@type": "SearchAction",
                                "target": "[site_url]?s={search_term_string}",
                                "query-input": "required name=search_term_string"
                            }
                        }';

        $script = '<script type="application/ld+json">
                    {
                    "@context": "https://schema.org",
                    "@graph": [

                        '.$organization_website.(!empty($ImageObject) ? ','.$ImageObject : '').(!empty($webpage) ? ','.$webpage : ''). (!empty($collectionPage) ? ','.$collectionPage : '').'
                    ]
                    }
                    </script>';

    return rest_ensure_response(array(
        'success'  => true,
        'page'   => $slug,
        'data' => $script,
        'faq_schema' => $faq,
        'product_schema' => $product_sc,
        // 'image_object_sc'=> '',
    ));
}
function vmg_get_head_seo_meta(WP_REST_Request $request){
    $slug = $request->get_param('slug');
    $data = [];
    // Check empty
    $og_site_name = get_bloginfo('name');
    $base_url = '[site_url]';

    if (empty($slug)) {
        $post_id = get_option('page_on_front');

        if (! $post_id) {
            return new WP_Error('no_homepage', 'Homepage not set', array('status' => 404));
        }

        $yoast_title       = get_post_meta($post_id, '_yoast_wpseo_title', true);
        $yoast_description = get_post_meta($post_id, '_yoast_wpseo_metadesc', true);
        $yoast_canonical   = get_post_meta($post_id, '_yoast_wpseo_canonical', true);
        $current_url = get_the_permalink($post_id);
        $yoast_canonical = !empty($yoast_canonical) ? $yoast_canonical : $current_url;
        $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
        $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';




    } else{
        $result = identify_slug_type($slug);
        $post_types = array('page', 'blog', 'infographics', 'manufacturer', 'product');
        if ( in_array($result['type'], $post_types)) {
            $post = get_page_by_path($slug, OBJECT, $result['type']);
            $post_id = $post->ID;
            $yoast_title       = get_post_meta($post_id, '_yoast_wpseo_title', true);
            $yoast_title = !empty($yoast_title) ? $yoast_title : get_the_title($post_id).' - '.$og_site_name;
            $yoast_description = get_post_meta($post_id, '_yoast_wpseo_metadesc', true);
            $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
            $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';
            $yoast_canonical   = get_post_meta($post_id, '_yoast_wpseo_canonical', true);
            $yoast_canonical = !empty($yoast_canonical) ? $yoast_canonical : get_the_permalink($post_id);
            $current_url = get_the_permalink($post_id);

        } else if($result['type'] == 'product-taxonomy'){
            $term = get_term_by('slug', $slug, 'product-taxonomy');
            $term_id = $term->term_id;

            $tax_meta = get_option('wpseo_taxonomy_meta');
            // print_r($tax_meta);
            if (isset($tax_meta['product-taxonomy'][$term_id])) {
                $data =  $tax_meta['product-taxonomy'][$term_id];
                $yoast_title       = isset($data['wpseo_title']) ? $data['wpseo_title'] : $term->name;
                $yoast_description = isset($data['wpseo_desc']) ? $data['wpseo_desc'] : $term->description;
                $yoast_title = !empty($yoast_title) ? html_entity_decode($yoast_title) : '';
                $yoast_description = !empty($yoast_description) ? html_entity_decode($yoast_description) : '';
                $yoast_canonical   = isset($data['wpseo_canonical']) ? $data['wpseo_canonical'] : get_term_link($term);
            }

            $current_url = get_term_link($term);

        } else {
            return new WP_Error('not_found', 'Page/Post/Category not found', array('status' => 404));
        }

    }

    if(!empty($yoast_canonical)){
        $permalink = $yoast_canonical;
        $backend_pos = strpos($permalink, '/backend/');
        $yoast_canonical = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
    }
    if(!empty($current_url)){
        $permalink = $current_url;
        $backend_pos = strpos($permalink, '/backend/');
        $current_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
    }

    $data['name']['author'] = $og_site_name;
    $data['name']['title'] = $yoast_title;
    $data['base']['href'] = '[site_url]';
    $data['name']['description'] = $yoast_description;
    $data['name']['canonical'] = '[site_url]'.$yoast_canonical;
    $data['name']['twitter_card'] = 'summary';
    $data['name']['twitter_description'] = $yoast_description;
    $data['name']['twitter_title'] = $yoast_title;


    $data['property']['og_locale'] = 'en_US';
    $data['property']['og_type'] = 'website';
    $data['property']['og_title'] = $yoast_title;
    $data['property']['og_description'] = $yoast_description;
    $data['property']['og_url'] = '[site_url]'.$current_url;
    $data['property']['og_site_name'] = $og_site_name;



    if ( function_exists( 'get_site_icon_url' ) ) {
        $icon = esc_url( get_site_icon_url() );
        $icon = !empty($icon) ? $icon : get_template_directory_uri().'/favicon.ico';
        $data['link']['icon'] = $icon;
    }

    return rest_ensure_response(array(
        'success'  => true,
        'page'   => '',
        'data' => $data
    ));
}

function vmg_get_web_redirection(WP_REST_Request $request){
    $slug = $request->get_param('slug');
    $data = [];
    $matched = false;

    global $wpdb;
    $table = $wpdb->prefix . 'redirection_items';
    $results = $wpdb->get_results("SELECT `match_url`, `action_code`, `action_data` FROM $table WHERE status = 'enabled'");

    if ( !empty($results) ) {

        foreach ($results as $value) {
            $old_url = !empty($value->match_url) ? wp_make_link_relative($value->match_url) : '';
            $new_url = !empty($value->action_data) ? wp_make_link_relative($value->action_data) : '';
            $action_code = !empty($value->action_code) ? $value->action_code : '';

            if(empty($new_url) && empty($action_code) && empty($old_url)){
                continue;
            }

            // Compare slug with match_url (new URL)
            if($old_url == '/' . ltrim($slug, '/')){
                $matched = true;
                $data['old_url'] = $old_url;
                $data['new_url'] = $new_url;
                $data['action_code'] = $action_code;
                break;
            }
        }

        if(!$matched){
            return new WP_Error('not_found', 'No redirection found, this page is clean.', array('status' => 404));
        }

    } else {
        return new WP_Error('not_found', 'No redirection found, this page is clean.', array('status' => 404));
    }

    return rest_ensure_response(array(
        'success'  => true,
        'data' => $data
    ));
}

function vmg_home_meta_permission_check($request)
{


    // Try different sources for Authorization header
    $username = $password = '';

    if (isset($_SERVER['PHP_AUTH_USER']) && isset($_SERVER['PHP_AUTH_PW'])) {
        $username = $_SERVER['PHP_AUTH_USER'];
        $password = $_SERVER['PHP_AUTH_PW'];
    } elseif (isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
    } elseif (function_exists('apache_request_headers')) {
        $headers = apache_request_headers();
        $auth_header = isset($headers['Authorization']) ? $headers['Authorization'] : '';
    }


    // Decode if needed
    if (empty($username) && !empty($auth_header) && stripos($auth_header, 'basic ') === 0) {
        $auth = base64_decode(trim(str_ireplace('basic', '', $auth_header)));
        if ($auth) {
            list($username, $password) = explode(':', $auth, 2);
        }
    }

    if (empty($username) || empty($password)) {
        return new WP_Error('no_auth_header', 'Authorization header missing.', array('status' => 401));
    }

    $user = wp_authenticate($username, $password);
    if (is_wp_error($user) || ! user_can($user, 'manage_options')) {
        return new WP_Error('forbidden', 'You are not allowed to access this endpoint.', array('status' => 403));
    }

    return true;
}
function vmg_get_home_data(WP_REST_Request $request)
{
    $post_id = get_option('page_on_front'); // Get homepage ID

    if (! $post_id) {
        return new WP_Error('no_homepage', 'Homepage not set', array('status' => 404));
    }

    $pageinfo = get_post_meta($post_id, '_vmg_page_info', true);


    $pageinfo['description'] = !empty($pageinfo['description']) ? wpautop($pageinfo['description']) : '';


    $data['banner'] = $pageinfo;
    $data['terms'] = get_post_meta($post_id, '_vmg_homepage_terms', true);
    $data['our_team'] = get_post_meta($post_id, '_vmg_homepage_our_team', true);
    $data['how_we_work'] = get_post_meta($post_id, '_vmg_homepage_how_we_work', true);
    $data['manufacturer'] = get_post_meta($post_id, '_vmg_homepage_manufacturer', true);

    $topsellingdata =  get_post_meta($post_id, '_vmg_homepage_top_selling', true);
    $about_desc = !empty($topsellingdata['about_desc']) ? wpautop($topsellingdata['about_desc']) : '';
    $topsellingdata['about_desc'] = $about_desc;
    $data['top_selling'] = $topsellingdata;
    $data['other_metal'] = get_post_meta($post_id, '_vmg_homepage_other_metal', true);
    $data['other_metal'] = get_post_meta($post_id, '_vmg_homepage_other_metal', true);
    $data['why_metal'] = get_post_meta($post_id, '_vmg_homepage_why_metal', true);
    $data['we_dont_let'] = get_post_meta($post_id, '_vmg_homepage_we_dont_let', true);
    $data['finance'] = get_post_meta($post_id, '_vmg_homepage_finance', true);
    $data['rto'] = get_post_meta($post_id, '_vmg_homepage_rto', true);
    $data['expert_tips'] = get_post_meta($post_id, '_vmg_homepage_expert_tips', true);

    return rest_ensure_response(array(
        'data' => $data,
    ));
}
// Callback function to return Building Specializations
function vmg_get_home_meta_buildings(WP_REST_Request $request)
{
    $params = $request->get_params();
    // print_r($params);
    $args = array(
        'post_type' => 'product',
        'orderby' => 'ID',
        'order' => 'DESC',
        'posts_per_page' => 6
    );
    if (!empty($params)) {
        $cat_id = isset($params['cat_id']) ? $params['cat_id'] : '';
        $width = isset($params['width']) ? $params['width'] : '';
        $height = isset($params['height']) ? $params['height'] : '';
        $length = isset($params['length']) ? $params['length'] : '';
        $roof_style = isset($params['roof_style']) ? $params['roof_style'] : '';
        $limit = isset($params['limit']) ? $params['limit'] : '';
        if ($cat_id && $roof_style) {
            $args['tax_query']['relation'] = 'AND';
        }
        if ($cat_id) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product-taxonomy',
                    'field'    => 'term_id', // or 'id' if you pass term_id
                    'terms'    => $cat_id,
                )
            );
        }
        if ($roof_style) {
            $args['tax_query'][] = array(
                'taxonomy' => 'product_roof_style',
                'field'    => 'slug',
                'terms'    => $roof_style,
            );
        }
        if ($width || $height || $length || $roof_style || $limit) {
            $args['meta_query']['relation'] = 'AND';
        }
        if ($width) {
            $args['meta_query'][] = array(
                    'key'     => 'width',
                    'value'   => $width,
                    'compare' => 'LIKE',
            );
        }
        if ($height) {
            $args['meta_query'][] = array(
                   'key'     => 'height',
                    'value'   => $height,
                    'compare' => 'LIKE',
            );
        }
        if ($length) {
            $args['meta_query'][] = array(
                'key'     => 'length',
                'value'   => $length,
                'compare' => 'LIKE',
            );
        }
        // if ($roof_style) {
        //     $args['meta_query'][] = array(
        //             'key'     => 'roof_style',
        //             'value'   => $roof_style,
        //             'compare' => 'LIKE',
        //     );
        // }
        if ($limit) {
            $args['meta_query'][] = array(
                'key'     => 'prices',
                'value'   => $limit,
                'compare' => '<=',
                'type'    => 'NUMERIC',
            );
        }
    }

    // print_r($args);


    $query = new WP_Query($args);
    $data = [];
    $i = 0;
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $excerpt = get_the_excerpt();
            $excerpt = substr(html_entity_decode($excerpt), 0, 250);

            $views = get_post_meta(get_the_ID(), 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $price = get_post_meta(get_the_ID(), 'prices', true);
            $price = !empty($price) ? $price : 0;
            $percent_value = '$0.00';
            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }

            $price = '$' . number_format($price);

            $slug = get_post_field('post_name', get_the_ID());

            $data[$i]['title'] = html_entity_decode(get_the_title());
            $data[$i]['image'] = get_the_post_thumbnail_url();
            $data[$i]['views'] = $views;
            $data[$i]['price'] = $price;
            $data[$i]['initial_payment'] = $percent_value;
            $data[$i]['short_description'] = $excerpt;
            $data[$i]['building_route'] = $slug;

            $i++;
        }
    } else {
        $data['error']['message'] = 'No Metal Building Found!';
    }

    return rest_ensure_response(array(
        'metal_buildings' => $data,
        'max_num_pages' => $query->max_num_pages,
    ));
}



function vmg_get_home_meta_buildings_load_more(WP_REST_Request $request)
{
    $params = $request->get_params();

    $params = $request->get_json_params();
    $paged = !empty($params['page']) ? intval($params['page']) : 1;
    // Example: load posts

    $args = array(
        'post_type' => 'product',
        'orderby' => 'ID',
        'order' => 'DESC',
        'posts_per_page' => 6,
        'paged' => $paged,
    );
    if (!empty($params)) {
        $cat_id = isset($params['cat_id']) ? $params['cat_id'] : '';
        $width = isset($params['width']) ? $params['width'] : '';
        $height = isset($params['height']) ? $params['height'] : '';
        $length = isset($params['length']) ? $params['length'] : '';
        $roof_style = isset($params['roof_style']) ? $params['roof_style'] : '';
        $limit = isset($params['limit']) ? $params['limit'] : '';

        if ($cat_id) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'product-taxonomy',
                    'field'    => 'term_id',
                    'terms'    => $cat_id,
                )
            );
        }
        if ($roof_style) {
            $args['tax_query'][] = array(
                'taxonomy' => 'product_roof_style',
                'field'    => 'slug',
                'terms'    => $roof_style,
            );
        }

        if ($width || $height || $length || $roof_style || $limit) {
            $args['meta_query']['relation'] = 'AND';
        }
        if ($width) {
            $args['meta_query'][] = array(
                    'key'     => 'width',
                    'value'   => $width,
                    'compare' => 'LIKE',
            );
        }
        if ($height) {
            $args['meta_query'][] = array(
                   'key'     => 'height',
                    'value'   => $height,
                    'compare' => 'LIKE',
            );
        }
        if ($length) {
            $args['meta_query'][] = array(
                'key'     => 'length',
                'value'   => $length,
                'compare' => 'LIKE',
            );
        }


        if ($limit) {
            $args['meta_query'][] = array(
                'key'     => 'prices',
                'value'   => $limit,
                'compare' => '<=',
                'type'    => 'NUMERIC',
            );
        }
    }


    $query = new WP_Query($args);
    $data = [];
    $i = 0;
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $excerpt = get_the_excerpt();
            $excerpt = substr(html_entity_decode($excerpt), 0, 250);

            $views = get_post_meta(get_the_ID(), 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $price = get_post_meta(get_the_ID(), 'prices', true);
            $price = !empty($price) ? $price : 0;
            $percent_value = '$0.00';
            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }
            $price = '$' . number_format($price);

            $slug = get_post_field('post_name', get_the_ID());

            $data[$i]['title'] = html_entity_decode(get_the_title());
            $data[$i]['image'] = get_the_post_thumbnail_url();
            $data[$i]['views'] = $views;
            $data[$i]['price'] = $price;
            $data[$i]['initial_payment'] = $percent_value;
            $data[$i]['short_description'] = $excerpt;
            $data[$i]['building_route'] = $slug;

            $i++;
        }
    } else {
        $data['error']['message'] = 'No metal buildings found.';
    }
    $paged++;
    return rest_ensure_response(array(
        'metal_buildings' => $data,
        'current_page' => !empty($params['page']) ? intval($params['page']) : 1,
        'next_page' => $query->max_num_pages >= $paged  ? $paged : 0,
        'total_pages' => $query->max_num_pages
    ));
}


// Callback function
function vmg_get_global_header(WP_REST_Request $request)
{
    // Menu Title (the actual name of the menu in WP dashboard)
    $menu_title = 'Header Menu';

    // Get menu object by title
    $menu = wp_get_nav_menu_object($menu_title);
    if (! $menu) {
        return rest_ensure_response(array('error' => 'Menu not found'));
    }

    // Get menu items by menu ID
    $menu_items = wp_get_nav_menu_items($menu->term_id);
    $items = array();

    if ($menu_items) {
        foreach ($menu_items as $item) {
            $items[] = array(
                'id'     => $item->ID,
                'title'  => $item->title,
                'url'    => $item->url,
                'parent' => $item->menu_item_parent,
                'order'  => $item->menu_order,
            );
        }
    }

    return rest_ensure_response($items);
}

// Callback function for global header submenu

function vmg_get_global_header_submenu(WP_REST_Request $request)
{
    // Menu Title (the actual name of the menu in WP dashboard)
    $params = $request->get_json_params();


    $parent = !empty($params['parent']) ? $params['parent'] : '';
    $menu_title = $parent;

    // Get menu object by title
    $menu = wp_get_nav_menu_object($menu_title);
    if (! $menu) {
        return rest_ensure_response(array('error' => 'Menu not found'));
    }

    // Get menu items by menu ID
    $menu_items = wp_get_nav_menu_items($menu->term_id);
    $items = array();


    if ($menu_items) {
        foreach ($menu_items as $item) {
            $image_id = get_post_meta($item->ID, '_menu_item_image', true);
            $show_on_hover = get_post_meta($item->ID, '_menu_item_hover_image', true);
            $show_on_hover = !empty($show_on_hover) ? true : false;
            if ($image_id) {
                $img = wp_get_attachment_url($image_id, 'thumbnail', false, ['class' => 'menu-item-icon']);
            }
            $item_url = $item->url;
            $permalink = $item->url;
            if (strpos($item->url, '/backend/') !== false) {
                // Remove '/backend/' from the URL


                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            } else {
                $item_url = parse_url($permalink, PHP_URL_PATH);
            }
            // die;
            $items[] = array(
                'id'     => $item->ID,
                'title'  => $item->title,
                'url'    => $item_url,
                'parent' => $item->menu_item_parent,
                'order'  => $item->menu_order,
                'image' => $img,
                'image_effect_on_hover' => $show_on_hover
            );
        }
    }

    return rest_ensure_response($items);
}

function vmg_get_global_header_featured_post(WP_REST_Request $request)
{

    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'meta_query'     => array(
            array(
                'key'   => '_is_featured',
                'value' => '1',
            )
        ),
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $featured_query = new WP_Query($args);
    $featured = [];
    if ($featured_query->have_posts()) {
        while ($featured_query->have_posts()) {
            $featured_query->the_post();

             $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;


            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $featured['title'] = html_entity_decode(get_the_title());
            $featured['image'] = $image_url;
            $featured['date'] = get_the_date('F j, Y');
            $featured['link'] = $item_url;
        }
        wp_reset_postdata();
    } else {
        $featured['error']['message'] = 'No blogs found.';
    }


    return rest_ensure_response($featured);
}

function vmg_get_global_header_search_post(WP_REST_Request $request)
{
    $params = $request->get_json_params();

    $myrows = $myrows1 = [];
    $searchkey = !empty($params['search']) ? trim($params['search']) : '';
    if(empty($searchkey)){
        return new WP_Error('not_found', 'No metal buildings found.', array('status' => 404));
    }
    global $wpdb;
    $postmeta = $wpdb->prefix . 'postmeta';
    $posts = $wpdb->prefix . 'posts';
    $myrows = $wpdb->get_results( "SELECT post_id FROM {$postmeta}  WHERE meta_value = '$searchkey' and  meta_key = 'sku'" );
    // print_r($myrows);
    if(empty($myrows))
    {
        $myrows1 = $wpdb->get_results( "SELECT ID FROM {$posts}  WHERE post_title like '%$searchkey%' and post_type='product' and post_status='publish' " );
    }

    if(!empty($myrows1)){
        $i = 0;
        foreach($myrows1 as $list){
            $post_id = $list->ID;
            $excerpt = get_the_excerpt($post_id);
            $excerpt = substr(html_entity_decode($excerpt), 0, 250);

            $views = get_post_meta($post_id, 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $price = get_post_meta($post_id, 'prices', true);
            $price = !empty($price) ? $price : 0;
            $percent_value = '$0.00';
            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }
            $price = '$' . number_format($price);

            $slug = get_post_field('post_name', $post_id);

            $data[$i]['title'] = html_entity_decode(get_the_title($post_id));
            $data[$i]['image'] = get_the_post_thumbnail_url($post_id);
            $data[$i]['views'] = $views;
            $data[$i]['price'] = $price;
            $data[$i]['initial_payment'] = $percent_value;
            $data[$i]['short_description'] = $excerpt;
            $data[$i]['building_route'] = $slug;

            $i++;
        }
    } elseif (!empty($myrows)){
        $i = 0;

        foreach($myrows as $row){
            $post_id = $row->post_id;
            $excerpt = get_the_excerpt($post_id);
            $excerpt = substr(html_entity_decode($excerpt), 0, 250);

            $views = get_post_meta($post_id, 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $price = get_post_meta($post_id, 'prices', true);
            $price = !empty($price) ? $price : 0;
            $percent_value = '$0.00';
            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }
            $price = '$' . number_format($price);

            $slug = get_post_field('post_name', $post_id);

            $data[$i]['title'] = html_entity_decode(get_the_title($post_id));
            $data[$i]['image'] = get_the_post_thumbnail_url($post_id);
            $data[$i]['views'] = $views;
            $data[$i]['price'] = $price;
            $data[$i]['initial_payment'] = $percent_value;
            $data[$i]['short_description'] = $excerpt;
            $data[$i]['building_route'] = $slug;
            $i++;
        }

    }else {
        $data['error']['message'] = 'No metal buildings found.';
    }

    return rest_ensure_response(array(
        'metal_buildings' => !isset($data['error']) ? $data : [],
        'search' => $searchkey,
        'count' => !isset($data['error']) ? count($data) : 0,
    ));
}

function vmg_get_home_meta_buildings_content(WP_REST_Request $request)
{
    $homepage_id = get_option('page_on_front'); // Get homepage ID

    if (! $homepage_id) {
        return new WP_Error('no_homepage', 'Homepage not set', array('status' => 404));
    }

    $metal_building_heading = get_post_meta($homepage_id, '_metal_building_heading', true);
    $metal_building_content = get_post_meta($homepage_id, '_metal_building_content', true);
    $data = [];
    if (!empty($metal_building_heading) && !empty($metal_building_content)) {
        $data['metal_building_heading'] = $metal_building_heading;
        $data['metal_building_content'] = $metal_building_content;
    } else {
        $data['error']['message'] = 'No content found for this section.';
    }
    return rest_ensure_response($data);
}

function vmg_get_home_product_category(WP_REST_Request $request)
{
    $homepage_id = get_option('page_on_front'); // Get homepage ID

    if (! $homepage_id) {
        return new WP_Error('no_homepage', 'Homepage not set', array('status' => 404));
    }


    $data = [];
    $selected_terms = get_post_meta($homepage_id, '_vmg_homepage_terms', true);


    if (is_array($selected_terms) && !empty($selected_terms)) {
        $i = 0;
        foreach ($selected_terms as $term_id) {
            $term = get_term_by('term_id', $term_id, 'product-taxonomy');

            $permalink = get_term_link($term);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $metaData = get_option('taxonomy_term_' . $term->term_id);
            $banner_image_url = isset($metaData['banner_image_url']) ? $metaData['banner_image_url'] : '';

            $data[$i]['cat_id'] = $term->term_id;
            $data[$i]['title'] = $term->name;
            $data[$i]['description'] = isset($metaData['banner_description']) ? $metaData['banner_description'] : '';
            $data[$i]['image'] = $banner_image_url;
            $data[$i]['route'] = $item_url;
            $i++;
        }
    } else {
        $data['error']['message'] = 'No product category found.';
    }
    return rest_ensure_response(array(
        'success' => true,
        'data'    => $data,
    ));
}

function vmg_get_home_latest_blog(WP_REST_Request $request)
{

    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 1,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $latest_query = new WP_Query($args);
    $latest_blog = [];
    $post_not_in = [];
    if ($latest_query->have_posts()) {
        while ($latest_query->have_posts()) {
            $latest_query->the_post();
            $post_not_in[] = get_the_ID();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;



            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $terms = wp_get_post_terms(get_the_ID(), 'blog_category');

            $latest_blog['right']['title'] = html_entity_decode(get_the_title());
            $latest_blog['right']['image'] = $image_url;
            $latest_blog['right']['date'] = get_the_date('F j, Y');
            $latest_blog['right']['link'] = $item_url;
            $latest_blog['right']['description'] = get_the_excerpt();
            $latest_blog['right']['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
        }
        wp_reset_postdata();

        $args = array(
            'post_type'      => 'blog',
            'posts_per_page' => 2,
            'post_status'    => 'publish',
            'orderby'        => 'date',
            'order'          => 'DESC',
            'post__not_in'   => $post_not_in,
        );
        $latest_query1 = new WP_Query($args);
        if ($latest_query1->have_posts()) {
            $i = 0;
            while ($latest_query1->have_posts()) {
                $latest_query1->the_post();

                $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                $image_url = !empty($image_url) ? $image_url : false;


                $permalink = get_the_permalink();
                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
                $terms = wp_get_post_terms(get_the_ID(), 'blog_category');

                $latest_blog['left'][$i]['title'] = html_entity_decode(get_the_title());
                $latest_blog['left'][$i]['image'] = $image_url;
                $latest_blog['left'][$i]['date'] = get_the_date('F j, Y');
                $latest_blog['left'][$i]['link'] = $item_url;
                $latest_blog['left'][$i]['description'] = get_the_excerpt();
                $latest_blog['left'][$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';

                $i++;
            }
            wp_reset_postdata();
        }
    } else {
        $latest_blog['error']['message'] = 'No blogs found.';
    }


    return rest_ensure_response($latest_blog);
}

function vmg_get_global_footer_explore(WP_REST_Request $request)
{
    $manufacturers = [];
    $states = [];
    // Manufacturers
    $query = new WP_Query([
        'post_type'      => 'manufacturer',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
    ]);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();

            $image_f_id = get_post_meta(get_the_ID(), '_footer_brand_logo_id', true);
            $image_url = $image_f_id ? wp_get_attachment_image_url($image_f_id, 'medium') : '';

            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/manufacturer/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/manufacturer')) : parse_url($permalink, PHP_URL_PATH);

            $manufacturers[] = [
                'route' => $item_url,
                'logo'  => $image_url
            ];
        }
        wp_reset_postdata();
    }

    // States
    $query1 = new WP_Query([
        'post_type'      => 'page',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'meta_key'       => '_wp_page_template',
        'meta_value'     => 'state-pages.php',
        'order'          => 'ASC',
        'orderby'        => 'title',
    ]);
    // print_r($query1);
    if ($query1->have_posts()) {
        while ($query1->have_posts()) {
            $query1->the_post();
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url(get_the_permalink(), PHP_URL_PATH);

            $states[] = [
                'route' => $item_url,
                'name'  => html_entity_decode(get_the_title())
            ];
        }
        wp_reset_postdata();
    }

    $data = [
        'manufacturers' => $manufacturers,
        'states'        => $states,
    ];

    return rest_ensure_response([
        'success' => true,
        'data'    => $data,
    ]);
}



function vmg_get_global_footer(WP_REST_Request $request)
{
    $params = $request->get_json_params();
    $items  = array();


    $sidebar_id = ! empty($params['parent']) ? sanitize_text_field($params['parent']) : '';
    if (empty($sidebar_id)) {
        return new WP_Error(
            'missing_sidebar',
            __('Sidebar ID (parent) is required.', 'vmg'),
            array('status' => 400)
        );
    }


    $widgets  = get_option('widget_nav_menu', array());
    $sidebars = get_option('sidebars_widgets', array());


    if (empty($sidebars[$sidebar_id])) {
        return new WP_Error(
            'sidebar_not_found',
            sprintf(__('No widgets found for sidebar: %s', 'vmg'), esc_html($sidebar_id)),
            array('status' => 404)
        );
    }

    $i = 0;
    foreach ($sidebars[$sidebar_id] as $widget_id) {

        if (strpos($widget_id, 'nav_menu') !== false) {
            $id = str_replace('nav_menu-', '', $widget_id);


            if (empty($widgets[$id]['nav_menu'])) {
                continue;
            }

            $menu_id   = absint($widgets[$id]['nav_menu']);
            $menu_name = ! empty($widgets[$id]['title']) ? $widgets[$id]['title'] : '';


            $menu_items = wp_get_nav_menu_items($menu_id);
            if (empty($menu_items)) {
                continue;
            }

            $items[$i]['title'] = $menu_name;
            $items[$i]['items'] = array();

            foreach ($menu_items as $item) {
                $item_url = $item->url;


                if (strpos($item->url, '/backend/') !== false) {

                    $permalink = $item->url;
                    $backend_pos = strpos($permalink, '/backend/');
                    $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
                }

                $items[$i]['items'][] = array(
                    'id'     => $item->ID,
                    'title'  => $item->title,
                    'url'    => $item_url,
                    'parent' => $item->menu_item_parent,
                    'order'  => $item->menu_order,
                );
            }
            $i++;
        }
    }


    if (empty($items)) {
        return new WP_Error(
            'no_menus_found',
            __('No navigation menus found in the given sidebar.', 'vmg'),
            array('status' => 404)
        );
    }

    return rest_ensure_response($items);
}



function vmg_get_pc_banner(WP_REST_Request $request)
{
    $cat_slug = $request->get_param('cat_slug');

    // Check empty
    if (empty($cat_slug)) {
        return rest_ensure_response(array('error' => 'Category slug parameter is required'));
    }

    // Validate term
    $category = get_term_by('slug', $cat_slug, 'product-taxonomy');
    $data = [];
    if (! $category) {
        return rest_ensure_response(array('error' => 'Invalid Category Slug No matching category found.'));
    } else {
        $term_meta = get_option("taxonomy_term_$category->term_id");
        $banner_images = isset($term_meta['banner_images']) ? $term_meta['banner_images'] : '';

        $data['title'] = !empty($term_meta['cat_title']) ? html_entity_decode($term_meta['cat_title']) : $category->name;
        $data['description'] = isset($term_meta['banner_description']) ? html_entity_decode($term_meta['banner_description']) : '';
        $data['images'] = !empty($banner_images) ? explode(',', $banner_images) : array();
        $data['number'] = isset($term_meta['phone_number']) ? html_entity_decode($term_meta['phone_number']) : '';
    }


    return rest_ensure_response(array(
        'success'  => true,
        'cat_id'   => $category->term_id,
        'data' => $data
    ));
}

function vmg_get_pc_metal_buildings(WP_REST_Request $request)
{
    $cat_slug = $request->get_param('cat_id');

    // Check empty
    if (empty($cat_slug)) {
        return rest_ensure_response(array('error' => 'Category ID parameter is required'));
    }

    // Validate term
    $category = get_term_by('id', $cat_slug, 'product-taxonomy');
    $data = [];
    if (! $category) {
        return rest_ensure_response(array('error' => 'Invalid Category ID. No matching category found.'));
    } else {
        $term_meta = get_option("taxonomy_term_$category->term_id");

        $data['popular_building_title'] = isset($term_meta['popular_building_title']) ? html_entity_decode($term_meta['popular_building_title']) : '';
        $data['popular_building_subtitle'] = isset($term_meta['popular_building_subtitle']) ? html_entity_decode($term_meta['popular_building_subtitle']) : '';
    }


    return rest_ensure_response(array(
        'success'  => true,
        'cat_id'   => $category->term_id,
        'data' => $data
    ));
}


function vmg_get_pc_about_category(WP_REST_Request $request)
{
    $cat_id = $request->get_param('cat_id');

    if (empty($cat_id)) {
        return rest_ensure_response(array(
            'success' => false,
            'message' => 'Category ID is required'
        ));
    }
    $category = get_term_by('id', $cat_id, 'product-taxonomy');
    $data = [];
    $child_cat = [];
    if (! $category) {
        return rest_ensure_response(array('error' => 'Invalid Category ID. No matching category found.'));
    }


    $saved_roof_styles = get_option('vmg_roof_styles', array());
    $saved_benefits = get_option('vmg_benefits', array());
    $child_categories = get_terms(array(
        'taxonomy'   => 'product-taxonomy', // replace with your taxonomy name
        'hide_empty' => false,
        'parent'     => $cat_id,
    ));

    $term_meta = get_option("taxonomy_term_$cat_id");

    // Prepare response
    if (!empty($term_meta['category_terms'])) {
        foreach ($term_meta['category_terms'] as $term_id) {
            $child = get_term_by('id', $term_id, 'product-taxonomy');
            $cterm_meta = get_option("taxonomy_term_$child->term_id");
            $banner_image = isset($cterm_meta['banner_image_url']) ? $cterm_meta['banner_image_url'] : '';

            $permalink = get_term_link($child);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $child_cat[] = array(
                'id'    => $child->term_id,
                'name'  => $child->name,
                'slug'  => $child->slug,
                'description'  => isset($cterm_meta['banner_description']) ? $cterm_meta['banner_description'] : '',
                'image'  => $banner_image,
                'link'  => $item_url,
            );
        }
    } else if (empty($term_meta['category_terms']) && !empty($child_categories) && empty($term_meta['show_terms'])) {
        foreach ($child_categories as $child) {
            $cterm_meta = get_option("taxonomy_term_$child->term_id");
            $banner_image = isset($cterm_meta['banner_image_url']) ? $cterm_meta['banner_image_url'] : '';

            $permalink = get_term_link($child);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $child_cat[] = array(
                'id'    => $child->term_id,
                'name'  => $child->name,
                'slug'  => $child->slug,
                'description'  => isset($cterm_meta['banner_description']) ? $cterm_meta['banner_description'] : '',
                'image'  => $banner_image,
                'link'  => $item_url,
            );
        }
    }



    $data['about']['about_cat_title'] = isset($term_meta['about_cat_title']) ? html_entity_decode($term_meta['about_cat_title']) : '';
    $data['about']['about_cat_description'] = !empty($term_meta['about_cat_description']) ? wpautop(html_entity_decode($term_meta['about_cat_description'])) : '';

    $data['roof_style']['roof_style_title'] = isset($term_meta['roof_style_title']) ? html_entity_decode($term_meta['roof_style_title']) : '';
    $data['roof_style']['roof_style_description'] = !empty($term_meta['roof_style_description']) ? wpautop(html_entity_decode($term_meta['roof_style_description'])) : '';
    $data['roof_style']['roofs'] = $saved_roof_styles;

    $data['benefits']['benefits_title'] = isset($term_meta['benefits_title']) ? html_entity_decode($term_meta['benefits_title']) : '';
    $data['benefits']['benefits'] = !empty($term_meta['benefits']) ? wp_unslash($term_meta['benefits']) : $saved_benefits;

    $data['type']['type_title'] = isset($term_meta['type_title']) ? html_entity_decode($term_meta['type_title']) : '';
    $data['type']['type_description'] = !empty($term_meta['type_description']) ? wpautop(html_entity_decode($term_meta['type_description'])) : '';
    $data['type']['type_content'] = !empty($term_meta['type_content']) ? wpautop(html_entity_decode($term_meta['type_content'])) : '';
    $data['type']['category_terms'] = !empty($child_cat) ? $child_cat : array();

    $data['garage']['garage_title'] = isset($term_meta['garage_title']) ? html_entity_decode($term_meta['garage_title']) : '';
    $data['garage']['garage_description'] = !empty($term_meta['garage_description']) ? wpautop(html_entity_decode($term_meta['garage_description'])) : '';

    $data['feature']['feature_title'] = isset($term_meta['feature_title']) ? html_entity_decode($term_meta['feature_title']) : '';
    $data['feature']['feature_description'] = !empty($term_meta['feature_description']) ? wpautop(html_entity_decode($term_meta['feature_description'])) : '';

    $data['why_choose']['why_choose_title'] = isset($term_meta['why_choose_title']) ? html_entity_decode($term_meta['why_choose_title']) : '';
    $data['why_choose']['why_choose_description'] = !empty($term_meta['why_choose_description']) ? wpautop(html_entity_decode($term_meta['why_choose_description'])) : '';

    $data['offers']['offers_title'] = isset($term_meta['offers_title']) ? html_entity_decode($term_meta['offers_title']) : '';
    $data['offers']['offers_description'] = !empty($term_meta['offers_description']) ? wpautop(html_entity_decode($term_meta['offers_description'])) : '';
    $data['offers']['call_us_text'] = isset($term_meta['call_us_text']) ? html_entity_decode($term_meta['call_us_text']) : '';


    return rest_ensure_response(array(
        'success' => true,
        'cat_id' => $cat_id,
        'about_category'    => $data
    ));
}


function vmg_get_pc_faq(WP_REST_Request $request)
{
    $cat_id = $request->get_param('cat_id');

    if (empty($cat_id)) {
        return rest_ensure_response(array(
            'success' => false,
            'message' => 'Category ID is required'
        ));
    }

    $term_meta = get_option("taxonomy_term_$cat_id");
    $faq_items = $term_meta['faq_list'];
    $faq_list = [];

    if (!empty($faq_items)) {
        foreach ($faq_items['question'] as $index => $question) {
            $question = !empty($question) ? html_entity_decode(stripslashes($question))  : '';
            $answer = !empty($faq_items['answer'][$index]) ? html_entity_decode(stripslashes($faq_items['answer'][$index]))  : '';
            $faq_list['question'][] = $question;
            $faq_list['answer'][] = $answer;

        }
    }

    $faq_title = !empty($term_meta['faq_titlen']) ? html_entity_decode($term_meta['faq_titlen']) : '';
    $faq_description = !empty($term_meta['faq_descriptionn']) ? html_entity_decode($term_meta['faq_descriptionn']) : '';

    return rest_ensure_response(array(
        'success' => true,
        'cat_id' => $cat_id,
        'title' => $faq_title,
        'faq_description' => $faq_description,
        'faqs'    => $faq_list

    ));
}

function vmg_get_pc_filter_options(WP_REST_Request $request)
{

$cat_id = $request->get_param('cat_id');

    if (empty($cat_id)) {
        return rest_ensure_response(array(
            'success' => false,
            'message' => 'Category ID is required'
        ));
    }
    $args = array(
        'post_type' => 'product',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'tax_query' => array(
            array(
                'taxonomy' => 'product-taxonomy',
                'field' => 'term_id',
                'terms' => $cat_id
            )
        )
    );

    // print_r($args);
    $width = $length = $height = $roof_style = [];
    $query = new WP_Query($args);
    if($query->have_posts()){
        while($query->have_posts()){
            $query->the_post();
            $data = get_post_meta(get_the_ID(), 'product_property', true);
            $data = isset($data[0]) ? $data[0] : array();

            $length_val = get_post_meta(get_the_ID(), 'length', true);
            $width_val = get_post_meta(get_the_ID(), 'width', true);
            $height_val = get_post_meta(get_the_ID(), 'height', true);


            // $width[] = isset($data['width']) ? $data['width'] : '';
            // $length[] = isset($data['length']) ? $data['length'] : '';
            // $height[] = isset($data['height']) ? $data['height'] : '';


            if (!empty($length_val) && !in_array($length_val, $length)) {
                $length[] = $length_val;
            }
            if (!empty($width_val) && !in_array($width_val, $width)) {
                $width[] = $width_val;
            }
            if (!empty($height_val) && !in_array($height_val, $height)) {
                $height[] = $height_val;
            }

            $taxonomy = 'product_roof_style';
            $terms = wp_get_post_terms(get_the_ID(), $taxonomy);
            if (!empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $roof_style[$term->slug] = $term->name;
                }
            }
        }
    }


    if(!empty($width)){
        $filteredwidth = array_filter($width, function($value) {
            return !empty(trim((string)$value));
        });
        $uniquewidth = array_unique($filteredwidth);
        sort($uniquewidth);
        $cleanedwidth = array_values($uniquewidth);
    }

    if(!empty($length)){
        $filteredlength = array_filter($length, function($value) {
            return !empty(trim((string)$value));
        });
        $uniquelength = array_unique($filteredlength);
        sort($uniquelength);
        $cleanedlength = array_values($uniquelength);
    }

    if(!empty($height)){
        $filteredheight = array_filter($height, function($value) {
            return !empty(trim((string)$value));
        });
        $uniqueheight = array_unique($filteredheight);
        sort($uniqueheight);
        $cleanedheight = array_values($uniqueheight);
    }



    return rest_ensure_response(array(
        'success' => true,
        'width' => $cleanedwidth,
        'length' => $cleanedlength,
        'height' => $cleanedheight,
        'roof_styles'    => $roof_style
    ));
}



function vmg_get_product_detail_data(WP_REST_Request $request)
{
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Product slug is required'));
    }
    $product_id = 0;
    $post = get_page_by_path($slug, OBJECT, 'product');
    $percent_value = '$0.00';
    $price = 0;
    if (!empty($post) && is_object($post)) {
        $product_id = $post->ID;
        if (get_post_type($product_id) !== 'product') {
            return rest_ensure_response(array('error' => 'Product ID is not valid'));
        } else {
            $images = [];
            if (has_post_thumbnail($product_id)) {
                $images['featured'] = get_the_post_thumbnail_url($product_id);
            }

            $terms = get_the_terms($product_id, 'product-taxonomy');
            $parent_cat_name = [];

            // print_r($terms);
            if ($terms && !is_wp_error($terms)) {
                $term = $terms[0];
                $parent_cat_name['name'] = html_entity_decode($term->name);
                $permalink = get_term_link($term);
                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
                $parent_cat_name['route'] = $item_url;

                while ($term->parent) {
                    $term = get_term($term->parent, 'product-taxonomy');
                    if (!is_wp_error($term)) {

                        $parent_cat_name['parent_name'] = html_entity_decode($term->name);

                        $permalink = get_term_link($term);
                        $backend_pos = strpos($permalink, '/backend/');
                        $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
                        $parent_cat_name['parent_route'] = $item_url;
                    } else {
                        break;
                    }
                }
            }




            $data = get_post_meta($product_id, 'product_property', true);
            $data = isset($data[0]) ? $data[0] : array();


// print_r($data);
            $price = isset($data['prices']) && !empty($data['prices']) ? $data['prices'] : 0;

            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }

            $rto_page = get_page_by_path('rent-to-own-metal-buildings', OBJECT, 'page');
            $rto_limit = get_post_meta($rto_page->ID, '_rto_metal_building_price_limit', true);
            $rto_limit = !empty($rto_limit) ? $rto_limit : 20000;

            $image1 = isset($data['product-slide-image-1']) ? $data['product-slide-image-1'] : '';
            $image1_url = !empty($image1) ? wp_get_attachment_image_url($image1, 'full') : '';

            $image2 = isset($data['product-slide-image-2']) ? $data['product-slide-image-2'] : '';
            $image2_url = !empty($image2) ? wp_get_attachment_image_url($image2, 'full') : '';

            $image3 = isset($data['product-slide-image-3']) ? $data['product-slide-image-3'] : '';
            $image3_url = !empty($image3) ? wp_get_attachment_image_url($image3, 'full') : '';

            $image4 = isset($data['product-slide-image-4']) ? $data['product-slide-image-4'] : '';
            $image4_url = !empty($image4) ? wp_get_attachment_image_url($image4, 'full') : '';

            $image5 = isset($data['product-slide-image-5']) ? $data['product-slide-image-5'] : '';
            $image5_url = !empty($image5) ? wp_get_attachment_image_url($image5, 'full') : '';

            $image6 = isset($data['product-slide-image-6']) ? $data['product-slide-image-6'] : '';
            $image6_url = !empty($image6) ? wp_get_attachment_image_url($image6, 'full') : '';

            $image = [$image1_url, $image2_url, $image3_url, $image4_url, $image5_url, $image6_url];
            $images['images'] = !empty($image) ? array_filter($image) : '';

            $views = get_post_meta($product_id, 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $permalink = get_the_permalink($product_id);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
        }
    } else {
        return rest_ensure_response(array('error' => 'Product slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'product_id' => $product_id,
        'title' => html_entity_decode(get_the_title($product_id)),
        'description' => $post->post_content,
        'images'    => $images,
        'data'    => $data,
        'initial_payment' => $percent_value,
        'views' => !empty($views) ? $views : 0,
        'navigation' => !empty($parent_cat_name) ? $parent_cat_name : [],
        'rto_limit' => $price > $rto_limit ? false : true,
        'product_route' => $item_url
    ));
}


function vmg_get_product_similar_buildings(WP_REST_Request $request)
{
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Product slug is required'));
    }
    $product_id = 0;
    $data = [];
    $post = get_page_by_path($slug, OBJECT, 'product');
    if (!empty($post) && is_object($post)) {
        $product_id = $post->ID;
        if (get_post_type($product_id) !== 'product') {
            return rest_ensure_response(array('error' => 'Product ID is not valid'));
        } else {
            $categories = wp_get_post_terms($product_id, 'product-taxonomy', array('fields' => 'ids'));

            $args = array(
                'post_type'      => 'product',
                'posts_per_page' => 8,
                'post__not_in'   => array($product_id),
                'tax_query'      => array(
                    array(
                        'taxonomy' => 'product-taxonomy',
                        'field'    => 'term_id',
                        'terms'    => $categories,
                    ),
                ),
            );

            $similar_products = new WP_Query($args);


            $i = 0;
            if ($similar_products->have_posts()) {
                while ($similar_products->have_posts()) {
                    $similar_products->the_post();
                    $excerpt = get_the_excerpt();
                    $excerpt = substr(html_entity_decode($excerpt), 0, 250);

                    $views = get_post_meta(get_the_ID(), 'total_views', true);
                    $views = !empty($views) ? $views : 0;

                    $price = get_post_meta(get_the_ID(), 'prices', true);
                    $price = !empty($price) ? $price : 0;
                    $percent_value = '$0.00';
                    if($price !== 0){
                        $percentage = 17;
                        $percent_value = ($price * $percentage) / 100;
                        $percent_value = '$' . number_format($percent_value, 2);
                    }
                    $price = '$' . number_format($price);

                    $slug = get_post_field('post_name', get_the_ID());

                    $data[$i]['title'] = html_entity_decode(get_the_title());
                    $data[$i]['image'] = get_the_post_thumbnail_url();
                    $data[$i]['views'] = $views;
                    $data[$i]['price'] = $price;
                    $data[$i]['initial_payment'] = $percent_value;
                    $data[$i]['short_description'] = $excerpt;
                    $data[$i]['building_route'] = $slug;

                    $i++;
                }
            }
        }
    } else {
        return rest_ensure_response(array('error' => 'Product slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'product_id' => $product_id,
        'data'    => $data,
    ));
}

function vmg_get_product_views(WP_REST_Request $request)
{
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Product slug is required'));
    }


    $post = get_page_by_path($slug, OBJECT, 'product');

    if (empty($post) || !is_object($post)) {
        return rest_ensure_response(array('error' => 'Product slug is not valid'));
    }

    $product_id = $post->ID;

    if (get_post_type($product_id) !== 'product') {
        return rest_ensure_response(array('error' => 'Product ID is not valid'));
    }


    $views = get_post_meta($product_id, 'total_views', true);
    $views = !empty($views) ? (int) $views : 0;


    $views++;
    update_post_meta($product_id, 'total_views', $views);


    return rest_ensure_response(array(
        'success' => true,
        'product_id' => $product_id,
        'views' => $views,
    ));
}


function vmg_get_rto_banner(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['page_title'] = get_post_meta($post->ID, '_rto_banner_page_title', true);
        $data['page_subtitle'] = get_post_meta($post->ID, '_rto_banner_page_subtitle', true);
        $data['description'] = get_post_meta($post->ID, '_rto_banner_description', true);
        $images = get_post_meta($post->ID, '_rto_banner_images', true);
        $data['banner_images'] = !empty($images) ? explode(',', $images) : array();
        $data['phone_number'] = get_post_meta($post->ID, '_rto_banner_phone', true);
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}


function vmg_get_rto_calculateSection(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $rto_limit = get_post_meta($post_id, '_rto_metal_building_price_limit', true);
        $rto_limit = !empty($rto_limit) ? $rto_limit : 20000;
        $data['section_title'] = get_post_meta($post->ID, '_rto_calculate_section_title', true);
        $data['section_subtitle'] = get_post_meta($post->ID, '_rto_calculate_section_subtitle', true);
         $data['rto_limit'] = $rto_limit;
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_rto_topbuilding(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['section_title'] = get_post_meta($post->ID, '_rto_metal_building_title', true);
        $data['section_subtitle'] = get_post_meta($post->ID, '_rto_metal_building_subtitle', true);
        $data['building_price_limit'] = get_post_meta($post->ID, '_rto_metal_building_price_limit', true);
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}


function vmg_get_rto_about(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');
    $process = get_option('vmg_process', []);

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;

        $data['section_title'] = get_post_meta($post->ID, '_rto_about_section_title', true);
        $about_des = get_post_meta($post->ID, '_rto_about_section_description', true);
        $data['section_description'] = !empty($about_des) ? wpautop($about_des) : '';


        $data['benefits']['section_title'] = get_post_meta($post->ID, '_rto_benefits_section_title', true);
        $data['benefits']['section_subtitle'] = get_post_meta($post->ID, '_rto_benefits_section_subtitle', true);
        $benefits_json = get_post_meta($post->ID, '_rto_benefits_list', true);
        $data['benefits']['benefits_json'] = $benefits_json ? json_decode($benefits_json, true) : array();

        $data['process']['section_title'] = get_post_meta($post->ID, '_rto_process_section_title', true);
        $data['process']['section_subtitle'] = get_post_meta($post->ID, '_rto_process_section_subtitle', true);
        $data['process']['list'] = $process;

        $data['credit']['section_title'] = get_post_meta($post->ID, '_rto_credit_section_title', true);
        $data['credit']['section_subtitle'] = get_post_meta($post->ID, '_rto_credit_section_subtitle', true);
        $data['credit']['phone_number'] = get_post_meta($post->ID, '_rto_credit_phone', true);
        $data['credit']['financing_btn_link'] = get_post_meta($post->ID, '_rto_credit_financing_link', true);
        $data['credit']['mobile_image'] = get_post_meta($post->ID, '_rto_credit_mobile_image', true);

        $data['prices']['section_title'] = get_post_meta($post->ID, '_rto_prices_section_title', true);
        $price_des = get_post_meta($post->ID, '_rto_prices_section_description', true);
        $data['prices']['section_description'] = !empty($price_des) ? wpautop($price_des) : '';

        $data['financing']['section_title'] = get_post_meta($post->ID, '_rto_vs_financing_section_title', true);
        $finance_des = get_post_meta($post->ID, '_rto_vs_financing_section_description', true);
        $data['financing']['section_description'] = !empty($finance_des) ? wpautop($finance_des) : '';
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}


function vmg_get_rto_partners(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');
    $partners = get_option('vmg_partners', []);
    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['section_title'] = get_post_meta($post->ID, '_rto_partners_section_title', true);
        $data['section_subtitle'] = get_post_meta($post->ID, '_rto_partners_section_subtitle', true);
        $data['partner_list'] = $partners;

        if (!empty($partners)) {
            foreach ($partners as $index => $partner) {
                $partners[$index]['description'] = !empty($partner['description']) ? wpautop($partner['description']) : '';
            }
        }
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_rto_faq(WP_REST_Request $request)
{
    $rto_slug = $request->get_param('slug');

    if (empty($rto_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($rto_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['section_title'] = get_post_meta($post->ID, '_rto_faq_section_title', true);
        $data['section_subtitle'] = get_post_meta($post->ID, '_rto_faq_section_subtitle', true);
        $faq_json = get_post_meta($post->ID, '_rto_faq_list', true);
        $data['faq_json'] = $faq_json ? json_decode($faq_json, true) : array();
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_rto_previously_viewed(WP_REST_Request $request)
{
    $params = $request->get_params();
    // print_r($params);

    $ids = isset($params['ids']) ? $params['ids'] : '';
    $limit = isset($params['limit']) ? $params['limit'] : '';
    $ids = !empty($ids) ? explode(',', $ids) : array();
    $product_ids = [];
    if(!empty($ids)){
        foreach ($ids as $slug) {
            $post = get_page_by_path($slug, OBJECT, 'product');
            if (!empty($post) && is_object($post)) {
                $product_ids[] = $post->ID;
            }
        }
    }
    $args = array(
        'post_type' => 'product',
        'orderby' => 'ID',
        'order' => 'DESC',
        'posts_per_page' => -1,
        'post__in' => $product_ids,
    );
    if ($limit) {
        $args['meta_query'][] = array(
            'key'     => 'prices',
            'value'   => $limit,
            'compare' => '<=',
            'type'    => 'NUMERIC',
        );
    }

    // print_r($args);



    $query = new WP_Query($args);
    $data = [];
    $i = 0;
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $excerpt = get_the_excerpt();
            $excerpt = substr(html_entity_decode($excerpt), 0, 250);

            $views = get_post_meta(get_the_ID(), 'total_views', true);
            $views = !empty($views) ? $views : 0;

            $price = get_post_meta(get_the_ID(), 'prices', true);
            $price = !empty($price) ? $price : 0;
            $percent_value = '$0.00';
            if($price !== 0){
                $percentage = 17;
                $percent_value = ($price * $percentage) / 100;
                $percent_value = '$' . number_format($percent_value, 2);
            }
            $price = '$' . number_format($price);

            $slug = get_post_field('post_name', get_the_ID());

            $data[$i]['title'] = html_entity_decode(get_the_title());
            $data[$i]['image'] = get_the_post_thumbnail_url();
            $data[$i]['views'] = $views;
            $data[$i]['price'] = $price;
            $data[$i]['initial_payment'] = $percent_value;
            $data[$i]['short_description'] = $excerpt;
            $data[$i]['building_route'] = $slug;

            $i++;
        }
    } else {
        $data['error']['message'] = 'No Metal Building Found!';
    }

    return rest_ensure_response(array(
        'metal_buildings' => $data,
        'max_num_pages' => $query->max_num_pages,
    ));
}



function vmg_get_manufacturer_banner(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Manufacturer slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'manufacturer');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $logo = get_post_meta($post_id, '_brand_logo_id', true);
        $logo_url = !empty($logo) ? wp_get_attachment_url($logo) : '';
        $data['title'] = html_entity_decode(get_the_title($post_id));
        $data['description'] = strip_tags(html_entity_decode($post->post_content));
        $data['logo'] = $logo_url;
        $data['image'] = has_post_thumbnail($post_id) ? get_the_post_thumbnail_url($post_id, 'full') : '';
    } else {
        return rest_ensure_response(array('error' => 'Manufacturer slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'manufacturer_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_manufacturer_metal_building(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Manufacturer slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'manufacturer');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $title = get_post_meta($post_id, '_top_selling_title', true);
        $subtitle = get_post_meta($post_id, '_top_selling_subtitle', true);

        $title = !empty($title) ? html_entity_decode($title) : '';
        $subtitle = !empty($subtitle) ? html_entity_decode($subtitle) : '';
        $data['title'] = $title;
        $data['subtitle'] = $subtitle;
    } else {
        return rest_ensure_response(array('error' => 'Manufacturer slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'manufacturer_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_manufacturer_about(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Manufacturer slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'manufacturer');



    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $about_title = get_post_meta($post_id, '_about_title', true);
        $about_desc = get_post_meta($post_id, '_about_desc', true);
        $auth_title = get_post_meta($post_id, '_auth_title', true);
        $auth_desc = get_post_meta($post_id, '_auth_desc', true);
        $auth_image = get_post_meta($post_id, '_auth_image', true);
        $explore_title = get_post_meta($post_id, '_explore_title', true);
        $explore_desc = get_post_meta($post_id, '_explore_desc', true);
        $data['about_title'] = !empty($about_title) ? html_entity_decode($about_title ): '';
        $about_desc = !empty($about_desc) ? html_entity_decode(str_replace(array("\n","&nbsp;"), array("", ""), $about_desc)) : '';
        $data['about_desc'] = !empty($about_desc) ? wpautop(html_entity_decode(preg_replace('/<(\w+)[^>]*>\s*<\/\1>/u', '', $about_desc))) : '';
        $data['auth_title'] = !empty($auth_title) ? html_entity_decode($auth_title) : '';
        $data['auth_desc'] = !empty($auth_desc) ? wpautop(html_entity_decode($auth_desc)) : '';
        $data['auth_image'] = !empty($auth_image) ? $auth_image : '';

        $explore_selected_cat =  get_post_meta($post_id, '_explore_categories', true);

        $explore_cat = [];
        if (is_array($explore_selected_cat) && !empty($explore_selected_cat)) {
            $data['explore_title'] = !empty($explore_title) ? html_entity_decode($explore_title) : '';
            $data['explore_desc'] = !empty($explore_desc) ? wpautop(html_entity_decode($explore_desc)) : '';
            $i = 0;

            foreach ($explore_selected_cat as $term_id) {
                $term = get_term_by('term_id', $term_id, 'product-taxonomy');


                $permalink = get_term_link($term);
                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);


                $metaData = get_option('taxonomy_term_' . $term->term_id);
                $banner_image_url = isset($metaData['banner_image_url']) ? $metaData['banner_image_url'] : '';
                $banner_images = $metaData['banner_images'];

                if (!empty($banner_images)) {
                    $banner_images = !empty($banner_images) ? explode(',', $banner_images) : array();
                    $banner_image_url = isset($banner_images[0]) ? $banner_images[0] : $banner_image_url;
                }

                $explore_cat[$i]['cat_id'] = $term->term_id;
                $explore_cat[$i]['title'] = html_entity_decode($term->name);
                $explore_cat[$i]['description'] = isset($metaData['banner_description']) ? html_entity_decode($metaData['banner_description']) : '';
                $explore_cat[$i]['image'] = $banner_image_url;
                $explore_cat[$i]['route'] = $item_url;
                $i++;
            }
        }
        $data['explore_categories'] = $explore_cat;

$color_title = get_post_meta($post_id, '_color_title', true);
$color_desc = get_post_meta($post_id, '_color_desc', true);
        $data['color_title'] = !empty($color_title) ? html_entity_decode($color_title) : '';
        $data['color_desc'] = !empty($color_desc) ? html_entity_decode($color_desc) : '';
        $color_selected = get_post_meta($post_id, '_color_selected', true);
        $saved_colors = get_option('vmg_colors', array());
        $saved_colors_avail = get_option('vmg_colors_availability', []);
        $color_images = [];
        if (!empty($saved_colors)) {
            foreach ($saved_colors as $color) {
                $title = $color['title'];
                if (in_array($title, $color_selected)) {
                    $color_images[] = $color;
                }
            }
        }
        $data['color_selected'] = $color_images;

        $color_avail_selected = get_post_meta($post_id, '_color_avail_selected', true);
        $color_avail_images = [];
        if (!empty($saved_colors_avail)) {
            foreach ($saved_colors_avail as $color) {
                $title = $color['title'];
                if (in_array($title, $color_avail_selected)) {
                    $color_avail_images[] = $color;
                }
            }
        }



        $data['color_avail_selected'] = $color_avail_images;
        $area_title = get_post_meta($post_id, '_area_title', true);
        $data['area_title'] = !empty($area_title) ? html_entity_decode($area_title) : '';
        $area_des = get_post_meta($post_id, '_area_desc', true);
        $data['area_desc'] = !empty($area_des) ? wpautop(html_entity_decode($area_des)) : '';
        $data['area_images'] = get_post_meta($post_id, '_area_images', true);
        $data['area_link'] = get_post_meta($post_id, '_area_link', true);
    } else {
        return rest_ensure_response(array('error' => 'Manufacturer slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'manufacturer_id' => $post_id,
        'data'    => $data,
    ));
}


// Financing Endpoints callback

function vmg_get_finance_banner(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data = get_post_meta($post->ID, '_finance_banner', true) ?: [];
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_finance_smart_finance(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data = get_post_meta($post->ID, '_smart_financing', true) ?: [];
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_finance_process(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data = get_post_meta($post->ID, '_financing_process', true) ?: [];
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_finance_partners(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $partners = get_option('vmg_partners', []);
        $data = get_post_meta($post->ID, '_partners', true) ?: [];
        $data['partner_list'] = $partners;
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}


function vmg_get_finance_metal_building(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data = get_post_meta($post->ID, '_explore_top_building', true) ?: [];
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_finance_why_financing(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $_why_financing = get_post_meta($post->ID, '_why_financing', true) ?: [];
        $subtitle = isset($_why_financing['subtitle']) && !empty($_why_financing['subtitle']) ? wpautop($_why_financing['subtitle']) : '';
        $_why_financing['subtitle'] = $subtitle;
        $data['why_finance'] = $_why_financing;
        $data['credit_score'] = get_post_meta($post->ID, '_credit_score', true) ?: [];
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}



// offers page

function vmg_get_offers_banner(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['title'] = get_post_meta($post->ID, 'offers_banner_title', true);
        $data['subtitle'] = get_post_meta($post->ID, 'offers_banner_subtitle', true);
        $data['description'] = get_post_meta($post->ID, 'offers_banner_description', true);
        $data['button_text'] = get_post_meta($post->ID, 'offers_banner_button_text', true);
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_offers_about(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $title = get_post_meta($post->ID, 'offers_category_title', true);
        $image = get_post_meta($post->ID, 'offers_category_image', true);
        $selected_cats = get_post_meta($post->ID, 'offers_category_terms', true) ?: [];

        $content = '';
        if (is_array($selected_cats) && !empty($selected_cats)) {
            foreach ($selected_cats as $term_id) {
                $term = get_term_by('term_id', $term_id, 'product-taxonomy');

                $permalink = get_term_link($term);
                $backend_pos = strpos($permalink, '/backend/');
                $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);


                $content .= '<a href="' . $item_url . '">' . $term->name . '</a>';
            }
        }

        $items = get_post_meta($post->ID, 'offers_about_items', true) ?: [];
        $items[] = array(
            'title' => $title,
            'description' => $content,
            'image' => $image
        );
        $data['items'] = $items;
        $title = get_post_meta($post->ID, 'offers_main_title', true);
        $description = get_post_meta($post->ID, 'offers_main_description', true);
        $button_text = get_post_meta($post->ID, 'offers_main_button_text', true);
        $button_link = get_post_meta($post->ID, 'offers_main_button_link', true);

        $permalink = $button_link;
        $backend_pos = strpos($permalink, '/backend/');
        $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

        $phone = get_post_meta($post->ID, 'offers_main_phone', true);
        $data['deal'] = array(
            'title' => $title,
            'description' => $description,
            'button_text' => $button_text,
            'button_url' => $item_url,
            'phone_number' => $phone
        );
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_offers_metal_building(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data['title'] = get_post_meta($post->ID, 'offers_metal_buildings_title', true);
        $data['description'] = get_post_meta($post->ID, 'offers_metal_buildings_description', true);
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}


// State page
function vmg_get_state_banner(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $template = get_page_template_slug($post->ID);
        if ($template === 'state-pages.php') {
            $data['title'] = get_post_meta($post->ID, '_state_banner_title', true);
            $data['description']  = get_post_meta($post->ID, '_state_banner_description', true);
            $data['banner_image']  = get_post_meta($post->ID, '_state_banner_image', true);
        } else if ($template === 'city-state-pages.php') {
            $state_id = get_post_meta($post->ID, '_parent_state_id', true);
            $title = get_post_meta($post->ID, '_city_banner_title', true);
            $desc  = get_post_meta($post->ID, '_city_banner_description', true);
            $image = get_post_meta($post->ID, '_city_banner_image', true);

            if (!empty($state_id)) {
                $title = empty($title) ? get_post_meta($state_id, '_city_banner_title', true) : '';
                $desc  = empty($desc) ? get_post_meta($state_id, '_city_banner_description', true) : '';
                $image = empty($image) ? get_post_meta($state_id, '_state_banner_image', true) : '';
            }

            $data['title'] = !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '';
            $data['description']  = !empty($desc) ? str_replace('[City Name]', $post->post_title, $desc): '';
            $data['banner_image'] = $image ?? '';
        } else {
            return rest_ensure_response(array('error' => 'This page is NOT assigned a state or city'));
        }
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_state_metal_building(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $template = get_page_template_slug($post->ID);
        if ($template === 'state-pages.php') {
            $data['title'] = get_post_meta($post->ID, '_state_top_building_title', true);
            $data['description']  = get_post_meta($post->ID, '_state_top_building_description', true);

        } else if ($template === 'city-state-pages.php') {
            $state_id = get_post_meta($post->ID, '_parent_state_id', true);

            $title = get_post_meta($post->ID, '_city_top_building_title', true);
            $desc  = get_post_meta($post->ID, '_city_top_building_description', true);
            $data['name'] = $post->post_title;
            $state = get_post($state_id);
            $parts = explode('-', $state->post_name);
            $state_name = end($parts);
            $state_name = $state_name ?? '';
            $data['state'] = $state_name;

            if (!empty($state_id)) {
                $title = empty($title) ? get_post_meta($state_id, '_city_top_building_title', true) : '';
                $desc  = empty($desc) ? get_post_meta($state_id, '_city_top_building_description', true) : '';
            }

            $data['title'] = !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '';
            $data['description']  = !empty($desc) ? str_replace('[City Name]', $post->post_title, $desc): '';

        } else {
            return rest_ensure_response(array('error' => 'This page is NOT assigned a state or city'));
        }
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_state_about(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $states = $cities = $data = [];

    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $template = get_page_template_slug($post->ID);
        if ($template === 'state-pages.php') {
            $title = get_post_meta($post->ID, '_state_key_industries_title', true);
            $desc  = get_post_meta($post->ID, '_state_key_industries_description', true);
            $industries = get_post_meta($post->ID, '_state_key_industries_repeater', true);

            if(!empty($industries)){
                foreach ($industries as $key => $industry) {
                    $industries[$key]['title'] = !empty($industry['title']) ? str_replace('[City Name]', $post->post_title, $industry['title']) : '';
                    $industries[$key]['description'] = !empty($industry['description']) ? str_replace('[City Name]', $post->post_title, $industry['description']) : '';
                    $industries[$key]['image'] = !empty($industry['image']) ? $industry['image'] : '';
                }
            }
            $data['key_industries'] = array(
                'title' => !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '',
                'description'  => !empty($desc) ? wpautop(str_replace('[City Name]', $post->post_title, $desc)): '',
                'industries' => !empty($industries) ? $industries : '',
            );
            $title = get_post_meta($post->ID, '_state_shop_building_title', true);
            $desc  = get_post_meta($post->ID, '_state_shop_building_description', true);
            $repeater = get_post_meta($post->ID, '_state_shop_building_repeater', true);

            if(!empty($repeater)){
                foreach ($repeater as $key => $builrep) {
                    $repeater[$key]['title'] = !empty($builrep['title']) ? str_replace('[City Name]', $post->post_title, $builrep['title']) : '';
                    $repeater[$key]['description'] = !empty($builrep['description']) ? str_replace('[City Name]', $post->post_title, $builrep['description']) : '';
                    $repeater[$key]['image'] = !empty($repeater['image']) ? $repeater['image'] : '';
                }
            }
            $data['customize_building'] = array(
                'title' => !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '',
                'description'  => !empty($desc) ? wpautop(str_replace('[City Name]', $post->post_title, $desc)): '',
                'repeater' => !empty($repeater) ? $repeater : '',
            );
            $data['name'] = $post->post_title;
            $query1 = new WP_Query([
                'post_type'      => 'page',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'meta_key'       => '_wp_page_template',
                'meta_value'     => 'state-pages.php',
                'order'          => 'ASC',
                'orderby'        => 'title',
            ]);
            // print_r($query1);
            if ($query1->have_posts()) {
                while ($query1->have_posts()) {
                    $query1->the_post();
                    $permalink = get_the_permalink();
                    $backend_pos = strpos($permalink, '/backend/');
                    $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url(get_the_permalink(), PHP_URL_PATH);

                    $states[$item_url] = html_entity_decode(get_the_title());
                }
                wp_reset_postdata();
            }

            $query2 = new WP_Query([
                'post_type'      => 'page',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'order'          => 'ASC',
                'orderby'        => 'title',

                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key'     => '_wp_page_template',
                        'value'   => 'city-state-pages.php',
                        'compare' => '=',
                    ],
                    [
                        'key'     => '_parent_state_id',
                        'value'   => $post->ID,
                        'compare' => '=',
                    ],
                ],
            ]);

            // print_r($query2);
            if ($query2->have_posts()) {
                while ($query2->have_posts()) {
                    $query2->the_post();
                    $permalink = get_the_permalink();
                    $backend_pos = strpos($permalink, '/backend/');
                    $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url(get_the_permalink(), PHP_URL_PATH);

                    $cities[$item_url] = html_entity_decode(get_the_title());
                }
                wp_reset_postdata();
            }
            $data['states'] = $states;
            $data['current_state'] = $m_slug;
            $data['cities'] = $cities;
        } else if ($template === 'city-state-pages.php') {
            $state_id = get_post_meta($post->ID, '_parent_state_id', true);
            $title = get_post_meta($post->ID, '_city_key_industries_title', true);
            $desc  = get_post_meta($post->ID, '_city_key_industries_description', true);
            $industries = get_post_meta($post->ID, '_city_key_industries_repeater', true);
            $data['name'] = $post->post_title;
            $state = get_post($state_id);
            $query1 = new WP_Query([
                'post_type'      => 'page',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'meta_key'       => '_wp_page_template',
                'meta_value'     => 'state-pages.php',
                'order'          => 'ASC',
                'orderby'        => 'title',
            ]);
            // print_r($query1);
            if ($query1->have_posts()) {
                while ($query1->have_posts()) {
                    $query1->the_post();
                    $permalink = get_the_permalink();
                    $backend_pos = strpos($permalink, '/backend/');
                    $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url(get_the_permalink(), PHP_URL_PATH);

                    $states[$item_url] = html_entity_decode(get_the_title());
                }
                wp_reset_postdata();
            }

            $query2 = new WP_Query([
                'post_type'      => 'page',
                'post_status'    => 'publish',
                'posts_per_page' => -1,
                'order'          => 'ASC',
                'orderby'        => 'title',

                'meta_query' => [
                    'relation' => 'AND',
                    [
                        'key'     => '_wp_page_template',
                        'value'   => 'city-state-pages.php',
                        'compare' => '=',
                    ],
                    [
                        'key'     => '_parent_state_id',
                        'value'   => $state_id,
                        'compare' => '=',
                    ],
                ],
            ]);

            // print_r($query2);
            if ($query2->have_posts()) {
                while ($query2->have_posts()) {
                    $query2->the_post();
                    $permalink = get_the_permalink();
                    $backend_pos = strpos($permalink, '/backend/');
                    $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url(get_the_permalink(), PHP_URL_PATH);

                    $cities[$item_url] = html_entity_decode(get_the_title());
                }
                wp_reset_postdata();
            }
            $data['states'] = $states;
            $data['current_state'] = $state->post_name;
            $data['cities'] = $cities;
             $data['current_city'] = $post->post_name;


            $data['state'] =  $state->post_title;
            if (!empty($state_id)) {
                $title = empty($title) ? get_post_meta($state_id, '_city_key_industries_title', true) : '';
                $desc  = empty($desc) ? get_post_meta($state_id, '_city_key_industries_description', true) : '';
                $industries = empty($industries) ? get_post_meta($state_id, '_city_key_industries_repeater', true) : '';
            }

            if(!empty($industries)){
                foreach ($industries as $key => $industry) {
                    $industries[$key]['title'] = !empty($industry['title']) ? str_replace('[City Name]', $post->post_title, $industry['title']) : '';
                    $industries[$key]['description'] = !empty($industry['description']) ? str_replace('[City Name]', $post->post_title, $industry['description']) : '';
                }
            }
            $data['key_industries'] = array(
                'title' => !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '',
                'description'  => !empty($desc) ? wpautop(str_replace('[City Name]', $post->post_title, $desc)): '',
                'industries' => !empty($industries) ? $industries : '',
            );

            $title = get_post_meta($post->ID, '_city_shop_building_title', true);
            $desc  = get_post_meta($post->ID, '_city_shop_building_description', true);
            $repeater = get_post_meta($post->ID, '_city_shop_building_repeater', true);


            if (!empty($state_id)) {
                $title = empty($title) ? get_post_meta($state_id, '_city_shop_building_title', true) : '';
                $desc  = empty($desc) ? get_post_meta($state_id, '_city_shop_building_description', true) : '';
                $repeater = empty($repeater) ? get_post_meta($state_id, '_city_shop_building_repeater', true) : '';
            }
            if(!empty($repeater)){
                foreach ($repeater as $key => $builrep) {
                    $repeater[$key]['title'] = !empty($builrep['title']) ? str_replace('[City Name]', $post->post_title, $builrep['title']) : '';
                    $repeater[$key]['description'] = !empty($builrep['description']) ? str_replace('[City Name]', $post->post_title, $builrep['description']) : '';
                }
            }
            $data['customize_building'] = array(
                'title' => !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '',
                'description'  => !empty($desc) ? wpautop(str_replace('[City Name]', $post->post_title, $desc)): '',
                'repeater' => !empty($repeater) ? $repeater : '',
            );
        } else {
            return rest_ensure_response(array('error' => 'This page is NOT assigned a state or city'));
        }
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function vmg_get_state_rto_finance(WP_REST_Request $request)
{
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $template = get_page_template_slug($post->ID);
        if ($template === 'state-pages.php') {
            $data['title'] = get_post_meta($post->ID, '_state_rto_finance_title', true);
            $data['description'] = get_post_meta($post->ID, '_state_rto_finance_description', true);

        } else if ($template === 'city-state-pages.php') {
            $state_id = get_post_meta($post->ID, '_parent_state_id', true);
            $title = get_post_meta($post->ID, '_city_rto_finance_title', true);
            $desc  = get_post_meta($post->ID, '_city_rto_finance_description', true);

            if (!empty($state_id)) {
                $title = empty($title) ? get_post_meta($state_id, '_city_rto_finance_title', true) : '';
                $desc  = empty($desc) ? get_post_meta($state_id, '_city_rto_finance_description', true) : '';
            }


            $data['title'] = !empty($title) ? str_replace('[City Name]', $post->post_title, $title): '';
            $data['description']  = !empty($desc) ? wpautop(str_replace('[City Name]', $post->post_title, $desc)): '';

        }else {
            return rest_ensure_response(array('error' => 'This page is NOT assigned a state or city'));
        }
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}

function cfe_register_submission($request)
{
    $data = $request->get_params();

    // print_r($data);
    $errors = [];

    // Abusive words list
    $abusive_words = array(
        'spam',
        'test',
        'xxx',
        'fake',
        'abuse',
        'viagra',
        'casino',
        'loan',
        'credit',
        'porn',
        'sex',
        'escort',
        'bet',
        'gambling',
        'hack',
        'scam',
        'lottery',
        'bitcoin',
        'crypto',
        'win',
        'prize',
        'offer',
        'free',
        'deal',
        'money',
        'cheap',
        'pill',
        'drug',
        'dating',
        'nude',
        'horny',
        'pharma',
        'referral',
        'sign up',
        'yourmail',
        'bonuses',
        'promotions',
        'seo',
        'google rankings',
        'digital marketing',
        'backlinks',
        'boost your site',
        'traffic',
        'adult',
        'weight loss',
        'приветственные бонусы',
        'промокод',
        'рублей',
        'бонус',
        'игра',
        'ставки',
        'депозит'
    );

    // Helper: check abusive words
    function contains_abusive_words($string, $bad_words)
    {
        foreach ($bad_words as $word) {
            if (stripos($string, $word) !== false) return true;
        }
        return false;
    }

    // ----------------- VALIDATIONS -----------------
    if (empty($data['name'])) {
        $errors[] = 'Name is required.';
    } elseif (!preg_match("/^[a-zA-Z\s]+$/", $data['name'])) {
        $errors[] = 'Name can only contain letters and spaces.';
    } elseif (contains_abusive_words($data['name'], $abusive_words)) {
        $errors[] = 'Name contains inappropriate words.';
    }

    if (empty($data['phone_number'])) {
        $errors[] = 'Phone number is required.';
    } elseif (!preg_match("/^\+?[0-9]{7,15}$/", $data['phone_number'])) {
        $errors[] = 'Phone number is invalid.';
    }

    if (empty($data['email'])) {
        $errors[] = 'Email is required.';
    } elseif (!is_email($data['email'])) {
        $errors[] = 'Email is invalid.';
    } else {
        $disposable_domains = ['mailinator.com', 'tempmail.com', '10minutemail.com', 'yopmail.com'];
        $email_domain = strtolower(substr(strrchr($data['email'], "@"), 1));
        if (in_array($email_domain, $disposable_domains)) {
            $errors[] = 'Disposable or fake emails are not allowed.';
        }
    }

    if (empty($data['state'])) $errors[] = 'State is required.';
    if (empty($data['zipcode'])) {
        $errors[] = 'Zipcode is required.';
    } elseif (!preg_match("/^[0-9]{4,10}$/", $data['zipcode'])) {
        $errors[] = 'Zipcode is invalid.';
    }

    if (!empty($data['comment'])) {
        if (preg_match('/(?:https?:\/\/|www\.|[a-z0-9\-]+\.[a-z]{2,})(?:[^\s]*)/i', $data['comment'])) {
            $errors[] = 'Comment should not contain URLs or links.';
        }
        if (contains_abusive_words($data['comment'], $abusive_words)) {
            $errors[] = 'Comment contains inappropriate words.';
        }
        if (strlen($data['comment']) > 1000) $errors[] = 'Comment should not exceed 1000 characters.';
    }

    if (empty($data['terms']) || $data['terms'] !== true) {
        $errors[] = 'You must accept the terms and conditions.';
    }

    // Validate page URL

    if (!empty($errors)) {
        return new WP_REST_Response(['error' => $errors], 400);
    }

    // ----------------- CREATE POST -----------------
    $post_id = wp_insert_post([
        'post_type' => 'contact_form_entries',
        'post_status' => 'publish',
        'post_title' => sanitize_text_field($data['name']),
    ]);

    if (is_wp_error($post_id)) {
        return new WP_REST_Response(['error' => 'Failed to save submission'], 500);
    }



    // ----------------- SAVE META -----------------
    update_post_meta($post_id, '_name', sanitize_text_field($data['name']));
    update_post_meta($post_id, '_phone', sanitize_text_field($data['phone_number']));
    update_post_meta($post_id, '_email', sanitize_email($data['email']));
    update_post_meta($post_id, '_state', sanitize_text_field($data['state']));
    update_post_meta($post_id, '_zipcode', sanitize_text_field($data['zipcode']));
    update_post_meta($post_id, '_comment', sanitize_textarea_field($data['comment'] ?? ''));
    update_post_meta($post_id, '_form_source', sanitize_textarea_field($data['form_source'] ?? ''));
    update_post_meta($post_id, '_ip_address', sanitize_textarea_field($data['Ip_address'] ?? ''));
    update_post_meta($post_id, '_page_url', isset($data['page_url']) ? esc_url_raw($data['page_url']) : ''); // <-- Save page URL

    // ----------------- ASSIGN TAXONOMY TERM -----------------
    wp_set_object_terms($post_id, 'request-a-quote', 'form_category', true);

    $name      = sanitize_text_field($data['name']);
    $email     = sanitize_email($data['email']);
    $state     = sanitize_text_field($data['state']);
    $phone     = sanitize_text_field($data['phone_number']);
    $notes     = sanitize_textarea_field($data['comment']);
    $zipcode   = sanitize_textarea_field($data['zipcode']);
    $form_source   = sanitize_textarea_field($data['form_source']);
    $ipaddress   = sanitize_textarea_field($data['Ip_address']);
    $pageUrl   = sanitize_textarea_field($data['page_url']);
    $page_name = '';

    $form_source = 'VMG Request Price Form';

    if (empty($slug)) {
        $page_name = 'Homepage';
    } else{
        $path = !empty($pageUrl) ? parse_url($pageUrl, PHP_URL_PATH) : '';
        $slug = !empty($pageUrl) ? basename(trim($path, '/')) : '';

        $result = identify_slug_type($slug);
        $post_types = array('page', 'blog', 'infographics', 'manufacturer', 'product');

        if ( in_array($result['type'], $post_types)) {

            $post = get_page_by_path($slug, OBJECT, $result['type']);
            $post_id = $post->ID;
            $page_name = get_the_title($post_id);

        } else if($result['type'] == 'product-taxonomy'){

            $term = get_term_by('slug', $slug, 'product-taxonomy');
            $page_name = $term->name;
        }
    }

    zoho_integration_data_mapping_api($name, $email, $phone, $state, $zipcode, $notes, $form_source, $pageUrl, $ipaddress, $page_name);

        // Form field values


        $to = array('sales@vikingmetalgarages.com', 'rati@egnoto.com');
        $to = "preeti.s@egnoto.com";
        $admin_subject = "New Contact Request from " . $name;
        $admin_message = 'Hi Admin,<br><br>
        ' . $name . ' has requested to contact. The customer information with the selected product is mentioned below.<br><br>
        <strong>Name:</strong> ' . $name . '<br>
        <strong>Email:</strong> ' . $email . '<br>
        <strong>State:</strong> ' . $state . '<br>
        <strong>Phone:</strong> ' . $phone . '<br>
        <strong>Zipcode:</strong> ' . $zipcode . '<br>
        <strong>Your Comment:</strong> ' . nl2br($notes) . '<br><br>
        Thank You.<br>
        <strong>Viking Metal Garages Team</strong>
        ';

        // Headers
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Viking Metal Garages <sales@vikingmetalgarages.com>',
            'Cc: support@vikingmetalgarages.com'
        );

        $usersubject = 'Thank You for Your Enquiry';
        $user_body = 'Hi '.$name.',<br><br>
                        We received your contact request, our metal garage experts have received your details and would connect with you shortly to provide accurate information. <br><br>
                        We are delighted to serve all your queries and deliver the most reliable metal buildings at your doorstep.
                        For further assistance feel free to connect with our building specialists at +1 (704)-741-1587.<br><br>
                        Best,<br>
                        Viking Metal Garages Team<br>
                        #1 Metal Garage Dealer';

        // Send mail
        $admin = wp_mail($to, $admin_subject, $admin_message, $headers);
        $user = wp_mail($email, $usersubject, $user_body, $headers);
        if($admin && $user){
            return new WP_REST_Response(['success' => true, 'message' => 'Form submitted successfully'], 200);
        } else{
            return new WP_REST_Response(['error' => 'Failed to send email'], 500);
        }

}

function cfe_offer_submission($request)
{
    $data = $request->get_params();
    $errors = [];

    // Abusive words list
    $abusive_words = array(
        'spam',
        'test',
        'xxx',
        'fake',
        'abuse',
        'viagra',
        'casino',
        'loan',
        'credit',
        'porn',
        'sex',
        'escort',
        'bet',
        'gambling',
        'hack',
        'scam',
        'lottery',
        'bitcoin',
        'crypto',
        'win',
        'prize',
        'offer',
        'free',
        'deal',
        'money',
        'cheap',
        'pill',
        'drug',
        'dating',
        'nude',
        'horny',
        'pharma',
        'referral',
        'sign up',
        'yourmail',
        'bonuses',
        'promotions',
        'seo',
        'google rankings',
        'digital marketing',
        'backlinks',
        'boost your site',
        'traffic',
        'adult',
        'weight loss',
        'приветственные бонусы',
        'промокод',
        'рублей',
        'бонус',
        'игра',
        'ставки',
        'депозит'
    );

    // Helper: check abusive words
    function contains_abusive_words($string, $bad_words)
    {
        foreach ($bad_words as $word) {
            if (stripos($string, $word) !== false) return true;
        }
        return false;
    }

    // ----------------- VALIDATIONS -----------------
    if (empty($data['name'])) {
        $errors[] = 'Name is required.';
    } elseif (!preg_match("/^[a-zA-Z\s]+$/", $data['name'])) {
        $errors[] = 'Name can only contain letters and spaces.';
    } elseif (contains_abusive_words($data['name'], $abusive_words)) {
        $errors[] = 'Name contains inappropriate words.';
    }

    if (empty($data['phone_number'])) {
        $errors[] = 'Phone number is required.';
    } elseif (!preg_match("/^\+?[0-9]{7,15}$/", $data['phone_number'])) {
        $errors[] = 'Phone number is invalid.';
    }

    if (empty($data['email'])) {
        $errors[] = 'Email is required.';
    } elseif (!is_email($data['email'])) {
        $errors[] = 'Email is invalid.';
    } else {
        $disposable_domains = ['mailinator.com', 'tempmail.com', '10minutemail.com', 'yopmail.com'];
        $email_domain = strtolower(substr(strrchr($data['email'], "@"), 1));
        if (in_array($email_domain, $disposable_domains)) {
            $errors[] = 'Disposable or fake emails are not allowed.';
        }
    }


    if (!empty($data['comment'])) {
        if (preg_match('/https?:\/\/[^\s]+/i', $data['comment'])) {
            $errors[] = 'Comment should not contain URLs or links.';
        }
        if (contains_abusive_words($data['comment'], $abusive_words)) {
            $errors[] = 'Comment contains inappropriate words.';
        }
        if (strlen($data['comment']) > 1000) $errors[] = 'Comment should not exceed 1000 characters.';
    }

    // Validate page URL

    if (!empty($errors)) {
        return new WP_REST_Response(['error' => $errors], 400);
    }

    // ----------------- CREATE POST -----------------
    $post_id = wp_insert_post([
        'post_type' => 'contact_form_entries',
        'post_status' => 'publish',
        'post_title' => sanitize_text_field($data['name']),
    ]);

    if (is_wp_error($post_id)) {
        return new WP_REST_Response(['error' => 'Failed to save submission'], 500);
    }

    // ----------------- SAVE META -----------------
    update_post_meta($post_id, '_name', sanitize_text_field($data['name']));
    update_post_meta($post_id, '_phone', sanitize_text_field($data['phone_number']));
    update_post_meta($post_id, '_email', sanitize_email($data['email']));
    update_post_meta($post_id, '_comment', sanitize_textarea_field($data['comment'] ?? ''));
    update_post_meta($post_id, '_form_source', sanitize_textarea_field($data['form_source'] ?? ''));
    update_post_meta($post_id, '_ip_address', sanitize_textarea_field($data['Ip_address'] ?? ''));
    update_post_meta($post_id, '_page_url', isset($data['page_url']) ? esc_url_raw($data['page_url']) : '');

    // ----------------- ASSIGN TAXONOMY TERM -----------------
    wp_set_object_terms($post_id, 'offer-page', 'form_category', true);


    // Form field values
        $name      = sanitize_text_field($data['name']);
        $email     = sanitize_email($data['email']);
        $phone     = sanitize_text_field($data['phone_number']);
        $notes     = sanitize_textarea_field($data['comment']);

        $form_source   = sanitize_textarea_field($data['form_source']);
        $ipaddress   = sanitize_textarea_field($data['Ip_address']);
        $pageUrl   = sanitize_textarea_field($data['page_url']);
        $page_name = 'Metal Garage Offers';
        $form_source = 'VMG Offer Form';

        zoho_integration_data_mapping_api($name, $email, $phone, '', '', $notes, $form_source, $pageUrl, $ipaddress, $page_name);

        $to = array('sales@vikingmetalgarages.com', 'rati@egnoto.com');
        $to = "preeti.s@egnoto.com";
        $admin_subject = "New Contact Request from " . $name;
        $admin_message = 'Hi Admin,<br><br>
        ' . $name . ' has requested to contact. The customer information with the selected product is mentioned below.<br><br>
        <strong>Name:</strong> ' . $name . '<br>
        <strong>Email:</strong> ' . $email . '<br>
        <strong>Phone:</strong> ' . $phone . '<br>
        <strong>Your Comment:</strong> ' . nl2br($notes) . '<br><br>
        Thank You.<br>
        <strong>Viking Metal Garages Team</strong>
        ';

        // Headers
        $headers = array(
            'Content-Type: text/html; charset=UTF-8',
            'From: Viking Metal Garages <sales@vikingmetalgarages.com>',
            'Cc: support@vikingmetalgarages.com'
        );

        $usersubject = 'Thank You for Your Enquiry';
        $user_body = 'Hi '.$name.',<br><br>
                        We received your contact request, our metal garage experts have received your details and would connect with you shortly to provide accurate information. <br><br>
                        We are delighted to serve all your queries and deliver the most reliable metal buildings at your doorstep.
                        For further assistance feel free to connect with our building specialists at +1 (704)-741-1587.<br><br>
                        Best,<br>
                        Viking Metal Garages Team<br>
                        #1 Metal Garage Dealer';

        // Send mail
        $admin = wp_mail($to, $admin_subject, $admin_message, $headers);
        $user = wp_mail($email, $usersubject, $user_body, $headers);
        if($admin && $user){
            return new WP_REST_Response(['success' => true, 'message' => 'Form submitted successfully'], 200);
        } else{
            return new WP_REST_Response(['error' => 'Failed to send email'], 500);
        }

}


function vmg_get_contact_banner(WP_REST_Request $request)
{
    $contact_slug = $request->get_param('slug');

    if (empty($contact_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($contact_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
        $data = get_post_meta($post_id, '_vmg_contact_page', true);
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
        'data'    => $data,
    ));
}




function vmg_get_blog_data(WP_REST_Request $request){
    $m_slug = $request->get_param('slug');

    if (empty($m_slug)) {
        return rest_ensure_response(array('error' => 'Page slug is required'));
    }
    $data = [];
    $post_id = 0;
    $post = get_page_by_path($m_slug, OBJECT, 'page');

    if (!empty($post) && is_object($post)) {
        $post_id = $post->ID;
    } else {
        return rest_ensure_response(array('error' => 'Page slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'page_id' => $post_id,
    ));
}
function vmg_get_blog_detail(WP_REST_Request $request){
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'blog slug is required'));
    }
    $blog_id = 0;
    $post = get_page_by_path($slug, OBJECT, 'blog');
    $item_url = '';

    if (!empty($post) && is_object($post)) {
        $blog_id = $post->ID;
        if (get_post_type($blog_id) !== 'blog') {
            return rest_ensure_response(array('error' => 'Blog ID is not valid'));
        } else {
            $terms = wp_get_post_terms($blog_id, 'blog_category');

            $category = !empty($terms) ? wp_list_pluck($terms, 'name') : '';

            $permalink = get_the_permalink($blog_id);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

        $links = vmg_get_custom_prev_next( $blog_id );
        }
    } else {
        return rest_ensure_response(array('error' => 'Blog slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'blog_id' => $blog_id,
        'title' => html_entity_decode(get_the_title($blog_id)),
        'description' => !empty($post->post_content) ? apply_filters('the_content', $post->post_content) : '',
        'image'    => has_post_thumbnail($post) ? get_the_post_thumbnail_url($post, 'full') : '',
        'blog_route' => $item_url,
        'blog_date' => get_the_date('F j, Y', $blog_id),
        'navigation' => $links ?? array(),
        'category' => !empty($category) ? $category : '',
    ));
}
function vmg_get_blog_views(WP_REST_Request $request)
{
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Blog slug is required'));
    }


    $post = get_page_by_path($slug, OBJECT, 'blog');

    if (empty($post) || !is_object($post)) {
        return rest_ensure_response(array('error' => 'Blog slug is not valid'));
    }

    $blog_id = $post->ID;

    if (get_post_type($blog_id) !== 'blog') {
        return rest_ensure_response(array('error' => 'Blog ID is not valid'));
    }


    $views = get_post_meta($blog_id, 'total_views', true);
    $views = !empty($views) ? (int) $views : 0;


    $views++;
    update_post_meta($blog_id, 'total_views', $views);


    return rest_ensure_response(array(
        'success' => true,
        'blog_id' => $blog_id,
        'views' => $views,
    ));
}

function vmg_get_blog_list(WP_REST_Request $request){
    $params = $request->get_params();
    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 3,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $latest_query = new WP_Query($args);
    $latest_blog = [];
    $post_not_in = [];
    if ($latest_query->have_posts()) {
        while ($latest_query->have_posts()) {
            $latest_query->the_post();
            $post_not_in[] = get_the_ID();
        }
    }

    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 6,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );


    $slug = isset($params['slug']) ? $params['slug'] : '';
    if ($slug) {

        $args['tax_query'] = array(
            array(
                'taxonomy' => 'blog_category',
                'field'    => 'slug',
                'terms'    => $slug,
            )
        );
    } else{
        $args['post__not_in']   = $post_not_in;
    }

    $blogs = new WP_Query($args);

    // print_r($blogs);

    if ($blogs->have_posts()) {
        $i = 0;
        while ($blogs->have_posts()) {
            $blogs->the_post();
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $terms = wp_get_post_terms(get_the_ID(), 'blog_category');

            $latest_blog[$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
            $latest_blog[$i]['title'] = html_entity_decode(get_the_title());
            $latest_blog[$i]['image'] = $image_url;
            $latest_blog[$i]['date'] = get_the_date('F j, Y');
            $latest_blog[$i]['link'] = $item_url;
            $latest_blog[$i]['description'] = get_the_excerpt();
            $i++;
        }
    } else{
        return rest_ensure_response(array('error' => 'No blogs found!'));
    }
    return rest_ensure_response(array(
        'success' => true,
        'blogs' => $latest_blog,
        'max_num_pages' => $blogs->max_num_pages,
        'current_page' => 1
    ));


}

function vmg_get_blog_related(WP_REST_Request $request){
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Blog slug is required'));
    }
    $blog_id = 0;
    $related_blog = [];
    $post = get_page_by_path($slug, OBJECT, 'blog');
    if (!empty($post) && is_object($post)) {
        $blog_id = $post->ID;
        if (get_post_type($blog_id) !== 'blog') {
            return rest_ensure_response(array('error' => 'Blog ID is not valid'));
        } else {
            $terms = wp_get_post_terms($blog_id, 'blog_category', array('fields' => 'ids'));

            if (!empty($terms)) {
                $args = array(
                    'post_type'      => 'blog',
                    'posts_per_page' => 3,
                    'post_status'    => 'publish',
                    'post__not_in'   => array($blog_id),
                    'tax_query'      => array(
                        array(
                            'taxonomy' => 'blog_category',
                            'field'    => 'term_id',
                            'terms'    => $terms,
                            'compare'  => 'IN',
                        )
                    ),
                );

                $related = new WP_Query($args);


                if ($related->have_posts()) {
                    $i = 0;
                    while ($related->have_posts()) { $related->the_post();

                        $permalink = get_the_permalink();
                        $backend_pos = strpos($permalink, '/backend/');
                        $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

                        $terms = wp_get_post_terms(get_the_ID(), 'blog_category');


                        $related_blog[$i]['title'] = html_entity_decode(get_the_title());
                        $related_blog[$i]['image'] = has_post_thumbnail(get_the_ID()) ? get_the_post_thumbnail_url(get_the_ID(), 'full') : '';
                        $related_blog[$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
                        $related_blog[$i]['date'] = get_the_date('F j, Y');
                        $related_blog[$i]['link'] = $item_url;
                        $i++;
                    }
                } else {
                    return rest_ensure_response(array('error' => 'No related blog found!'));
                }
            } else {
                return rest_ensure_response(array('error' => 'No related blog found!'));
            }

            wp_reset_postdata();
        }
    } else {
        return rest_ensure_response(array('error' => 'Blog slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'blog_id' => $blog_id,
        'related' => $related_blog,
    ));



}

function vmg_get_blog_load_more(WP_REST_Request $request){
    $params = $request->get_params();

    $params = $request->get_json_params();
    $paged = !empty($params['page']) ? intval($params['page']) : 1;

    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 3,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $latest_query = new WP_Query($args);
    $latest_blog = [];
    $post_not_in = [];
    if ($latest_query->have_posts()) {
        while ($latest_query->have_posts()) {
            $latest_query->the_post();
            $post_not_in[] = get_the_ID();
        }
    }


    // Example: load posts

    $args = array(
        'post_type'      => 'blog',
        'posts_per_page' => 6,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
        'post__not_in'   => $post_not_in,
    );
    if($paged){
        $args['paged'] = $paged;
    }

    if (!empty($params)) {
                $slug = isset($params['slug']) ? $params['slug'] : '';
                if ($slug) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'blog_category',
                            'field'    => 'slug',
                            'terms'    => $slug,
                        )
                    );
                }
        }

    $blogs = new WP_Query($args);

    if ($blogs->have_posts()) {
        $i = 0;
        while ($blogs->have_posts()) {
            $blogs->the_post();
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $terms = wp_get_post_terms(get_the_ID(), 'blog_category');

            $latest_blog[$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
            $latest_blog[$i]['title'] = html_entity_decode(get_the_title());
            $latest_blog[$i]['image'] = $image_url;
            $latest_blog[$i]['date'] = get_the_date('F j, Y');
            $latest_blog[$i]['link'] = $item_url;
            $latest_blog[$i]['description'] = get_the_excerpt();
            $i++;
        }
    } else{
        return rest_ensure_response(array('error' => 'No blogs found!'));
    }
    return rest_ensure_response(array(
        'success' => true,
        'blogs' => $latest_blog,
        'max_num_pages' => $blogs->max_num_pages,
        'next_page' => $blogs->max_num_pages >= $paged  ? $paged : 0,
        'current_page' => !empty($params['page']) ? intval($params['page']) : 1,
    ));


}

function vmg_get_blog_popular(WP_REST_Request $request){
    $args = array(
        'post_type'      => 'blog',
        'post_status'    => 'publish',
        'posts_per_page' => 3,
        'meta_key'       => 'total_views',
        'orderby'        => 'meta_value_num',
        'order'          => 'DESC',
    );

    $popular_posts = new WP_Query($args);
    $popular = [];
    $i = 0;
    if ($popular_posts->have_posts()) {
        while ($popular_posts->have_posts()) {
            $popular_posts->the_post();
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $views = get_post_meta(get_the_ID(), 'total_views', true);
            $popular[$i]['title'] = html_entity_decode(get_the_title());
            $popular[$i]['image'] = has_post_thumbnail() ? get_the_post_thumbnail_url() : '';
            $popular[$i]['blog_route'] = $item_url;
            $popular[$i]['views'] = !empty($views) ? $views : 0;

            $i++;
        }
    }else{
        return rest_ensure_response(array('error' => 'No popular blogs found!'));
    }
    wp_reset_postdata();
    return rest_ensure_response(array(
        'success' => true,
        'blogs' => $popular,
    ));

}

function vmg_get_blog_category(WP_REST_Request $request){

    $terms = get_terms(array(
        'taxonomy'   => 'blog_category',
        'hide_empty' => true,
    ));

    $blog_cat = [];
    $i = 0;
    if (!empty($terms)) {
        foreach ($terms as $term) {
            $permalink = get_term_link($term);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $blog_cat[$i]['title'] = $term->name;
            $blog_cat[$i]['slug'] = $term->slug;
            $blog_cat[$i]['route'] = $item_url;
            $i++;
        }
    }else{
        return rest_ensure_response(array('error' => 'No blog category found!'));
    }
    wp_reset_postdata();
    return rest_ensure_response(array(
        'success' => true,
        'blog_cat' => $blog_cat,
    ));

}

function vmg_get_infographic_detail(WP_REST_Request $request){
    $slug = $request->get_param('slug');

    if (empty($slug)) {
        return rest_ensure_response(array('error' => 'Infographics slug is required'));
    }
    $blog_id = 0;
    $post = get_page_by_path($slug, OBJECT, 'infographics');
    $item_url = '';

    if (!empty($post) && is_object($post)) {
        $blog_id = $post->ID;
        if (get_post_type($blog_id) !== 'infographics') {
            return rest_ensure_response(array('error' => 'Infographics ID is not valid'));
        } else {
            $terms = wp_get_post_terms($blog_id, 'infographics_category');

            $category = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
            $permalink = get_the_permalink($blog_id);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

        $links = vmg_get_custom_prev_next( $blog_id );
        }
    } else {
        return rest_ensure_response(array('error' => 'Infographics slug is not valid'));
    }

    return rest_ensure_response(array(
        'success' => true,
        'blog_id' => $blog_id,
        'title' => html_entity_decode(get_the_title($blog_id)),
        'description' => !empty($post->post_content) ? apply_filters('the_content', $post->post_content) : '',
        'image'    => has_post_thumbnail($post) ? get_the_post_thumbnail_url($blog_id, 'full') : '',
        'blog_route' => $item_url,
        'blog_date' => get_the_date('F j, Y', $blog_id),
        'navigation' => $links ?? array(),
        'category' => $category,
    ));
}
function vmg_get_infographics_list(WP_REST_Request $request){
    $params = $request->get_params();
    $args = array(
        'post_type'      => 'infographics',
        'posts_per_page' => 1,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );




    $latest_query = new WP_Query($args);
    $latest_blog = $post_not_in = $latest_info = $info_cate = [];

    if ($latest_query->have_posts()) {
        while ($latest_query->have_posts()) {
            $latest_query->the_post();
            $post_not_in[] = get_the_ID();

            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $terms = wp_get_post_terms(get_the_ID(), 'infographics_category');

            $latest_info['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
            $latest_info['title'] = html_entity_decode(get_the_title());
            $latest_info['image'] = $image_url;
            $latest_info['date'] = get_the_date('F j, Y');
            $latest_info['link'] = $item_url;
            $latest_info['description'] = get_the_excerpt();
        }
    }

    $args = array(
        'post_type'      => 'infographics',
        'posts_per_page' => 6,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
        'post__not_in'   => $post_not_in,
    );
    if (!empty($params)) {
            $slug = isset($params['slug']) ? $params['slug'] : '';
            if ($slug) {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'infographics_category',
                        'field'    => 'slug',
                        'terms'    => $slug,
                    )
                );
            }
    }

    $blogs = new WP_Query($args);

    if ($blogs->have_posts()) {
        $i = 0;
        while ($blogs->have_posts()) {
            $blogs->the_post();
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);

            $terms = wp_get_post_terms(get_the_ID(), 'infographics_category');

            $latest_blog[$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';
            $latest_blog[$i]['title'] = html_entity_decode(get_the_title());
            $latest_blog[$i]['image'] = $image_url;
            $latest_blog[$i]['date'] = get_the_date('F j, Y');
            $latest_blog[$i]['link'] = $item_url;
            $latest_blog[$i]['description'] = get_the_excerpt();
            $i++;
        }
    } else{
        return rest_ensure_response(array('error' => 'No infographics found!'));
    }

    $terms = get_terms(array(
        'taxonomy'   => 'infographics_category',
        'hide_empty' => true,
    ));

    if(!empty($terms)){
        $j = 0;
        foreach ($terms as $term) {
            $permalink = get_term_link($term);
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $info_cate[$j]['title'] = $term->name;
            $info_cate[$j]['slug'] = $term->slug;
            $info_cate[$j]['route'] = $item_url;

            $j++;
        }
    }

    return rest_ensure_response(array(
        'success' => true,
        'latest_infographics' => $latest_info,
        'infographics' => $latest_blog,
        'max_num_pages' => $blogs->max_num_pages,
        'current_page' => 1,
        'infographics_cat' => $info_cate

    ));


}


function vmg_get_infographics_load_more(WP_REST_Request $request){
    $params = $request->get_params();

    $params = $request->get_json_params();
    $paged = !empty($params['page']) ? intval($params['page']) : 1;

    $args = array(
        'post_type'      => 'infographics',
        'posts_per_page' => 1,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $latest_query = new WP_Query($args);
    $latest_blog = [];
    $post_not_in = [];
    if ($latest_query->have_posts()) {
        while ($latest_query->have_posts()) {
            $latest_query->the_post();
            $post_not_in[] = get_the_ID();
        }
    }


    // Example: load posts

    $args = array(
        'post_type'      => 'infographics',
        'posts_per_page' => 6,
        'post_status'    => 'publish',
        'orderby'        => 'date',
        'order'          => 'DESC',
        'post__not_in'   => $post_not_in,
    );

    if($paged){
        $args['paged'] = $paged;
    }

    if (!empty($params)) {
                $slug = isset($params['slug']) ? $params['slug'] : '';
                if ($slug) {
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'infographics_category',
                            'field'    => 'slug',
                            'terms'    => $slug,
                        )
                    );
                }
        }

    $blogs = new WP_Query($args);

    if ($blogs->have_posts()) {
        $i = 0;
        while ($blogs->have_posts()) {
            $blogs->the_post();
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $image_url = !empty($image_url) ? $image_url : false;
            $permalink = get_the_permalink();
            $backend_pos = strpos($permalink, '/backend/');
            $item_url = $backend_pos !== false ? substr($permalink, $backend_pos + strlen('/backend')) : parse_url($permalink, PHP_URL_PATH);
            $terms = wp_get_post_terms(get_the_ID(), 'infographics_category');

            $latest_blog[$i]['category'] = !empty($terms) ? wp_list_pluck($terms, 'name') : '';

            $latest_blog[$i]['title'] = html_entity_decode(get_the_title());
            $latest_blog[$i]['image'] = $image_url;
            $latest_blog[$i]['date'] = get_the_date('F j, Y');
            $latest_blog[$i]['link'] = $item_url;
            $latest_blog[$i]['description'] = get_the_excerpt();
            $i++;
        }
    } else{
        return rest_ensure_response(array('error' => 'No infographics found!'));
    }
    return rest_ensure_response(array(
        'success' => true,
        'infographics' => $latest_blog,
        'max_num_pages' => $blogs->max_num_pages,
        'next_page' => $blogs->max_num_pages >= $paged  ? $paged : 0,
        'current_page' => !empty($params['page']) ? intval($params['page']) : 1,
    ));

}

function vmg_get_custom_prev_next( $post_id ) {
    $post_type = get_post_type($post_id);
    // Get all published posts ordered newest → oldest
    $all_posts = get_posts([
        'post_type'      => $post_type,
        'post_status'    => 'publish',
        'numberposts'    => -1,
        'orderby'        => 'date',
        'order'          => 'DESC',
        'fields'         => 'ids'
    ]);

    // Find current index
    $index = array_search($post_id, $all_posts);

    if ($index === false) {
        return ['previous' => '', 'next' => ''];
    }

    // Get real previous & next
    $prev = $all_posts[$index + 1] ?? '';
    $next = $all_posts[$index - 1] ?? '';

    $next_permalink = get_the_permalink($next);
    $backend_pos = strpos($next_permalink, '/backend/');
    $next_item_url = $backend_pos !== false ? substr($next_permalink, $backend_pos + strlen('/backend')) : parse_url($next_permalink, PHP_URL_PATH);

    $prev_permalink = get_the_permalink($prev);
    $backend_pos = strpos($prev_permalink, '/backend/');
    $prev_item_url = $backend_pos !== false ? substr($prev_permalink, $backend_pos + strlen('/backend')) : parse_url($prev_permalink, PHP_URL_PATH);


    // RULE 1: If previous does NOT exist → keep previous empty, show real next
    if ($prev === '') {

        return [
            'previous' => '',
            'next'     => [
                    'image' => has_post_thumbnail($next) ? get_the_post_thumbnail_url($next, 'thumbnail') : '',
                    'route' => $next_item_url,
                    'title' => html_entity_decode(get_the_title($next)),
            ],
        ];
    }



    // RULE 2: If next does NOT exist → previous must be empty AND next = previous real item
    if ($next === '') {

        return [
            'previous' => [
            'image' => has_post_thumbnail($prev) ? get_the_post_thumbnail_url($prev, 'thumbnail') : '',
            'route' => $prev_item_url,
            'title' => html_entity_decode(get_the_title($prev)),
        ],
            'next'     => '',
        ];
    }



    // Normal case
    return [
        'previous' => [
            'image' => has_post_thumbnail($prev) ? get_the_post_thumbnail_url($prev, 'thumbnail') : '',
            'route' => $prev_item_url ?? '',
            'title' => html_entity_decode(get_the_title($prev)),
        ],
        'next'     => [
            'image' => has_post_thumbnail($next) ? get_the_post_thumbnail_url($next, 'thumbnail') : '',
            'route' => $next_item_url ?? '',
            'title' => html_entity_decode(get_the_title($next)),
        ],
    ];
}