<?php // 1️⃣ Register the meta box
// add_action('add_meta_boxes', function () {
//     add_meta_box(
//         'product_details_meta_box',
//         __('Product Details', 'textdomain'),
//         'render_product_details_meta_box',
//         'product',
//         'normal',
//         'high'
//     );
// });

// 2️⃣ Render meta box fields
function render_product_details_meta_box($post) {
    $fields = [
        'prices' => 'Price',
        'length' => 'Length',
        'width'  => 'Width',
        'height' => 'Height',
        'sku'    => 'SKU',
        'roof_style' => 'Roof Style',
        'keyword_one' => 'Keyword One',
        'keyword_two' => 'Keyword Two',
        'keyword_three' => 'Keyword Three',
    ];

    // Security nonce
    wp_nonce_field('save_product_meta', 'product_meta_nonce');

    echo '<table class="form-table">';

    // Simple input fields
    foreach ($fields as $key => $label) {
        $value = get_post_meta($post->ID, $key, true);
        echo '<tr>
                <th><label for="'.$key.'">'.$label.'</label></th>
                <td><input type="text" id="'.$key.'" name="'.$key.'" value="'.esc_attr($value).'" class="regular-text"></td>
              </tr>';
    }

    echo '<tr>
                <th><label for="roof_style">Roof Style</label></th>
                <td>
                    <select id="roof_style" name="roof_style" value="'.esc_attr($value).'" class="regular-text">
                        <option value="" >--Select Roof Style--</option>
                        <option value="" >--Select Roof Style--</option>
                        <option value="" >--Select Roof Style--</option>
                        <option value="" >--Select Roof Style--</option>
                    </select>
                </td>
              </tr>';


    // Image fields (6 images)
    for ($i = 1; $i <= 6; $i++) {
        $img_key = 'product_slide_image_' . $i;
        $img_val = get_post_meta($post->ID, $img_key, true);
        echo '<tr>
                <th><label for="'.$img_key.'">Product Slide Image '.$i.'</label></th>
                <td><input type="text" id="'.$img_key.'" name="'.$img_key.'" value="'.esc_attr($img_val).'" class="regular-text"></td>
              </tr>';
    }

    // Rich text editors
    $editor_fields = [
        'technical_specifications' => 'Technical Specifications',
        'color_options'            => 'Color Options',
        'building_features'        => 'Building Features',
        'building_resources'       => 'Building Resources',
    ];

    foreach ($editor_fields as $key => $label) {
        $value = get_post_meta($post->ID, $key, true);
        echo '<tr><th><label for="'.$key.'">'.$label.'</label></th><td>';
        wp_editor($value, $key, [
            'textarea_name' => $key,
            'media_buttons' => true,
            'textarea_rows' => 5
        ]);
        echo '</td></tr>';
    }

    echo '</table>';
}


add_action('save_post_product', function ($post_id) {
    // 🔒 Security checks
    if (
        !isset($_POST['product_meta_nonce']) ||
        !wp_verify_nonce($_POST['product_meta_nonce'], 'save_product_meta')
    ) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    // 🧹 Custom cleaner — removes only unwanted slashes added by WordPress
    function vmg_clean_value($value) {
        if (is_array($value)) {
            return array_map('vmg_clean_value', $value);
        }

        // First, remove automatically added slashes
        $value = wp_unslash($value);

        // Preserve user-entered HTML or manual slashes
        return $value;
    }

    // 🧩 Simple text fields
    $simple_fields = [
        'prices', 'length', 'width', 'height', 'sku',
        'roof_style', 'keyword_one', 'keyword_two', 'keyword_three'
    ];

    foreach ($simple_fields as $field) {
        if (isset($_POST[$field])) {
            $value = vmg_clean_value($_POST[$field]);
            update_post_meta($post_id, $field, $value);
        }
    }

    // 🖼️ Image fields
    for ($i = 1; $i <= 6; $i++) {
        $img_key = 'product_slide_image_' . $i;
        if (isset($_POST[$img_key])) {
            $value = vmg_clean_value($_POST[$img_key]);
            update_post_meta($post_id, $img_key, esc_url_raw($value));
        }
    }

    //Editor / HTML fields (store raw HTML safely)
    $editor_fields = [
        'technical_specifications',
        'color_options',
        'building_features',
        'building_resources',
    ];

    foreach ($editor_fields as $field) {
        if (isset($_POST[$field])) {
            $value = vmg_clean_value($_POST[$field]);
            update_post_meta($post_id, $field, $value);
        }
    }
});