<?php
add_action('product-taxonomy_edit_form_fields', 'vmg_product_cat_custom_fields', 9999, 2);
function vmg_product_cat_custom_fields($tag)
{

    // Check for existing taxonomy meta for the term you're editing

    $t_id = $tag->term_id; // Get the ID of the term you're editing

    $term_meta = get_option("taxonomy_term_$t_id"); // Do the check

    $banner_images = $term_meta['banner_images'];
    if (empty($banner_images)) {
        $banner_images = site_url() . '/wp-content/uploads/2025/10/Hero-Cover-2.webp,'.site_url(). '/wp-content/uploads/2025/10/Hero-Cover-1.webp';
    }

    $title = $term_meta['cat_title'];
    $banner_text = $term_meta['banner_text'];
    $content = $term_meta['extra_dsec'];
    $why_choose_dsec = $term_meta['why_choose_dsec'];
    $explore_category_text = $term_meta['explore_category_text'];
    $footer_heading = $term_meta['footer_heading'];
    $footer_description = $term_meta['footer_description'];
    $faq_items = isset($term_meta['faq_items']) ? $term_meta['faq_items'] : array();
    $metal_roof_desc = $term_meta['metal_roof_desc'];
    $banner_image_url = isset($term_meta['banner_image_url']) ? esc_url($term_meta['banner_image_url']) : '';
    $buy_from_title = $term_meta['buy_from_title'];
    $buy_from_text = $term_meta['buy_from_text'];
    $call_us_text = $term_meta['call_us_text'];
    $phone_number = $term_meta['phone_number'];
    $faq_title = $term_meta['faq_title'];
    $faq_description = $term_meta['faq_description'];
    $popular_building_title = $term_meta['popular_building_title'];
    $popular_building_subtitle = $term_meta['popular_building_subtitle'];
    $about_cat_title = $term_meta['about_cat_title'];
    $about_cat_description = $term_meta['about_cat_description'];
    $roof_style_title = $term_meta['roof_style_title'];
    $roof_style_description = $term_meta['roof_style_description'];
    $benefits_title = $term_meta['benefits_title'];

    $type_title = $term_meta['type_title'];
    $type_description = $term_meta['type_description'];
    $type_content = $term_meta['type_content'];
    $garage_title = $term_meta['garage_title'];
    $garage_description = $term_meta['garage_description'];
    $selected_terms = !empty($term_meta['category_terms']) ? $term_meta['category_terms'] : [];
    $feature_title = $term_meta['feature_title'];
    $why_choose_title = $term_meta['why_choose_title'];
    $feature_description = $term_meta['feature_description'];
    $why_choose_description = $term_meta['why_choose_description'];
    $offers_title = $term_meta['offers_title'];
    $offers_description = $term_meta['offers_description'];

    $faq_titlen = $term_meta['faq_titlen'];
    $faq_list = isset($term_meta['faq_list']) ? $term_meta['faq_list'] : array();
    $faq_descriptionn = $term_meta['faq_descriptionn'];

    $benefits = $term_meta['benefits'];
    $show_terms = $term_meta['show_terms'];

    // print_r($benefits);

    if (empty($benefits)) {
        $benefits = array(
            array(
                'title' => 'Weatherproof',
                'description' => 'Every side and edge gets completely sealed to keep water from leaking in or insects from sneaking into your garage.',
                'image' => site_url() . '/wp-content/uploads/2025/10/Weatherproof.webp'
            ),
            array(
                'title' => 'Fire Resistant',
                'description' => 'Metal won’t burn and has an incredibly high melting point, making your garage far safer during wildfires. You can boost fire resistance even more with specialized sealants like intumescent or vermiculite.',
                'image' => site_url() . '/wp-content/uploads/2025/10/Fire-Resistant.webp'
            ),
            array(
                'title' => 'Pest-Proof',
                'description' => 'Metal naturally resists fungus and gives termites nowhere to build their colonies in posts or frames. Pest damage is why so many wooden structures crumble over time.',
                'image' => site_url() . '/wp-content/uploads/2025/10/Pest-Proof.webp'
            ),
            array(
                'title' => 'Low Maintenance',
                'description' => 'Our steel garages use 100% galvanized steel, which fights off rust and stays cleaner longer. You won’t waste time on extra waterproofing or throw away money on regular pest inspections.',
                'image' => site_url() . '/wp-content/uploads/2025/10/Low-Maintenance.webp'
            ),
            array(
                'title' => 'Sustainable Building',
                'description' => 'A steel parking building offers 100% recyclability and can be reused infinitely without compromising its structural integrity or toughness. Steel structures represent an environmentally responsible choice.',
                'image' => site_url() . '/wp-content/uploads/2025/10/Sustainable-Building.webp'
            ),
        );
    }













?>

<style>
div.wrap .select2-container--default .select2-selection--multiple .select2-selection__choice {
    padding: 0 20px;
}
</style>

<hr />
<h2>Banner Section</h2>
<table class="form-table" style="width: 216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Banner Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[cat_title]" id="term_meta[cat_title]" size="25" style="width:60%;"
                    value="<?php echo !empty($term_meta['cat_title']) ? str_replace(array('/', '\\'), '', sanitize_text_field(wp_unslash($term_meta['cat_title']))) : ''; ?>"><br />
                <span class="description"><?php _e('Add Title'); ?></span>
            </td>
        </tr>

        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Banner Text'); ?></label></th>
            <td>
                <input type="text" name="term_meta[banner_description]" id="term_meta[banner_description]" size="25"
                    style="width:60%;"
                    value="<?php echo !empty($term_meta['banner_description']) ? str_replace(array('/', '\\'), '', sanitize_text_field(wp_unslash($term_meta['banner_description']))) : ''; ?>"><br />
                <span class="description"><?php _e('Add Banner Text'); ?></span>
            </td>
        </tr>

        <tr class="form-field">
            <th scope="row" valign="top"><label>Banner Images (2 images max):</label></th>
            <td>
                <div class="rto-banner-images-container">
                    <?php
                        if ($banner_images):
                            $banner_images = !empty($banner_images) ? explode(',', $banner_images) : array();
                            foreach ($banner_images as $img):
                                if ($img):
                        ?>
                    <div class="image-wrap" style="display:inline-block; margin-right:10px;">
                        <img src="<?php echo esc_url($img); ?>"
                            style="max-width:200px; display:block; margin-bottom:5px;" />
                        <button class="button rto-remove-bn-btn">Remove</button>
                    </div>
                    <?php
                                endif;
                            endforeach;
                        endif;
                        ?>
                    <div class="banner-upload-wrap"
                        <?php echo (count($banner_images) >= 2) ? 'style="display:none;"' : ''; ?>>
                        <input type="hidden" name="banner_images" id="rto_banner_images"
                            value="<?php echo esc_attr(implode(',', $banner_images)); ?>" />
                        <button class="button rto-upload-bn-btn">Upload</button>
                    </div>
                </div>
            </td>
            <script>
            jQuery(document).ready(function($) {
                function updateBannerInput() {
                    var urls = [];
                    $('.rto-banner-images-container .image-wrap img').each(function() {
                        urls.push($(this).attr('src'));
                    });
                    $('#rto_banner_images').val(urls.join(','));
                    // Hide upload button if 2 images
                    if (urls.length >= 2) {
                        $('.banner-upload-wrap').hide();
                    } else {
                        $('.banner-upload-wrap').show();
                    }
                }

                // Upload button
                $(document).on('click', '.rto-upload-bn-btn', function(e) {
                    e.preventDefault();
                    var container = $(this).closest('.rto-banner-images-container');
                    var custom_uploader = wp.media({
                        title: 'Select Banner Images',
                        button: {
                            text: 'Use this image'
                        },
                        multiple: false
                    }).on('select', function() {
                        var attachment = custom_uploader.state().get('selection').first()
                            .toJSON();
                        container.find('.banner-upload-wrap').before(
                            '<div class="image-wrap" style="display:inline-block; margin-right:10px;">' +
                            '<img src="' + attachment.url +
                            '" style="max-width:200px; display:block; margin-bottom:5px;" />' +
                            '<button class="button rto-remove-bn-btn">Remove</button>' +
                            '</div>'
                        );
                        updateBannerInput();
                    }).open();
                });

                // Remove button
                $(document).on('click', '.rto-remove-bn-btn', function(e) {
                    e.preventDefault();
                    $(this).closest('.image-wrap').remove();
                    updateBannerInput();
                });

                updateBannerInput(); // Initial update
            });
            </script>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Phone number'); ?></label></th>
            <td>
                <input type="text" name="term_meta[phone_number]" id="phone_number" size="25" style="width:60%;"
                    value="<?php echo $phone_number ? $phone_number : ''; ?>"><br />
                <!-- <span class="description"><?php _e('Add Call Us Text'); ?></span> -->
            </td>
        </tr>

    </tbody>
</table>
<hr />
<h2> Popular Buildings Section</h2>
<table class="form-table" style="width: 216%;">
    <tbody>

        <tr class="form-field">
            <th scope="row" valign="top"><label
                    for="popular_building_title"><?php _e('Popular Buildings Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[popular_building_title]" id="popular_building_title" size="25"
                    style="width:60%;" value="<?php echo $popular_building_title ? $popular_building_title : ''; ?>">
            </td>

        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label
                    for="popular_building_subtitle"><?php _e('Popular Buildings Subtitle'); ?></label></th>
            <td>
                <textarea name="term_meta[popular_building_subtitle]" id="popular_building_subtitle" size="25"
                    style="width:60%;"><?php echo $popular_building_subtitle ? $popular_building_subtitle : ''; ?></textarea>

            </td>

        </tr>
    </tbody>
</table>

<hr />
<h2>About parking garage Section</h2>
<table class="form-table" style="width: 216%;">
    <tbody>

        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('About category Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[about_cat_title]" id="about_cat_title" size="25" style="width:60%;"
                    value="<?php echo $about_cat_title ? $about_cat_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('About category Description'); ?></label>
            </th>
            <td>

                <?php
                    $about_cat_content = html_entity_decode($about_cat_description);
                    $about_cat_content = stripslashes($about_cat_content);
                    wp_editor(wp_specialchars_decode($about_cat_content), 'about_cat_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr />
<h2>Roof Styles Section</h2>
<table class="form-table" style="width: 216%;">
    <tbody>

        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Roof style Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[roof_style_title]" id="roof_style_title" size="25" style="width:60%;"
                    value="<?php echo $roof_style_title ? $roof_style_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Roof style Description'); ?></label>
            </th>
            <td>



                <?php
                    $roof_style_content = html_entity_decode($roof_style_description);
                    $roof_style_content = stripslashes($roof_style_content);
                    wp_editor(wp_specialchars_decode($roof_style_content), 'roof_style_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr />
<h2>Benefits Section</h2>
<table class="form-table" style="width: 216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Benefits Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[benefits_title]" id="benefits_title" size="25" style="width:60%;"
                    value="<?php echo $benefits_title ? $benefits_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Benefits List'); ?></label>
            </th>
            <td>
                <table id="benefits-table" style="width=100%" class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th>Sr no. </th>
                            <th>Title</th>
                            <th>Description</th>
                            <th>Image</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php


                            if (!empty($benefits)) {
                                foreach ($benefits as $key => $benefit) {
                                    $title = !empty($benefit['title']) ? html_entity_decode(stripslashes($benefit['title']))  : '';
                                    $description = !empty($benefit['description']) ? html_entity_decode(stripslashes($benefit['description']))  : '';
                            ?>
                        <tr>
                            <td class="sr-no"></td>
                            <td><input type="text" name="term_meta[benefits][<?php echo $key; ?>][title]"
                                    value="<?php echo esc_attr($title); ?>" /></td>
                            <td><textarea
                                    name="term_meta[benefits][<?php echo $key; ?>][description]"><?php echo esc_textarea($description); ?></textarea>
                            </td>
                            <td>
                                <div class="image-upload-wrapper">
                                    <input type="text" class="benefit-image"
                                        name="term_meta[benefits][<?php echo $key; ?>][image]"
                                        value="<?php echo esc_attr($benefit['image']); ?>" />
                                    <button class="button upload-image-button" type="button">Upload</button>
                                </div>
                            </td>
                            <td><button class="button remove-benefit" type="button">Remove</button></td>
                        </tr>
                        <?php
                                }
                            }
                            ?>
                    </tbody>


                </table>
                <button id="add-benefit" class="button button-primary" type="button">Add Benefit</button>
            </td>
        </tr>
    </tbody>
</table>

<script>
jQuery(document).ready(function($) {
    $("#add-benefit").on("click", function() {
        var length = jQuery("#benefits-table tbody").find("tr").length;
        console.log(length);
        var row =
            `<tr>
            <td class="sr-no"></td>
            <td><input type="text" name="term_meta[benefits][` +
            length +
            `][title]" /></td>
            <td><textarea name="term_meta[benefits][` +
            length +
            `][description]"></textarea></td>
            <td>
                <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="term_meta[benefits][` +
            length +
            `][image]" value="" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
            </td>
            <td><button class="button remove-benefit" type="button">Remove</button></td>
        </tr>`;
        $("#benefits-table tbody").append(row);
        updateSrNo();
    });
})
</script>

<hr />
<h2>Types of garage section</h2>
<table class="form-table" style="width:216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Type of garage Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[type_title]" id="type_title" size="25" style="width:60%;"
                    value="<?php echo $type_title ? $type_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Type of garage Content'); ?></label>
            </th>
            <td>
                <?php
                    $typec_content = html_entity_decode($type_content);
                    $typec_content = stripslashes($typec_content);
                    wp_editor(wp_specialchars_decode($typec_content), 'type_content', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Type of garage Description'); ?></label>
            </th>
            <td>
                <?php
                    $typed_content = html_entity_decode($type_description);
                    $typed_content = stripslashes($typed_content);
                    wp_editor(wp_specialchars_decode($typed_content), 'type_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Select Category'); ?></label>
            </th>
            <td>
                <div class="checkbox-wrap" style="margin-bottom: 15px;">
                    <label for="check">
                        <input type="checkbox" name="term_meta[show_terms]" id="check" value="1"
                            <?php echo $show_terms == 1 ? 'checked="checked"' : ''; ?>>
                        Show only selected categories on the category detail page
                    </label>
                    <p style="font-size: 12px; font-style: italic;">
                        If this checkbox is unchecked, the default child categories of this category will be displayed
                        on the frontend
                        when no category is selected in the "Select Category" field. If checked, only the selected
                        categories will appear
                        on the category detail page.
                    </p>
                </div>


                <?php $terms = get_terms(array(
                        'taxonomy'   => 'product-taxonomy',
                        'hide_empty' => false,
                    ));

                    if (!empty($terms) && !is_wp_error($terms)) {

                        // print_r($selected_terms);
                        echo '<select name="term_meta[category_terms][]" class="vmg-select2" multiple="multiple" style="width:100%;">';
                        foreach ($terms as $term) {
                            $selected = in_array($term->term_id, $selected_terms) ? 'selected' : '';
                            echo '<option value="' . esc_attr($term->term_id) . '" ' . $selected . '>' . esc_html($term->name) . '</option>';
                        }
                        echo '</select>';
                        echo '<p class="description">Select top-level product categories (you can select multiple).</p>';
                    }
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr />
<h2>Garage size section</h2>
<table class="form-table" style="width:216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Garage Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[garage_title]" id="garage_title" size="25" style="width:60%;"
                    value="<?php echo $garage_title ? $garage_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Garage Description'); ?></label>
            </th>
            <td>
                <?php
                    $garage_content = html_entity_decode($garage_description);
                    $garage_content = stripslashes($garage_content);
                    wp_editor(wp_specialchars_decode($garage_content), 'garage_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr />
<h2>Feature section</h2>
<table class="form-table" style="width:216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Feature Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[feature_title]" id="feature_title" size="25" style="width:60%;"
                    value="<?php echo $feature_title ? $feature_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Feature Description'); ?></label>
            </th>
            <td>
                <?php
                    $feature_content = html_entity_decode($feature_description);
                    $feature_content = stripslashes($feature_content);
                    wp_editor(wp_specialchars_decode($feature_content), 'feature_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr>
<h2>Why choose section</h2>
<table class="form-table" style="width:216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Why choose Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[why_choose_title]" id="why_choose_title" size="25" style="width:60%;"
                    value="<?php echo $why_choose_title ? $why_choose_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Why choose Description'); ?></label>
            </th>
            <td>
                <?php
                    $why_choose_content = html_entity_decode($why_choose_description);
                    $why_choose_content = stripslashes($why_choose_content);
                    wp_editor(wp_specialchars_decode($why_choose_content), 'why_choose_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>
<hr />
<h2>Offers section</h2>
<table class="form-table" style="width:216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Offers Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[offers_title]" id="offers_title" size="25" style="width:60%;"
                    value="<?php echo $offers_title ? $offers_title : ''; ?>">
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Offers Description'); ?></label>
            </th>
            <td>
                <?php
                    $offers_content = html_entity_decode($offers_description);
                    $offers_content = stripslashes($offers_content);
                    wp_editor(wp_specialchars_decode($offers_content), 'offers_description', array("media_buttons" => true));
                    ?>
            </td>
        </tr>
    </tbody>
</table>

<hr />
<h2>FAQ section</h2>

<table class="form-table" style="width: 216%;">
    <tbody>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('FAQ Title'); ?></label></th>
            <td>
                <input type="text" name="term_meta[faq_titlen]" id="faq_title" size="25" style="width:60%;"
                    value="<?php echo $faq_titlen ? $faq_titlen : ''; ?>"><br />
                <span class="description"><?php _e('Add FAQ Title'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('FAQ Description'); ?></label></th>
            <td>
                <?php
                    $faq_descriptionn_content = html_entity_decode($faq_descriptionn);
                    $faq_descriptionn_content = stripslashes($faq_descriptionn_content);
                    wp_editor(wp_specialchars_decode($faq_descriptionn_content), 'faq_descriptionn', array("media_buttons" => true));
                    ?>
                <span class="description"><?php _e('Add FAQ Description'); ?></span>
            </td>
        </tr>

        <tr class="form-field">
            <th scope="row" valign="top">
                <label for="tag_Image_url"><?php _e('FAQs'); ?></label>
            </th>
            <td>
                <table id="faq-table" style="width=100%" class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th width="5%">Sr no. </th>
                            <th width="40%">Title</th>
                            <th width="50%">Description</th>
                            <th width="5%">Action</th>
                        </tr>
                    </thead>
                    <tbody id="faq-body">
                        <?php $i = 1;
                            if (!empty($faq_list)) {
                                foreach ($faq_list['question'] as $index => $question) {
                                    $question = !empty($question) ? html_entity_decode(stripslashes($question))  : '';
                                    $answer = !empty($faq_list['answer'][$index]) ? html_entity_decode(stripslashes($faq_list['answer'][$index]))  : '';
                            ?>
                        <tr>
                            <td class="sr-no" width="5%"><?php echo $i; ?></td>
                            <td width="40%"><input type="text" name="term_meta[faq_list][question][]"
                                    value="<?php echo esc_attr($question); ?>"></td>
                            <td width="50%"><textarea
                                    name="term_meta[faq_list][answer][]"><?php echo esc_textarea($answer); ?></textarea>
                            </td>
                            <td width="5%"><button class="button remove-faq" type="button">Remove</button></td>
                        </tr>
                        <?php $i++;
                                }
                            } ?>
                    </tbody>


                </table>
                <button class="add-faq-itemc button"><?php _e('Add FAQ Item'); ?></button>
                <script>
                jQuery(document).ready(function($) {
                    // Add FAQ Item
                    $(document).on('click', '.add-faq-itemc', function(e) {
                        e.preventDefault();
                        const length = jQuery('#faq-body').find('tr').length;
                        var faqItem = `<tr>
                            <td class="sr-no" width="5%">${length + 1}</td>
                            <td width="40%"><input type="text" name="term_meta[faq_list][question][]"></td>
                            <td width="50%"><textarea name="term_meta[faq_list][answer][]"></textarea></td>
                            <td width="5%"><button class="button remove-faq" type="button">Remove</button></td>
                        </tr>`;
                        $('#faq-body').append(faqItem);
                    });
                    $(document).on('click', '.remove-faq', function(e) {
                        e.preventDefault();
                        jQuery(this).closest('tr').remove();
                    });
                });
                </script>
            </td>
        </tr>
    </tbody>
</table>

<?php

}



// Add the fields to the "presenters" taxonomy, using our callback function



// A callback function to save our extra taxonomy field(s)

function vmg_save_taxonomy_custom_fields($term_id)
{


    // echo '<pre>';
    // print_r($_POST);
    // echo '</pre>';

    $_POST['term_meta']['category_terms'] = isset($_POST['term_meta']['category_terms']) ? $_POST['term_meta']['category_terms'] : '';
    $_POST['term_meta']['faq_list'] = isset($_POST['term_meta']['faq_list']) ? $_POST['term_meta']['faq_list'] : '';
    $_POST['term_meta']['extra_dsec'] = htmlspecialchars($_POST['extra_dsec']);
    $_POST['term_meta']['why_choose_dsec'] = htmlspecialchars($_POST['why_choose_dsec']);
    $_POST['term_meta']['faq'] = htmlspecialchars($_POST['faq']);
    $_POST['term_meta']['explore_category_text'] = htmlspecialchars($_POST['explore_category_text']);
    $_POST['term_meta']['metal_roof_desc'] = htmlspecialchars($_POST['metal_roof_desc']);
    $_POST['term_meta']['footer_heading'] = htmlspecialchars($_POST['footer_heading']);
    $_POST['term_meta']['footer_description'] = htmlspecialchars($_POST['footer_description']);
    $_POST['term_meta']['buy_from_title'] = htmlspecialchars($_POST['buy_from_title']);
    $_POST['term_meta']['buy_from_text'] = htmlspecialchars($_POST['buy_from_text']);
    $_POST['term_meta']['call_us_text'] = htmlspecialchars($_POST['call_us_text']);
    $_POST['term_meta']['faq_title'] = htmlspecialchars($_POST['faq_title']);
    $_POST['term_meta']['faq_description'] = htmlspecialchars($_POST['faq_description']);
    $_POST['term_meta']['banner_images'] = $_POST['banner_images'];
    $_POST['term_meta']['about_cat_description'] = wp_kses_post(stripslashes($_POST['about_cat_description']));
    $_POST['term_meta']['roof_style_description'] = wp_kses_post(stripslashes($_POST['roof_style_description']));
    $_POST['term_meta']['type_description'] = wp_kses_post(stripslashes($_POST['type_description']));
    $_POST['term_meta']['type_content'] = wp_kses_post(stripslashes($_POST['type_content']));
    $_POST['term_meta']['garage_description'] = wp_kses_post(stripslashes($_POST['garage_description']));
    $_POST['term_meta']['feature_description'] = wp_kses_post(stripslashes($_POST['feature_description']));
    $_POST['term_meta']['why_choose_description'] = wp_kses_post(stripslashes($_POST['why_choose_description']));
    $_POST['term_meta']['offers_description'] = wp_kses_post(stripslashes($_POST['offers_description']));
    $_POST['term_meta']['faq_descriptionn'] = wp_kses_post(stripslashes($_POST['faq_descriptionn']));
    $_POST['term_meta']['banner_description'] = wp_kses_post(stripslashes($_POST['term_meta']['banner_description']));
    $_POST['term_meta']['cat_title'] = wp_kses_post(stripslashes($_POST['term_meta']['cat_title']));
    $_POST['term_meta']['popular_building_title'] = wp_kses_post(stripslashes($_POST['term_meta']['popular_building_title']));
    $_POST['term_meta']['popular_building_subtitle'] = wp_kses_post(stripslashes($_POST['term_meta']['popular_building_subtitle']));
    $_POST['term_meta']['about_cat_title'] = wp_kses_post(stripslashes($_POST['term_meta']['about_cat_title']));
    $_POST['term_meta']['roof_style_title'] = wp_kses_post(stripslashes($_POST['term_meta']['roof_style_title']));
    $_POST['term_meta']['benefits_title'] = wp_kses_post(stripslashes($_POST['term_meta']['benefits_title']));

    $_POST['term_meta']['type_title'] = wp_kses_post(stripslashes($_POST['term_meta']['type_title']));
    $_POST['term_meta']['garage_title'] = wp_kses_post(stripslashes($_POST['term_meta']['garage_title']));
    $_POST['term_meta']['feature_title'] = wp_kses_post(stripslashes($_POST['term_meta']['feature_title']));
    $_POST['term_meta']['why_choose_title'] = wp_kses_post(stripslashes($_POST['term_meta']['why_choose_title']));
    $_POST['term_meta']['offers_title'] = wp_kses_post(stripslashes($_POST['term_meta']['offers_title']));
    $_POST['term_meta']['faq_titlen'] = wp_kses_post(stripslashes($_POST['term_meta']['faq_titlen']));


    $_POST['term_meta']['phone_number'] = wp_kses_post(stripslashes($_POST['term_meta']['phone_number']));










    if (isset($_POST['term_meta'])) {
        $t_id = $term_id;
        $term_meta = get_option("taxonomy_term_$t_id");
        $cat_keys = array_keys($_POST['term_meta']);
        foreach ($cat_keys as $key) {
            $term_meta[$key] = isset($_POST['term_meta'][$key]) ? $_POST['term_meta'][$key] : '';
        }







        // die;
        //save the option array


        update_option("taxonomy_term_$t_id", $term_meta);
        // echo '<pre>';
        // print_r($term_meta);
        // echo '</pre>';
        // die;
    }

    if (isset($_POST['term_meta']['faq_items']) && !empty($_POST['term_meta']['faq_items'])) {
        $faq_items = array(
            'question' => array_map('sanitize_text_field', $_POST['term_meta']['faq_items']['question']),
            'answer'   => $_POST['term_meta']['faq_items']['answer'], // Do not sanitize to allow HTML tags
        );

        update_option("taxonomy_term_$term_id", array_merge(get_option("taxonomy_term_$term_id", array()), array('faq_items' => $faq_items)));
    }
}

// Save the changes made on the "presenters" taxonomy, using our callback function

add_action('edited_product-taxonomy', 'vmg_save_taxonomy_custom_fields', 10, 2);