<?php

/**
 * Meta boxes for page slug: metal-garages-offers
 */

add_action('add_meta_boxes', function () {
    global $post;
    if (empty($post)) return;

    if ($post->post_name === 'metal-garages-offers') {
        add_meta_box('offers_banner_section', 'Section (Banner)', 'offers_banner_section_callback', 'page', 'normal', 'high');
        add_meta_box('offers_about_section', 'Section (About)', 'offers_about_section_callback', 'page', 'normal', 'high');
        add_meta_box('offers_category_section', 'Section (Offers Category)', 'offers_category_section_callback', 'page',    'normal', 'high');
        add_meta_box('offers_main_section', 'Section (Offers)', 'offers_main_section_callback', 'page', 'normal', 'high');
        add_meta_box('offers_metal_buildings_section', 'Section (Metal Buildings)', 'offers_metal_buildings_section_callback', 'page', 'normal', 'high');
    }
});


// ===================== SECTION (BANNER) =====================
function offers_banner_section_callback($post)
{
    $title = get_post_meta($post->ID, 'offers_banner_title', true);
    $subtitle = get_post_meta($post->ID, 'offers_banner_subtitle', true);
    $description = get_post_meta($post->ID, 'offers_banner_description', true);
    $button_text = get_post_meta($post->ID, 'offers_banner_button_text', true);
?>
<p><label>Title</label><br>
    <input type="text" name="offers_banner_title" value="<?= esc_attr($title) ?>" style="width:100%;">
</p>
<p><label>Subtitle</label><br>
    <input type="text" name="offers_banner_subtitle" value="<?= esc_attr($subtitle) ?>" style="width:100%;">
</p>
<p><label>Description</label><br>
    <textarea name="offers_banner_description"
        style="width:100%;height:100px;"><?= esc_textarea($description) ?></textarea>
</p>
<p><label>Button Text</label><br>
    <input type="text" name="offers_banner_button_text" value="<?= esc_attr($button_text) ?>" style="width:100%;">
</p>
<?php
}


// ===================== SECTION (ABOUT) =====================
function offers_about_section_callback($post)
{
    $items = get_post_meta($post->ID, 'offers_about_items', true) ?: [];
?>
<h4>About Offers</h4>
<table id="offers-table" style="width:100%; border-collapse:collapse;" border="1">
    <thead>
        <tr>
            <th>Sr No.</th>
            <th>Title</th>
            <th>Description</th>
            <th>Image</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <?php if (!empty($items)): ?>
        <?php foreach ($items as $i => $item): ?>
        <tr>
            <td><?= $i + 1 ?></td>
            <td><input type="text" name="offers_about_items[<?= $i ?>][title]"
                    value="<?= esc_attr($item['title'] ?? '') ?>" style="width:100%;"></td>
            <td>
                <?php
                            $editor_id = 'about_offers_editor_' . $i;
                            wp_editor($item['description'] ?? '', $editor_id, [
                                'textarea_name' => "offers_about_items[$i][description]",
                                'textarea_rows' => 4,
                            ]);
                            ?>
            </td>
            <td>
                <input type="text" name="offers_about_items[<?= $i ?>][image]" id="about_image_<?= $i ?>"
                    value="<?= esc_attr($item['image'] ?? '') ?>" style="width:100%;">
                <button class="button upload-about-image" data-target="about_image_<?= $i ?>">Upload</button>
            </td>
            <td><button class="button remove-row">Remove</button></td>
        </tr>
        <?php endforeach; ?>
        <?php endif; ?>
    </tbody>
</table>
<br>
<button class="button" id="add-about-row">+ Add Row</button>

<script>
jQuery(document).ready(function($) {

    $('#add-about-row').on('click', function(e) {
        e.preventDefault();
        var index = $('#offers-table tbody tr').length;
        var newRow = `<tr>
                    <td>${index + 1}</td>
                    <td><input type="text" name="offers_about_items[${index}][title]" style="width:100%;"></td>
                    <td><textarea id="about_${index}_desc" name="offers_about_items[${index}][description]" style="width:100%;height:80px;"></textarea></td>
                    <td><input type="text" name="offers_about_items[${index}][image]" id="about_image_${index}" style="width:100%;">
                        <button class="button upload-about-image" data-target="about_image_${index}">Upload</button></td>
                    <td><button class="button remove-row">Remove</button></td>
                </tr>`;
        $('#offers-table tbody').append(newRow);
    });

    $(document).on('click', '.remove-row', function(e) {
        e.preventDefault();
        $(this).closest('tr').remove();
    });

    $(document).on('click', '.upload-about-image', function(e) {
        e.preventDefault();
        var target = $(this).data('target');
        var customUploader = wp.media({
            title: 'Select Image',
            button: {
                text: 'Use this image'
            },
            multiple: false
        }).on('select', function() {
            var attachment = customUploader.state().get('selection').first().toJSON();
            $('#' + target).val(attachment.url);
        }).open();
    });
});
</script>
<?php
}

// Meta box callback
function offers_category_section_callback($post)
{
    $title = get_post_meta($post->ID, 'offers_category_title', true);
    $image = get_post_meta($post->ID, 'offers_category_image', true);
    $selected_cats = get_post_meta($post->ID, 'offers_category_terms', true) ?: [];

    // Get all terms of product-taxonomy
    $terms = get_terms([
        'taxonomy' => 'product-taxonomy',
        'hide_empty' => false
    ]);
?>
<p><label>Title:</label><br>
    <input type="text" name="offers_category_title" value="<?= esc_attr($title); ?>" style="width:100%;">
</p>

<p><label>Image:</label><br>
    <input type="text" id="offers_category_image_url" name="offers_category_image" value="<?= esc_attr($image); ?>"
        style="width:80%;">
    <button class="button" id="upload_offers_category_image">Upload</button>
    <br>
    <?php if ($image) : ?>
    <img id="offers_category_preview" src="<?= esc_url($image); ?>" style="max-width:240px;margin-top:10px;">
    <?php else : ?>
    <img id="offers_category_preview" src="" style="max-width:240px;margin-top:10px;display:none;">
    <?php endif; ?>
</p>

<p><label>Select Category:</label><br>
    <select name="offers_category_terms[]" id="offers_category_terms" multiple style="width:100%;">
        <?php
            if (!empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $selected = in_array($term->term_id, (array)$selected_cats) ? 'selected' : '';
                    echo '<option value="' . esc_attr($term->term_id) . '" ' . $selected . '>' . esc_html($term->name) . '</option>';
                }
            }
            ?>
    </select>
</p>

<script>
jQuery(document).ready(function($) {
    // Media uploader
    $('#upload_offers_category_image').on('click', function(e) {
        e.preventDefault();
        var frame = wp.media({
            title: 'Select Image',
            multiple: false
        }).open().on('select', function() {
            var attachment = frame.state().get('selection').first().toJSON();
            $('#offers_category_image_url').val(attachment.url);
            $('#offers_category_preview').attr('src', attachment.url).show();
        });
    });

    // Initialize Select2
    if ($.fn.select2) {
        $('#offers_category_terms').select2({
            placeholder: "Select categories",
            allowClear: true
        });
    }
});
</script>
<?php
}



// ===================== SECTION (OFFERS) =====================
function offers_main_section_callback($post)
{
    $title = get_post_meta($post->ID, 'offers_main_title', true);
    $description = get_post_meta($post->ID, 'offers_main_description', true);
    $button_text = get_post_meta($post->ID, 'offers_main_button_text', true);
    $button_link = get_post_meta($post->ID, 'offers_main_button_link', true);
    $phone = get_post_meta($post->ID, 'offers_main_phone', true);
?>
<p><label>Title</label><br>
    <input type="text" name="offers_main_title" value="<?= esc_attr($title) ?>" style="width:100%;">
</p>
<p><label>Description</label><br>
    <?php wp_editor($description, 'offers_main_description', [
            'textarea_name' => 'offers_main_description',
            'textarea_rows' => 5
        ]); ?>
</p>
<p><label>Button Text</label><br>
    <input type="text" name="offers_main_button_text" value="<?= esc_attr($button_text) ?>" style="width:100%;">
</p>
<p><label>Button Link</label><br>
    <input type="text" name="offers_main_button_link" value="<?= esc_attr($button_link) ?>" style="width:100%;">
</p>
<p><label>Phone Number</label><br>
    <input type="text" name="offers_main_phone" value="<?= esc_attr($phone) ?>" style="width:100%;">
</p>
<?php
}


// ===================== SECTION (METAL BUILDINGS) =====================
function offers_metal_buildings_section_callback($post)
{
    $title = get_post_meta($post->ID, 'offers_metal_buildings_title', true);
    $description = get_post_meta($post->ID, 'offers_metal_buildings_description', true);
?>
<p><label>Title</label><br>
    <input type="text" name="offers_metal_buildings_title" value="<?= esc_attr($title) ?>" style="width:100%;">
</p>
<p><label>Description</label><br>
    <?php wp_editor($description, 'offers_metal_buildings_description', [
            'textarea_name' => 'offers_metal_buildings_description',
            'textarea_rows' => 5
        ]); ?>
</p>
<?php
}


// ===================== SAVE META BOXES =====================
add_action('save_post', function ($post_id) {
    if (get_post_field('post_name', $post_id) !== 'metal-garages-offers') return;

    // List of single meta keys
    $fields = [
        // Banner
        'offers_banner_title',
        'offers_banner_subtitle',
        'offers_banner_description',
        'offers_banner_button_text',

        // About
        'offers_about_items',

        // category
        'offers_category_title',
        'offers_category_image',
        'offers_category_terms',

        // Offers
        'offers_main_title',
        'offers_main_description',
        'offers_main_button_text',
        'offers_main_button_link',
        'offers_main_phone',

        // Metal Buildings
        'offers_metal_buildings_title',
        'offers_metal_buildings_description',
    ];

    foreach ($fields as $field) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, $field, $_POST[$field]);
        } else {
            delete_post_meta($post_id, $field);
        }
    }
});