<?php
// Hook to add the meta box
add_action('add_meta_boxes', 'vmg_add_brand_logo_metabox');
function vmg_add_brand_logo_metabox()
{
    add_meta_box('vmg_brand_logo', 'Brand Logo', 'vmg_brand_logo_metabox_html', 'manufacturer', 'side', 'low');

    //Top Selling Building
    add_meta_box('vmg_top_selling', 'Section (Top Selling Building)', 'vmg_top_selling_callback', 'manufacturer', 'normal', 'default');

    //About Manufacturer
    add_meta_box('vmg_about_manufacturer', 'Section (About Manufacturer)', 'vmg_about_manufacturer_callback', 'manufacturer', 'normal', 'default');

    //Authorize Dealer
    add_meta_box('vmg_authorize_dealer', 'Section (Authorize Dealer)', 'vmg_authorize_dealer_callback', 'manufacturer', 'normal', 'default');

    //Explore Steel Buildings
    add_meta_box('vmg_explore_buildings', 'Section (Explore Steel Buildings)', 'vmg_explore_buildings_callback', 'manufacturer', 'normal', 'default');

    //Color Option
    add_meta_box('vmg_color_option', 'Section (Color Option)', 'vmg_color_option_callback', 'manufacturer', 'normal', 'default');

    //Manufacturer’s Area
    add_meta_box('vmg_manufacturer_area', 'Section (Manufacturer’s Area)', 'vmg_manufacturer_area_callback', 'manufacturer', 'normal', 'default');
}

// Meta box HTML
function vmg_brand_logo_metabox_html($post)
{
    $image_id = get_post_meta($post->ID, '_brand_logo_id', true);
    $image_url = $image_id ? wp_get_attachment_image_url($image_id, 'medium') : '';

    $image_f_id = get_post_meta($post->ID, '_footer_brand_logo_id', true);
    $imagef_url = $image_f_id ? wp_get_attachment_image_url($image_f_id, 'medium') : '';

    wp_nonce_field('vmg_brand_logo_nonce_action', 'vmg_brand_logo_nonce');
?>
<div class="brand-logo-wrapper">
    <div class="brand-logo-preview" style="margin-bottom:10px;">
        <?php if ($image_url): ?>
        <img src="<?php echo esc_url($image_url); ?>" style="max-width:100%; height:auto;">
        <?php endif; ?>
    </div>

    <input type="hidden" name="brand_logo_id" id="brand_logo_id" value="<?php echo esc_attr($image_id); ?>">

    <button type="button"
        class="button upload-brand-logo"><?php echo $image_url ? 'Change Logo' : 'Set Brand Logo'; ?></button>
    <?php if ($image_url): ?>
    <button type="button" class="button remove-brand-logo">Remove Logo</button>
    <?php endif; ?>
</div>

<div class="footer-brand-logo-wrapper">
    <div class="footer-brand-logo-preview" style="margin-bottom:10px;">
        <?php if ($imagef_url): ?>
        <img src="<?php echo esc_url($imagef_url); ?>" style="max-width:100%; height:auto;">
        <?php endif; ?>
    </div>

    <input type="hidden" name="footer_brand_logo_id" id="footer_brand_logo_id"
        value="<?php echo esc_attr($image_f_id); ?>">

    <button type="button"
        class="button upload-footer-brand-logo"><?php echo $imagef_url ? 'Change Footer Logo' : 'Set footer Brand Logo'; ?></button>
    <?php if ($imagef_url): ?>
    <button type="button" class="button remove-footer-brand-logo">Remove Logo</button>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    let frame;

    // Upload/Change button
    $('.upload-brand-logo').off('click').on('click', function(e) {
        e.preventDefault();

        // If frame exists, reopen it
        if (frame) {
            frame.open();
            return;
        }

        frame = wp.media({
            title: 'Select Brand Logo',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });

        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            $('#brand_logo_id').val(attachment.id);
            $('.brand-logo-preview').html('<img src="' + attachment.url +
                '" style="max-width:100%; height:auto;">');
            $('.upload-brand-logo').text('Change Logo');
            if (!$('.remove-brand-logo').length) {
                $('.brand-logo-wrapper').append(
                    '<button type="button" class="button remove-brand-logo">Remove Logo</button>'
                );
            }
        });

        frame.open();
    });

    // Remove button
    $(document).on('click', '.remove-brand-logo', function(e) {
        e.preventDefault();
        $('#brand_logo_id').val('');
        $('.brand-logo-preview').html('');
        $(this).remove();
        $('.upload-brand-logo').text('Set Brand Logo');
    });

    // // Upload/Change button
    $('.upload-footer-brand-logo').off('click').on('click', function(e) {
        e.preventDefault();

        // If frame exists, reopen it
        if (frame) {
            frame.open();
            return;
        }

        frame = wp.media({
            title: 'Select Brand Logo',
            button: {
                text: 'Use this image'
            },
            multiple: false
        });

        frame.on('select', function() {
            const attachment = frame.state().get('selection').first().toJSON();
            $('#footer_brand_logo_id').val(attachment.id);
            $('.footer-brand-logo-preview').html('<img src="' + attachment.url +
                '" style="max-width:100%; height:auto;">');
            $('.upload-footer-brand-logo').text('Change Logo');
            if (!$('.remove-footer-brand-logo').length) {
                $('.footer-brand-logo-wrapper').append(
                    '<button type="button" class="button remove-footer-brand-logo">Remove Logo</button>'
                );
            }
        });

        frame.open();
    });

    // Remove button
    $(document).on('click', '.remove-footer-brand-logo', function(e) {
        e.preventDefault();
        $('#footer_brand_logo_id').val('');
        $('.footer-brand-logo-preview').html('');
        $(this).remove();
        $('.upload-footer-brand-logo').text('Set Brand Logo');
    });

});
</script>
<?php
}



/* -----------------------------
   1️⃣ Top Selling Building
------------------------------ */
function vmg_top_selling_callback($post)
{
    $title = get_post_meta($post->ID, '_top_selling_title', true);
    $subtitle = get_post_meta($post->ID, '_top_selling_subtitle', true);
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="top_selling_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>

<p><label><strong>Subtitle:</strong></label><br>
    <textarea name="top_selling_subtitle" class="widefat" rows="3"><?php echo esc_textarea($subtitle); ?></textarea>
</p>
<?php
}

/* -----------------------------
   2️⃣ About Manufacturer
------------------------------ */
function vmg_about_manufacturer_callback($post)
{
    $title = get_post_meta($post->ID, '_about_title', true);
    $desc = get_post_meta($post->ID, '_about_desc', true);
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="about_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>
<p><label><strong>Description:</strong></label></p>
<?php wp_editor($desc, 'about_desc', ['textarea_name' => 'about_desc', 'media_buttons' => true, 'textarea_rows' => 5]); ?>
<?php
}

/* -----------------------------
   3️⃣ Authorize Dealer
------------------------------ */
function vmg_authorize_dealer_callback($post)
{
    $title = get_post_meta($post->ID, '_auth_title', true);
    $desc = get_post_meta($post->ID, '_auth_desc', true);
    $image = get_post_meta($post->ID, '_auth_image', true);
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="auth_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>

<p><label><strong>Description:</strong></label></p>
<?php wp_editor($desc, 'auth_desc', ['textarea_name' => 'auth_desc', 'media_buttons' => true, 'textarea_rows' => 5]); ?>

<p><label><strong>Image:</strong></label></p>
<div class="auth-image-wrapper">
    <input type="hidden" name="auth_image" class="auth_image" value="<?php echo esc_attr($image); ?>">
    <div style="margin-bottom:10px;">
        <?php if ($image): ?>
        <img src="<?php echo esc_url($image); ?>" style="max-width:210px; height:auto;">
        <?php endif; ?>
    </div>
    <button type="button" class="button upload-auth-image"
        style="margin-right:10px;"><?php echo $image ? 'Change Image' : 'Upload Image'; ?></button>
    <?php if ($image): ?>
    <button type="button" class="button remove-auth-image">Remove Image</button>
    <?php endif; ?>
</div>
<?php
}

/* -----------------------------
   4️⃣ Explore Steel Buildings
------------------------------ */
function vmg_explore_buildings_callback($post)
{
    $title = get_post_meta($post->ID, '_explore_title', true);
    $desc = get_post_meta($post->ID, '_explore_desc', true);
    $selected = get_post_meta($post->ID, '_explore_categories', true) ?: [];

    $terms = get_terms(['taxonomy' => 'product-taxonomy', 'hide_empty' => false]);
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="explore_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>

<p><label><strong>Description:</strong></label></p>
<?php wp_editor($desc, 'explore_desc', ['textarea_name' => 'explore_desc', 'media_buttons' => true, 'textarea_rows' => 5]); ?>

<p><label><strong>Select Product Categories:</strong></label></p>
<select name="explore_categories[]" class="widefat select2-manufacturers" multiple>
    <?php foreach ($terms as $term): ?>
    <option value="<?php echo esc_attr($term->term_id); ?>" <?php selected(in_array($term->term_id, $selected)); ?>>
        <?php echo esc_html($term->name); ?>
    </option>
    <?php endforeach; ?>
</select>
<?php
}

/* -----------------------------
   5️⃣ Color Option
------------------------------ */
function vmg_color_option_callback($post)
{
    $title = get_post_meta($post->ID, '_color_title', true);
    $desc = get_post_meta($post->ID, '_color_desc', true);
    $colors = get_option('vmg_colors', array());
    $avail = get_option('vmg_colors_availability', []);
    $selected_colors = get_post_meta($post->ID, '_color_selected', true) ?: [];
    $selected_avail = get_post_meta($post->ID, '_color_avail_selected', true) ?: [];
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="color_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>

<p><label><strong>Description:</strong></label></p>
<?php wp_editor($desc, 'color_desc', ['textarea_name' => 'color_desc', 'media_buttons' => true, 'textarea_rows' => 5]); ?>

<p><label><strong>Select Colors:</strong></label></p>
<select name="color_selected[]" class="widefat select2-manufacturers" multiple>
    <?php foreach ($colors as $color): ?>
    <option value="<?php echo esc_attr($color['title']); ?>"
        <?php selected(in_array($color['title'], $selected_colors)); ?>>
        <?php echo esc_html($color['title']); ?>
    </option>
    <?php endforeach; ?>
</select>

<p><label><strong>Select Color Availability:</strong></label></p>
<select name="color_avail_selected[]" class="widefat select2-manufacturers" multiple>
    <?php foreach ($avail as $a): ?>
    <option value="<?php echo esc_attr($a['title']); ?>" <?php selected(in_array($a['title'], $selected_avail)); ?>>
        <?php echo esc_html($a['title']); ?>
    </option>
    <?php endforeach; ?>
</select>
<?php
}

/* -----------------------------
   6️⃣ Manufacturer’s Area
------------------------------ */
function vmg_manufacturer_area_callback($post)
{
    $title = get_post_meta($post->ID, '_area_title', true);
    $desc = get_post_meta($post->ID, '_area_desc', true);
    $images = get_post_meta($post->ID, '_area_images', true) ?: [];
    $link = get_post_meta($post->ID, '_area_link', true);
?>
<p><label><strong>Title:</strong></label><br>
    <input type="text" name="area_title" class="widefat" value="<?php echo esc_attr($title); ?>">
</p>

<p><label><strong>Description:</strong></label></p>
<?php wp_editor($desc, 'area_desc', ['textarea_name' => 'area_desc', 'media_buttons' => true, 'textarea_rows' => 5]); ?>

<p><strong>Images (max 2):</strong></p>
<div class="area-images-wrapper">
    <?php foreach ($images as $img): ?>
    <div class="img-item">
        <img src="<?php echo esc_url($img); ?>" style="max-width:240px; height:auto;"><br>
        <input type="hidden" name="area_images[]" value="<?php echo esc_attr($img); ?>">
    </div>
    <?php endforeach; ?>
</div>
<button type="button" class="button upload-area-images">Upload Images</button>

<p><label><strong>Manufacturer Website Link:</strong></label><br>
    <input type="text" name="area_link" class="widefat" value="<?php echo esc_attr($link); ?>">
</p>
<?php
}

/* -----------------------------
   SAVE ALL META FIELDS
------------------------------ */
add_action('save_post', 'vmg_save_manufacturer_meta');
function vmg_save_manufacturer_meta($post_id)
{
    $fields = [
        '_footer_brand_logo_id' => 'footer_brand_logo_id',
        '_brand_logo_id' => 'brand_logo_id',
        '_top_selling_title' => 'top_selling_title',
        '_top_selling_subtitle' => 'top_selling_subtitle',
        '_about_title' => 'about_title',
        '_about_desc' => 'about_desc',
        '_auth_title' => 'auth_title',
        '_auth_desc' => 'auth_desc',
        '_auth_image' => 'auth_image',
        '_explore_title' => 'explore_title',
        '_explore_desc' => 'explore_desc',
        '_explore_categories' => 'explore_categories',
        '_color_title' => 'color_title',
        '_color_desc' => 'color_desc',
        '_color_selected' => 'color_selected',
        '_color_avail_selected' => 'color_avail_selected',
        '_area_title' => 'area_title',
        '_area_desc' => 'area_desc',
        '_area_images' => 'area_images',
        '_area_link' => 'area_link',

    ];
    foreach ($fields as $meta_key => $field_name) {
        if (isset($_POST[$field_name])) {
            update_post_meta($post_id, $meta_key, $_POST[$field_name]);
        }
    }
}