<?php
add_action('add_meta_boxes', 'vmg_contact_page_metabox');

function vmg_contact_page_metabox()
{
    // Get the contact page object by slug
    $contact_page = get_page_by_path('contact', OBJECT, 'page');

    // Only add the meta box if the contact page exists
    if (isset($_GET['post']) && $contact_page->ID == $_GET['post']) {
        add_meta_box(
            'vmg_contact_page_fields',        // ID
            'Page Banner',            // Title
            'vmg_contact_page_callback',      // Callback function
            'page',                           // Post type
            'normal',                         // Context
            'default'                         // Priority
        );
    }
}

function vmg_contact_page_callback($post)
{
    // Only show for the contact page
    $contact_page = get_page_by_path('contact');
    if (!$contact_page || $post->ID != $contact_page->ID) {
        echo '<p>This meta box is only available on the Contact page.</p>';
        return;
    }

    // Get saved data
    $data = get_post_meta($post->ID, '_vmg_contact_page', true);
    $title = isset($data['title']) ? esc_attr($data['title']) : '';
    $subtitle = isset($data['subtitle']) ? esc_textarea($data['subtitle']) : '';

    // Output fields
    echo '<p><label><strong>Title</strong></label><br>';
    echo '<input type="text" name="vmg_contact_title" value="' . $title . '" style="width:100%;"></p>';

    echo '<p><label><strong>Subtitle</strong></label><br>';
    echo '<textarea name="vmg_contact_subtitle" rows="4" style="width:100%;">' . $subtitle . '</textarea></p>';
}

add_action('save_post', 'vmg_save_contact_page_meta');
function vmg_save_contact_page_meta($post_id)
{
    // Prevent autosave or unauthorized access
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    $contact_page = get_page_by_path('contact');
    if (!$contact_page || $post_id != $contact_page->ID) return;

    // Sanitize and save
    $data = [
        'title'    => isset($_POST['vmg_contact_title']) ? sanitize_text_field($_POST['vmg_contact_title']) : '',
        'subtitle' => isset($_POST['vmg_contact_subtitle']) ? sanitize_textarea_field($_POST['vmg_contact_subtitle']) : '',
    ];

    update_post_meta($post_id, '_vmg_contact_page', $data);
}