<?php
$saved_roof_styles = get_option('vmg_roof_styles', array());
?>

<h2>Roof Styles</h2>
<form method="post" action="">
    <?php wp_nonce_field('vmg_save_settings_nonce'); ?>


    <table id="roof-styles-table" class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th>Sr no. </th>
                <th>Title</th>
                <th>Description</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (!empty($saved_roof_styles)) {
                foreach ($saved_roof_styles as $index => $roof) {
            ?>
            <tr>
                <td class="sr-no"></td>
                <td><input type="text" name="roof_styles[<?php echo $index; ?>][title]"
                        value="<?php echo esc_attr($roof['title']); ?>" /></td>
                <td><textarea
                        name="roof_styles[<?php echo $index; ?>][description]"><?php echo esc_textarea($roof['description']); ?></textarea>
                </td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="roof-image" name="roof_styles[<?php echo $index; ?>][image]"
                            value="<?php echo esc_attr($roof['image']); ?>" />
                        <button class="button upload-image-roof" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-roof" type="button">Remove</button></td>
            </tr>
            <?php
                }
            }
            ?>
        </tbody>
    </table>
    <button id="add-roof" class="button button-primary" type="button">Add Roof Style</button>
    <?php submit_button('Save', 'primary', 'vmg_save'); ?>
</form>