var mediaUploader;
jQuery(document).ready(function ($) {
  var mediaUploader;

  function updateSrNo() {
    $("#benefits-table tbody tr").each(function (index) {
      $(this)
        .find("td.sr-no")
        .text(index + 1);
    });
  }

  $(document).on("click", ".upload-image-button", function (e) {
    e.preventDefault();

    var button = $(this);
    var input = button.siblings(".benefit-image");

    // Create the media frame if it doesn't exist
    if (!mediaUploader) {
      mediaUploader = wp.media({
        title: "Choose Image",
        button: { text: "Use this image" },
        multiple: false,
      });
    }

    // Remove previous select handlers to prevent multiple triggers
    mediaUploader.off("select");

    // Set new select handler for the current input
    mediaUploader.on("select", function () {
      var attachment = mediaUploader.state().get("selection").first().toJSON();
      input.val(attachment.url);
    });

    mediaUploader.open();
  });

  // Add new row
  $("#add-benefit_op").on("click", function () {
    var length = jQuery("#benefits-table tbody").find("tr").length;
    var row =
      `<tr>
            <td class="sr-no"></td>
            <td><input type="text" name="benefits[` +
      length +
      `][title]" /></td>
            <td><textarea name="benefits[` +
      length +
      `][description]"></textarea></td>
            <td>
                <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="benefits[` +
      length +
      `][image]" value="" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
            </td>
            <td><button class="button remove-benefit" type="button">Remove</button></td>
        </tr>`;
    $("#benefits-table tbody").append(row);
    updateSrNo();
  });
  $("#add-benefit").on("click", function () {
    var length = jQuery("#benefits-table tbody").find("tr").length;
    console.log(length);
    var row =
      `<tr>
            <td class="sr-no"></td>
            <td><input type="text" name="term_meta[benefits][` +
      length +
      `][title]" /></td>
            <td><textarea name="term_meta[benefits][` +
      length +
      `][description]"></textarea></td>
            <td>
                <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="term_meta[benefits][` +
      length +
      `][image]" value="" />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
            </td>
            <td><button class="button remove-benefit" type="button">Remove</button></td>
        </tr>`;
    $("#benefits-table tbody").append(row);
    updateSrNo();
  });

  // Remove row
  $(document).on("click", ".remove-benefit", function () {
    $(this).closest("tr").remove();
    updateSrNo();
  });

  // Initial update on page load
  updateSrNo();
});

jQuery(document).ready(function ($) {
  var mediaUploader;

  function updateRoofRows() {
    $("#roof-styles-table tbody tr").each(function (index) {
      // Update Sr No
      $(this)
        .find("td.sr-no")
        .text(index + 1);

      // Update input/textarea names
      $(this)
        .find("input, textarea")
        .each(function () {
          var fieldType = $(this).hasClass("roof-image")
            ? "image"
            : $(this).is("textarea")
            ? "description"
            : "title";
          $(this).attr("name", "roof_styles[" + index + "][" + fieldType + "]");
        });
    });
  }

  // Upload image
  $(document).on("click", ".upload-image-roof", function (e) {
    e.preventDefault();
    var button = $(this);
    var input = button.siblings("input");
    var selectedUrl = input.val(); // currently selected URL

    // Create new media frame
    var mediaUploader = wp.media({
      title: "Choose Image",
      button: { text: "Choose Image" },
      multiple: false,
    });

    // Pre-select the previously chosen image
    mediaUploader.on("open", function () {
      if (selectedUrl) {
        var selection = mediaUploader.state().get("selection");
        wp.media
          .attachment(selectedUrl)
          .fetch()
          .then(function (attachment) {
            selection.add(attachment);
          });
      }
    });

    // On select, update the input
    mediaUploader.on("select", function () {
      var attachment = mediaUploader.state().get("selection").first().toJSON();
      input.val(attachment.url);
    });

    mediaUploader.open();
  });

  // Add new row
  $("#add-roof").on("click", function () {
    var length = jQuery("#roof-styles-table tbody").find("tr").length;
    var row =
      `<tr>
            <td class="sr-no"></td>
            <td><input type="text" name="roof_styles[` +
      length +
      `][title]" /></td>
            <td><textarea name="roof_styles[` +
      length +
      `][description]"></textarea></td>
            <td>
                <div class="image-upload-wrapper">
                    <input type="text" class="roof-image" name="roof_styles[` +
      length +
      `][image]" />
                    <button class="button upload-image-button" type="button">Upload</button>
                </div>
            </td>
            <td><button class="button remove-roof" type="button">Remove</button></td>
        </tr>`;
    $("#roof-styles-table tbody").append(row);
    updateRoofRows();
  });

  // Remove row
  $(document).on("click", ".remove-roof", function () {
    $(this).closest("tr").remove();
    updateRoofRows();
  });

  // Initialize on page load
  updateRoofRows();
});
jQuery(document).ready(function ($) {
  $(".vmg-select2").select2({
    placeholder: "Select top-level product categories",
    allowClear: true,
    tags: true,
  });
  $(".vmg-select2").on("select2:select", function (evt) {
    var element = evt.params.data.element;
    var $element = $(element);

    $element.detach();
    $(this).append($element);
    $(this).trigger("change");
  });
  $(".select2-manufacturers").select2({
    placeholder: "Select",
    allowClear: true,
    sorter: function (data) {
      // return data as-is to preserve original order
      return data;
    },
  });
});

jQuery(document).ready(function ($) {
  var editorSettings = {
    tinymce: {
      wpautop: true,
      plugins: "link lists paste",
      toolbar1: "bold italic underline | bullist numlist | link unlink",
    },
    quicktags: true,
  };

  // Add new row
  $("#add-partner").on("click", function () {
    var index = $("#partners-body tr").length;
    var newRow = `
            <tr>
                <td class="sr-number">${index + 1}</td>
                <td width="20%">
                    <input type="text" class="partner-image" name="partners[${index}][image]" placeholder="Image URL">
                    <button class="button upload-pimage-button">Upload</button>
                </td>
                <td><textarea id="partners_${index}_desc" name="partners[${index}][description]" rows="5"></textarea></td>
                <td><textarea id="partners_${index}_features" name="partners[${index}][features]" rows="5"></textarea></td>
                <td><button class="button remove-row">Remove</button></td>
            </tr>`;
    $("#partners-body").append(newRow);

    // Initialize editors for the new textareas
    wp.editor.initialize(`partners_${index}_desc`, editorSettings);
    wp.editor.initialize(`partners_${index}_features`, editorSettings);

    updateSrNumbers();
  });

  $("#add-process").on("click", function () {
    var index = $("#process-body tr").length;
    var newRow = `
            <tr>
                <td width="5%" class="sr-number">${index + 1}</td>
                <td width="15%">
                    <input type="text" name="process[${index}][bgclass]" >
                </td>
                <td width="15%">
                    <input type="text" class="partner-image" name="process[${index}][image]" placeholder="Image URL">
                    <button class="button upload-pimage-button">Upload</button>
                </td>
                <td width="30%"><input type="text" name="process[${index}][title]" style="width:100%"></td>
                <td width="30%"><textarea id="process_${index}_description" name="process[${index}][description]" rows="5"></textarea></td>
                <td width="5%"><button class="button remove-row">Remove</button></td>


            </tr>`;
    $("#process-body").append(newRow);

    // Initialize editors for the new textareas
    wp.editor.initialize(`process_${index}_description`, editorSettings);

    updateSrNumbers();
  });

  // Remove row
  $(document).on("click", ".remove-row", function (e) {
    e.preventDefault();
    var row = $(this).closest("tr");

    // Destroy editors before removing
    row.find("textarea").each(function () {
      var id = $(this).attr("id");
      if (typeof tinymce !== "undefined" && tinymce.get(id)) {
        tinymce.execCommand("mceRemoveEditor", false, id);
      }
    });

    row.remove();
    updateSrNumbers();
  });

  // Update Sr numbers
  function updateSrNumbers() {
    $("#partners-body tr").each(function (i) {
      $(this)
        .find(".sr-number")
        .text(i + 1);
    });
  }

  // Media uploader
  $(document).on("click", ".upload-pimage-button", function (e) {
    e.preventDefault();
    e.preventDefault();

    var button = $(this);
    var input = button.siblings(".partner-image");

    // Create a new media uploader each time
    var mediaUploader = wp.media({
      title: "Choose Image",
      button: { text: "Choose Image" },
      multiple: false,
    });

    mediaUploader.on("select", function () {
      var attachment = mediaUploader.state().get("selection").first().toJSON();
      input.val(attachment.url);
    });
    mediaUploader.open();
  });
});

jQuery(document).ready(function ($) {
  // Upload for single images
  $(document).on("click", ".upload-auth-image", function (e) {
    e.preventDefault();
    const button = $(this);
    let frame = wp.media({
      title: "Select Image",
      button: {
        text: "Use Image",
      },
      multiple: false,
    });
    frame.on("select", function () {
      const attachment = frame.state().get("selection").first().toJSON();
      button.siblings(".auth_image").val(attachment.url);
      button
        .siblings(".preview")
        .html(
          '<img src="' +
            attachment.url +
            '" style="max-width:100%;height:auto;">'
        );
      if (!button.siblings(".remove-auth-image").length) {
        button.after(
          '<button type="button" class="button remove-auth-image">Remove Image</button>'
        );
      }
    });
    frame.open();
  });

  $(document).on("click", ".remove-auth-image", function () {
    $(this).siblings(".auth_image").val("");
    $(this).siblings(".preview").html("");
    $(this).remove();
  });

  // Upload multiple (max 2)
  $(document).on("click", ".upload-area-images", function (e) {
    e.preventDefault();
    let wrapper = $(".area-images-wrapper");
    let frame = wp.media({
      title: "Select up to 2 Images",
      button: {
        text: "Use these",
      },
      multiple: true,
    });
    frame.on("select", function () {
      const selection = frame.state().get("selection").toJSON();
      wrapper.empty();
      selection.slice(0, 2).forEach((att) => {
        wrapper.append(
          '<div class="img-item"><img src="' +
            att.url +
            '" style="max-width:100%;height:auto;"><br><input type="hidden" name="area_images[]" value="' +
            att.url +
            '"></div>'
        );
      });
    });
    frame.open();
  });
});

jQuery(document).ready(function ($) {
  function updateSrNumbers() {
    $("#colors-body tr").each(function (i) {
      $(this)
        .find(".sr-no")
        .text(i + 1);
    });
  }
  $("#add-color_op").on("click", function () {
    var index = $("#colors-body tr").length;
    var newRow = `
            <tr>
              <td class="sr-no">${index + 1}</td>
                <td><input type="text" name="colors[${index}][title]"  /></td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="colors[${index}][image]"  />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-color" type="button">Remove</button></td>
            </tr>`;
    $("#colors-body").append(newRow);
    updateSrNumbers();
  });
  function updateSrNumbersOne() {
    $("#colors-body1 tr").each(function (i) {
      $(this)
        .find(".sr-no")
        .text(i + 1);
    });
  }
  $("#add-color_op1").on("click", function () {
    var index1 = $("#colors-body1 tr").length;
    var newRow = `
            <tr>
              <td class="sr-no">${index1 + 1}</td>
                <td><input type="text" name="avai_colors[${index1}][title]"  /></td>
                <td>
                    <div class="image-upload-wrapper">
                        <input type="text" class="benefit-image" name="avai_colors[${index1}][image]"  />
                        <button class="button upload-image-button" type="button">Upload</button>
                    </div>
                </td>
                <td><button class="button remove-color" type="button">Remove</button></td>
            </tr>`;
    $("#colors-body1").append(newRow);
    updateSrNumbersOne();
  });
  $(document).on("click", ".remove-color", function () {
    $(this).closest("tr").remove();
    updateSrNumbers();
    updateSrNumbersOne();
  });
});
