jQuery(document).ready(function ($) {
  $(document).on("click", ".featured-star", function (e) {
    e.preventDefault();
    var $star = $(this);
    var postId = $star.data("postid");

    if (!postId) {
      console.error("Missing post id on featured-star element");
      return;
    }

    // Optional loading class
    $star.addClass("updating");

    $.post(
      featuredStar.ajax_url,
      {
        action: "toggle_featured",
        post_id: postId,
        nonce: featuredStar.nonce,
      },
      function (resp) {
        $star.removeClass("updating");
        if (resp && resp.success) {
          $star.toggleClass("dashicons-star-filled dashicons-star-empty");
        } else {
          var msg =
            resp && resp.data && resp.data.message
              ? resp.data.message
              : "Unknown error";
          console.error("Toggle featured failed: " + msg);
          alert("Could not toggle featured: " + msg);
        }
      },
      "json"
    ).fail(function (jqXHR, textStatus, errorThrown) {
      $star.removeClass("updating");
      console.error("AJAX error: " + textStatus);
      alert("AJAX error: " + textStatus);
    });
  });
});
