<?php





/**

 * Twenty Seventeen functions and definitions

 *

 * @link https://developer.wordpress.org/themes/basics/theme-functions/

 *

 * @package WordPress

 * @subpackage Twenty_Seventeen

 * @since 1.0

 */



/**

 * Twenty Seventeen only works in WordPress 4.7 or later.

 */

if (version_compare($GLOBALS['wp_version'], '4.7-alpha', '<')) {

    require get_template_directory() . '/inc/back-compat.php';

    return;
}

$ctfile = get_template_directory() . '/inc/endpoints-customizations/vmg-custom-fields.php';
if (file_exists($ctfile)) {
    require_once $ctfile;
}



/**

 * Sets up theme defaults and registers support for various WordPress features.

 *

 * Note that this function is hooked into the after_setup_theme hook, which

 * runs before the init hook. The init hook is too late for some features, such

 * as indicating support for post thumbnails.

 */

function twentyseventeen_setup()
{

    /*

	 * Make theme available for translation.

	 * Translations can be filed at WordPress.org. See: https://translate.wordpress.org/projects/wp-themes/twentyseventeen

	 * If you're building a theme based on Twenty Seventeen, use a find and replace

	 * to change 'twentyseventeen' to the name of your theme in all the template files.

	 */

    load_theme_textdomain('twentyseventeen');



    // Add default posts and comments RSS feed links to head.

    //	add_theme_support( 'automatic-feed-links' );



    /*

	 * Let WordPress manage the document title.

	 * By adding theme support, we declare that this theme does not use a

	 * hard-coded <title> tag in the document head, and expect WordPress to

	 * provide it for us.

	 */

    add_theme_support('title-tag');



    /*

	 * Enable support for Post Thumbnails on posts and pages.

	 *

	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/

	 */

    add_theme_support('post-thumbnails');



    add_image_size('twentyseventeen-featured-image', 2000, 1200, true);



    add_image_size('twentyseventeen-thumbnail-avatar', 100, 100, true);



    // Set the default content width.

    $GLOBALS['content_width'] = 525;



    // This theme uses wp_nav_menu() in two locations.

    register_nav_menus(array(

        'primary' => esc_html__('Primary', 'egnoto'),

        'bottom'    => __('Bottom', 'egnoto'),

    ));


add_filter( 'big_image_size_threshold', '__return_false' );



    add_filter('nav_menu_css_class', 'so_37823371_menu_item_class', 10, 4);



    function so_37823371_menu_item_class($classes, $item, $args, $depth)
    {

        $classes[] = 'menu-li';

        return $classes;
    }

    /*

	 * Switch default core markup for search form, comment form, and comments

	 * to output valid HTML5.

	 */

    add_theme_support('html5', array(

        'comment-form',

        'comment-list',

        'gallery',

        'caption',

    ));



    /*

	 * Enable support for Post Formats.

	 *

	 * See: https://codex.wordpress.org/Post_Formats

	 */

    add_theme_support('post-formats', array(

        'aside',

        'image',

        'video',

        'quote',

        'link',

        'gallery',

        'audio',

    ));



    // Add theme support for Custom Logo.

    add_theme_support('custom-logo', array(

        'width'       => 250,

        'height'      => 250,

        'flex-width'  => true,

    ));



    // Add theme support for selective refresh for widgets.

    add_theme_support('customize-selective-refresh-widgets');



    /*

	 * This theme styles the visual editor to resemble the theme style,

	 * specifically font, colors, and column width.

 	 */

    add_editor_style(array('assets/css/editor-style.css', twentyseventeen_fonts_url()));



    // Define and register starter content to showcase the theme on new sites.

    $starter_content = array(

        'widgets' => array(

            // Place three core-defined widgets in the sidebar area.

            'sidebar-1' => array(

                'text_business_info',

                'search',

                'text_about',

            ),



            // Add the core-defined business info widget to the footer 1 area.

            'sidebar-2' => array(

                'text_business_info',

            ),



            // Put two core-defined widgets in the footer 2 area.

            'sidebar-3' => array(

                'text_about',

                'search',

            ),

        ),



        // Specify the core-defined pages to create and add custom thumbnails to some of them.

        'posts' => array(

            'home',

            'about' => array(

                'thumbnail' => '{{image-sandwich}}',

            ),

            'contact' => array(

                'thumbnail' => '{{image-espresso}}',

            ),

            'blog' => array(

                'thumbnail' => '{{image-coffee}}',

            ),

            'homepage-section' => array(

                'thumbnail' => '{{image-espresso}}',

            ),

        ),



        // Create the custom image attachments used as post thumbnails for pages.

        'attachments' => array(

            'image-espresso' => array(

                'post_title' => _x('Espresso', 'Theme starter content', 'twentyseventeen'),

                'file' => 'assets/images/espresso.jpg', // URL relative to the template directory.

            ),

            'image-sandwich' => array(

                'post_title' => _x('Sandwich', 'Theme starter content', 'twentyseventeen'),

                'file' => 'assets/images/sandwich.jpg',

            ),

            'image-coffee' => array(

                'post_title' => _x('Coffee', 'Theme starter content', 'twentyseventeen'),

                'file' => 'assets/images/coffee.jpg',

            ),

        ),



        // Default to a static front page and assign the front and posts pages.

        'options' => array(

            'show_on_front' => 'page',

            'page_on_front' => '{{home}}',

            'page_for_posts' => '{{blog}}',

        ),



        // Set the front page section theme mods to the IDs of the core-registered pages.

        'theme_mods' => array(

            'panel_1' => '{{homepage-section}}',

            'panel_2' => '{{about}}',

            'panel_3' => '{{blog}}',

            'panel_4' => '{{contact}}',

        ),



        // Set up nav menus for each of the two areas registered in the theme.

        'nav_menus' => array(

            // Assign a menu to the "top" location.

            'top' => array(

                'name' => __('Top Menu', 'twentyseventeen'),

                'items' => array(

                    'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.

                    'page_about',

                    'page_blog',

                    'page_contact',

                ),

            ),



            // Assign a menu to the "social" location.

            'social' => array(

                'name' => __('Social Links Menu', 'twentyseventeen'),

                'items' => array(

                    'link_yelp',

                    'link_facebook',

                    'link_twitter',

                    'link_instagram',

                    'link_email',

                ),

            ),

        ),

    );



    /**

     * Filters Twenty Seventeen array of starter content.

     *

     * @since Twenty Seventeen 1.1

     *

     * @param array $starter_content Array of starter content.

     */

    $starter_content = apply_filters('twentyseventeen_starter_content', $starter_content);



    add_theme_support('starter-content', $starter_content);
}

add_action('after_setup_theme', 'twentyseventeen_setup');



/**

 * Set the content width in pixels, based on the theme's design and stylesheet.

 *

 * Priority 0 to make it available to lower priority callbacks.

 *

 * @global int $content_width

 */

function twentyseventeen_content_width()
{



    $content_width = $GLOBALS['content_width'];



    // Get layout.

    $page_layout = get_theme_mod('page_layout');



    // Check if layout is one column.

    if ('one-column' === $page_layout) {

        if (twentyseventeen_is_frontpage()) {

            $content_width = 644;
        } elseif (is_page()) {

            $content_width = 740;
        }
    }



    // Check if is single post and there is no sidebar.

    if (is_single() && ! is_active_sidebar('sidebar-1')) {

        $content_width = 740;
    }



    /**

     * Filter Twenty Seventeen content width of the theme.

     *

     * @since Twenty Seventeen 1.0

     *

     * @param int $content_width Content width in pixels.

     */

    $GLOBALS['content_width'] = apply_filters('twentyseventeen_content_width', $content_width);
}

add_action('template_redirect', 'twentyseventeen_content_width', 0);



/**

 * Register custom fonts.

 */

function twentyseventeen_fonts_url()
{

    $fonts_url = '';



    /*

	 * Translators: If there are characters in your language that are not

	 * supported by Libre Franklin, translate this to 'off'. Do not translate

	 * into your own language.

	 */

    $libre_franklin = _x('on', 'Libre Franklin font: on or off', 'twentyseventeen');



    if ('off' !== $libre_franklin) {

        $font_families = array();



        $font_families[] = 'Libre Franklin:300,300i,400,400i,600,600i,800,800i';



        $query_args = array(

            'family' => urlencode(implode('|', $font_families)),

            'subset' => urlencode('latin,latin-ext'),

        );



        $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
    }



    return esc_url_raw($fonts_url);
}



/**

 * Add preconnect for Google Fonts.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param array  $urls           URLs to print for resource hints.

 * @param string $relation_type  The relation type the URLs are printed.

 * @return array $urls           URLs to print for resource hints.

 */

function twentyseventeen_resource_hints($urls, $relation_type)
{

    if (wp_style_is('twentyseventeen-fonts', 'queue') && 'preconnect' === $relation_type) {

        $urls[] = array(

            'href' => 'https://fonts.gstatic.com',

            'crossorigin',

        );
    }



    return $urls;
}

add_filter('wp_resource_hints', 'twentyseventeen_resource_hints', 10, 2);



/**

 * Register widget area.

 *

 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar

 */

function twentyseventeen_widgets_init()
{

    register_sidebar(array(

        'name'          => __('Blog Sidebar', 'twentyseventeen'),

        'id'            => 'sidebar-1',

        'description'   => __('Add widgets here to appear in your sidebar on blog posts and archive pages.', 'twentyseventeen'),

        'before_widget' => '<section id="%1$s" class="widget %2$s">',

        'after_widget'  => '</section>',

        'before_title'  => '<h2 class="widget-title">',

        'after_title'   => '</h2>',

    ));



    register_sidebar(array(

        'name'          => __('Footer 1', 'twentyseventeen'),

        'id'            => 'sidebar-2',

        'description'   => __('Add widgets here to appear in your footer.', 'twentyseventeen'),

        'before_widget' => '<section id="%1$s" class="widget %2$s">',

        'after_widget'  => '</section>',

        'before_title'  => '<h2 class="widget-title">',

        'after_title'   => '</h2>',

    ));



    register_sidebar(array(

        'name'          => __('Footer 2', 'twentyseventeen'),

        'id'            => 'sidebar-3',

        'description'   => __('Add widgets here to appear in your footer.', 'twentyseventeen'),

        'before_widget' => '<section id="%1$s" class="widget %2$s">',

        'after_widget'  => '</section>',

        'before_title'  => '<h2 class="widget-title">',

        'after_title'   => '</h2>',

    ));
}

add_action('widgets_init', 'twentyseventeen_widgets_init');



/**

 * Replaces "[...]" (appended to automatically generated excerpts) with ... and

 * a 'Continue reading' link.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param string $link Link to single post/page.

 * @return string 'Continue reading' link prepended with an ellipsis.

 */

function twentyseventeen_excerpt_more($link)
{

    if (is_admin()) {

        return $link;
    }



    $link = sprintf(
        '<p class="link-more"><a href="%1$s" class="more-link">%2$s</a></p>',

        esc_url(get_permalink(get_the_ID())),

        /* translators: %s: Name of current post */

        sprintf(__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'twentyseventeen'), get_the_title(get_the_ID()))

    );

    return ' &hellip; ' . $link;
}

add_filter('excerpt_more', 'twentyseventeen_excerpt_more');



/**

 * Handles JavaScript detection.

 *

 * Adds a `js` class to the root `<html>` element when JavaScript is detected.

 *

 * @since Twenty Seventeen 1.0

 */

function twentyseventeen_javascript_detection()
{

    echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}

add_action('wp_head', 'twentyseventeen_javascript_detection', 0);



/**

 * Add a pingback url auto-discovery header for singularly identifiable articles.

 */

function twentyseventeen_pingback_header()
{

    if (is_singular() && pings_open()) {

        printf('<link rel="pingback" href="%s">' . "\n", get_bloginfo('pingback_url'));
    }
}

add_action('wp_head', 'twentyseventeen_pingback_header');



/**

 * Display custom color CSS.

 */

function twentyseventeen_colors_css_wrap()
{

    if ('custom' !== get_theme_mod('colorscheme') && ! is_customize_preview()) {

        return;
    }



    require_once(get_parent_theme_file_path('/inc/color-patterns.php'));

    $hue = absint(get_theme_mod('colorscheme_hue', 250));

?>

<style type="text/css" id="custom-theme-colors" <?php if (is_customize_preview()) {
                                                        echo 'data-hue="' . $hue . '"';
                                                    } ?>>
<?php echo twentyseventeen_custom_colors_css();
?>
</style>

<?php }

add_action('wp_head', 'twentyseventeen_colors_css_wrap');







/**

 * Add custom image sizes attribute to enhance responsive image functionality

 * for content images.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param string $sizes A source size value for use in a 'sizes' attribute.

 * @param array  $size  Image size. Accepts an array of width and height

 *                      values in pixels (in that order).

 * @return string A source size value for use in a content image 'sizes' attribute.

 */

function twentyseventeen_content_image_sizes_attr($sizes, $size)
{

    $width = $size[0];



    if (740 <= $width) {

        $sizes = '(max-width: 706px) 89vw, (max-width: 767px) 82vw, 740px';
    }



    if (is_active_sidebar('sidebar-1') || is_archive() || is_search() || is_home() || is_page()) {

        if (! (is_page() && 'one-column' === get_theme_mod('page_options')) && 767 <= $width) {

            $sizes = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
        }
    }



    return $sizes;
}

add_filter('wp_calculate_image_sizes', 'twentyseventeen_content_image_sizes_attr', 10, 2);



/**

 * Filter the `sizes` value in the header image markup.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param string $html   The HTML image tag markup being filtered.

 * @param object $header The custom header object returned by 'get_custom_header()'.

 * @param array  $attr   Array of the attributes for the image tag.

 * @return string The filtered header image HTML.

 */

function twentyseventeen_header_image_tag($html, $header, $attr)
{

    if (isset($attr['sizes'])) {

        $html = str_replace($attr['sizes'], '100vw', $html);
    }

    return $html;
}

add_filter('get_header_image_tag', 'twentyseventeen_header_image_tag', 10, 3);



/**

 * Add custom image sizes attribute to enhance responsive image functionality

 * for post thumbnails.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param array $attr       Attributes for the image markup.

 * @param int   $attachment Image attachment ID.

 * @param array $size       Registered image size or flat array of height and width dimensions.

 * @return array The filtered attributes for the image markup.

 */

function twentyseventeen_post_thumbnail_sizes_attr($attr, $attachment, $size)
{

    if (is_archive() || is_search() || is_home()) {

        $attr['sizes'] = '(max-width: 767px) 89vw, (max-width: 1000px) 54vw, (max-width: 1071px) 543px, 580px';
    } else {

        $attr['sizes'] = '100vw';
    }



    return $attr;
}

add_filter('wp_get_attachment_image_attributes', 'twentyseventeen_post_thumbnail_sizes_attr', 10, 3);



/**

 * Use front-page.php when Front page displays is set to a static page.

 *

 * @since Twenty Seventeen 1.0

 *

 * @param string $template front-page.php.

 *

 * @return string The template to be used: blank if is_home() is true (defaults to index.php), else $template.

 */

function twentyseventeen_front_page_template($template)
{

    return is_home() ? '' : $template;
}

add_filter('frontpage_template',  'twentyseventeen_front_page_template');



/**

 * Modifies tag cloud widget arguments to display all tags in the same font size

 * and use list format for better accessibility.

 *

 * @since Twenty Seventeen 1.4

 *

 * @param array $args Arguments for tag cloud widget.

 * @return array The filtered arguments for tag cloud widget.

 */

function twentyseventeen_widget_tag_cloud_args($args)
{

    $args['largest']  = 1;

    $args['smallest'] = 1;

    $args['unit']     = 'em';

    $args['format']   = 'list';



    return $args;
}

add_filter('widget_tag_cloud_args', 'twentyseventeen_widget_tag_cloud_args');



/**

 * Implement the Custom Header feature.

 */

require get_parent_theme_file_path('/inc/custom-header.php');



/**

 * Custom template tags for this theme.

 */

require get_parent_theme_file_path('/inc/template-tags.php');



/**

 * Additional features to allow styling of the templates.

 */

require get_parent_theme_file_path('/inc/template-functions.php');



/**

 * Customizer additions.

 */

require get_parent_theme_file_path('/inc/customizer.php');



/**

 * SVG icons functions and filters.

 */

require get_parent_theme_file_path('/inc/icon-functions.php');



add_action('wpcf7_before_send_mail', 'wpcf7_add_text_to_mail_body');



function wpcf7_add_text_to_mail_body($contact_form)
{



    $submission = WPCF7_Submission::get_instance();

    if ($submission) {

        $posted_data = $submission->get_posted_data();

        //print_r($posted_data);

    }
}

function theme_slug_filter_wp_title($title)
{

    if (is_404()) {

        $title = 'ADD 404 TEXT HERE';
    }

    return $title;
}

add_filter('wp_title', 'theme_slug_filter_wp_title');


// Different template for subcategories

function wpd_subcategory_template($template)
{

    $cat        = get_queried_object();

    //	echo "<pre>"; print_R($cat); die;

    $children   = get_terms($cat->taxonomy, array(

        'parent'     => $cat->term_id,

        'hide_empty' => false

    ));



    if (! $children) {

        $template = locate_template('category-country-city.php');
    } elseif (0 < $cat->category_parent) {

        $template = locate_template('category-country.php');
    }



    return $template;
}

add_filter('category_template', 'wpd_subcategory_template');

/**

 * Fix pagination on archive pages

 * After adding a rewrite rule, go to Settings > Permalinks and click Save to flush the rules cache

 */

function my_pagination_rewrite()
{

    add_rewrite_rule('blog/page/?([0-9]{1,})/?$', 'index.php?category_name=blog&paged=$matches[1]', 'top');
}

add_action('init', 'my_pagination_rewrite');

function ov3rfly_replace_include_blank($name, $text, &$html)

{

    $matches = false;

    preg_match('/<select name="' . $name . '"[^>]*>(.*)<\/select>/iU', $html, $matches);

    if ($matches) {

        $select = str_replace('<option value="">---</option>', '<option value="">' . $text . '</option>', $matches[0]);

        $html = preg_replace('/<select name="' . $name . '"[^>]*>(.*)<\/select>/iU', $select, $html);
    }

    add_filter('wpcf7_form_elements', 'my_wpcf7_form_elements');
}



function my_wpcf7_form_elements($html)

{

    ov3rfly_replace_include_blank('State', 'Select State*', $html);

    ov3rfly_replace_include_blank('building-type', 'Building Type*', $html);

    ov3rfly_replace_include_blank('Building', 'Select Building*', $html);

    ov3rfly_replace_include_blank('bfp_cutom_state', 'Select State', $html);

    return $html;
}

add_filter('wpcf7_form_elements', 'my_wpcf7_form_elements');

function GetBFP($posts_per_page = 8, $pagenumber = '', $termid = '', $dealer = '', $orderby = '', $min_price = '')

{

    $return = array();
    $products = array();
    $islast = FALSE;
    $args = array();

    $args['post_status'] = 'publish';

    $args['post_type'] = 'product';

    $args['posts_per_page'] = $posts_per_page;



    if ($orderby == '') {

        $args['orderby'] = 'ID';

        $args['order'] = 'DESC';
    } else {

        $args['orderby'] = 'rand';
    }



    if ($pagenumber != '') {

        $args['paged'] = $pagenumber;
    }



    $args['tax_query'] =  array('relation' => 'AND');

    if ($termid != '') {

        $args['tax_query'][] = array('taxonomy' => 'product-taxonomy', 'field' => 'slug', 'terms' => array($termid));
    }









    $query = new WP_Query($args);

    $totalpages = $query->max_num_pages;

    $totalpost = $query->found_posts;

    if ($pagenumber != '') {

        if ($pagenumber >= $totalpages) {

            $islast = TRUE;
        }
    }



    if ($query->have_posts()) {

        foreach ($query->posts as $currentpost) {

            $products[] = $currentpost;
        }
    }



    $return['products'] = $products;

    $return['islast'] = $islast;

    $return['totalpages'] = $totalpages;

    $return['totalpost'] = $totalpost;

    return $return;
}

function GetBFPManufacture($posts_per_page = 8, $pagenumber = '', $termid = '', $dealer = '', $orderby = '', $min_price = '')

{

    $return = array();
    $products = array();
    $islast = FALSE;
    $args = array();

    $args['post_status'] = 'publish';

    $args['post_type'] = 'product';

    $args['posts_per_page'] = $posts_per_page;



    if ($orderby == '') {

        $args['orderby'] = 'ID';

        $args['order'] = 'DESC';
    } else {

        $args['orderby'] = 'rand';
    }



    if ($pagenumber != '') {

        $args['paged'] = $pagenumber;
    }

    if ($dealer != '') {

        $args['meta_query'] = array(

            array(

                'key' => 'manufacture-listing',

                'value' => $dealer

            ),

        );
    }

    $args['tax_query'] =  array('relation' => 'AND');

    if ($termid != '') {

        $args['tax_query'][] = array('taxonomy' => 'product-taxonomy', 'field' => 'slug', 'terms' => array($termid));
    }


    $query = new WP_Query($args);
    // var_dump( $query->request ); die;

    $totalpages = $query->max_num_pages;

    $totalpost = $query->found_posts;

    if ($pagenumber != '') {

        if ($pagenumber >= $totalpages) {

            $islast = TRUE;
        }
    }



    if ($query->have_posts()) {

        foreach ($query->posts as $currentpost) {

            $products[] = $currentpost;
        }
    }



    $return['products'] = $products;

    $return['islast'] = $islast;

    $return['totalpages'] = $totalpages;

    $return['totalpost'] = $totalpost;

    return $return;
}

function GetBuyFromPhotoHtml($singleproduct)

{

    $b_url = get_permalink($singleproduct->ID);

    $b_url = rtrim($b_url, '/');

    //echo "<pre>"; print_R($singleproduct); die;

    $article = '';

    $article .= ' <div class="vmg_building_bx">';

    $article .= ' <div class="vmg_card_bximg" data-aos-delay="100">';

    $img = wp_get_attachment_image_src(get_post_thumbnail_id($singleproduct->ID), 'medium_large');

    $excerpt = $singleproduct->post_excerpt;

    $excerpt = substr($excerpt, 0, 250);

    $excerptshort = substr($excerpt, 0, strrpos($excerpt, ' '));

    $price = get_post_meta($singleproduct->ID, 'prices', true);

    //$article.='<div class="product-img">';

    $article .= '<a href="' . $b_url . '">';

    $article .= '<img src="' . $img[0] . '" class="img-fluid" alt="' . $singleproduct->post_title . '" title="' . $singleproduct->post_title . '">';

    $article .= '</a>';

    //$article .='<div class="product-overlay"></div>';

    $article .= '<div class="product_hover">';

    $article .= '<p class="">' . $excerpt . '</p>';

    $article .= '<a href="' . $b_url . '" class="btn btn-white-outline"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none"><path d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z" fill="#fff"/></svg></a>';

    $article .= '</div>';

    $article .= '</div>';



    $article .= '<div class="vmg_building_info">';
    $article .= '<a href="' . $b_url . '">';
    $article .= '<h3>' . $singleproduct->post_title . '</h3>';
    $article .= '</a>';
    $article .= '<p class="vmg_building_price">Starting from: <span>$' . number_format($price) . '</span></p>';

    $article .= '<div class="vmg_building_action">';

    $article .= '<a href="tel:+1(704)-741-1587" class="vmg_view_call vmg_cmn_btn" onclick="ga(\'send\', \'event\', { eventCategory: \'phone call\', eventAction: \'click\', eventLabel: \'7047411587\'});"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 28 28" style="enable-background:new 0 0 28 28;" xml:space="preserve"><g><polygon class="st0" points="19.4,1 19.4,3.2 23.3,3.2 16.5,10 18,11.5 24.8,4.7 24.8,8.6 27,8.6 27,1" style="fill: #283044;"></polygon><path class="st0" d="M20.7,16.1c-1-1-2.6-1-3.6,0l-1.8,1.7c-0.2,0.2-0.4,0.2-0.6,0l-4.5-4.5c-0.2-0.2-0.2-0.4,0-0.6l1.7-1.8
            								c1-1,1-2.6,0-3.6L8.2,3.6c-1-1-2.7-1-3.6,0l-2,2c-3.2,3.2-1.4,10.1,4.2,15.7c3.7,3.7,8,5.8,11.4,5.8c1.7,0,3.2-0.5,4.3-1.6l2-2
            								c0.5-0.5,0.8-1.1,0.8-1.8c0-0.7-0.3-1.3-0.8-1.8L20.7,16.1z M22.9,21.9l-2,2c-2.3,2.3-8.1,0.4-12.6-4.2C3.7,15.2,1.8,9.4,4.1,7.1
            								l2-2C6.2,5,6.3,5,6.4,5c0.1,0,0.2,0,0.3,0.1l3.7,3.7c0.2,0.2,0.2,0.4,0,0.6l-1.7,1.8c-1,1-1,2.6,0,3.6l4.5,4.5c1,1,2.6,1,3.6,0
            								l1.8-1.7c0.2-0.2,0.4-0.2,0.6,0l3.7,3.7c0.1,0.1,0.1,0.2,0.1,0.3C23,21.7,23,21.8,22.9,21.9z" style="fill: #283044;"></path>
            						</g>
        						</svg></a>';

    $article .= '<a href="javascript:void(0);"  class="vmg_get_price vmg_cmn_btn bfp_get_price" data-toggle="modal" data-target="#requestform" onclick="openGetYourPriceRequest(this)" data-product_title="' . $singleproduct->post_title . '" data-producturl="' . $b_url . '" id="' . $singleproduct->ID . '">Request Price <svg id="arrow--right" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path id="Path_16735" data-name="Path 16735" d="M14.5,6,13.427,7.045l5.685,5.705H4v1.5H19.112l-5.685,5.68L14.5,21,22,13.5Z" transform="translate(-1 -1.5)" fill="#fff"></path>
                                    <rect id="_Transparent_Rectangle_" data-name="<Transparent Rectangle>" width="24" height="24" fill="none"></rect>
                                </svg></a>';
    $article .= '<a href="' . $b_url . '" class="vmg_view_dtl vmg_cmn_btn">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none">
                                    <path d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z" fill="#283044"/>
                                </svg>
                            </a>';

    $article .= '</div>';

    //$article.='</div>';



    $article .= '</div>';

    $article .= '</div>';



    //$article=$singleproduct->ID;

    return $article;
}

function GetBuyFromPhotoHtmlOther($singleproduct)

{

    $b_url = get_permalink($singleproduct->ID);

    $b_url = rtrim($b_url, '/');

    $article = '';

    $article .= ' <div class="vmg_card_bximg" data-aos-delay="100">';

    $img = wp_get_attachment_image_src(get_post_thumbnail_id($singleproduct->ID), 'medium_large');

    $excerpt = $singleproduct->post_excerpt;

    $excerpt = substr($excerpt, 0, 250);

    $excerptshort = substr($excerpt, 0, strrpos($excerpt, ' '));

    $price = get_post_meta($singleproduct->ID, 'prices', true);

    //$article.='<div class="product-img">';

    $article .= '<a href="' . $b_url . '">';

    $article .= '<img src="' . $img[0] . '" class="img-fluid" alt="' . $singleproduct->post_title . '" title="' . $singleproduct->post_title . '">';

    $article .= '</a>';

    $article .= '<div class="product_hover">';

    $article .= '<p class="">' . $excerpt . '</p>';

    $article .= '<a href="' . $b_url . '" class="btn btn-white-outline"><svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none"><path d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z" fill="#fff"/></svg></a>';

    $article .= '</div>';

    $article .= '</div>';

    $article .= '<div class="vmg_building_info">';
    $article .= '<a href="' . $b_url . '">';
    $article .= '<h3>' . $singleproduct->post_title . '</h3>';
    $article .= '</a>';
    $article .= '<p class="vmg_building_price">Starting from: <span>$' . number_format($price) . '</span></p>';

    $article .= '<div class="vmg_building_action">';

    $article .= '<a href="tel:+1(704)-741-1587" class="vmg_view_call vmg_cmn_btn" onclick="ga(\'send\', \'event\', { eventCategory: \'phone call\', eventAction: \'click\', eventLabel: \'7047411587\'});"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 28 28" style="enable-background:new 0 0 28 28;" xml:space="preserve"><g><polygon class="st0" points="19.4,1 19.4,3.2 23.3,3.2 16.5,10 18,11.5 24.8,4.7 24.8,8.6 27,8.6 27,1" style="fill: #283044;"></polygon><path class="st0" d="M20.7,16.1c-1-1-2.6-1-3.6,0l-1.8,1.7c-0.2,0.2-0.4,0.2-0.6,0l-4.5-4.5c-0.2-0.2-0.2-0.4,0-0.6l1.7-1.8
            								c1-1,1-2.6,0-3.6L8.2,3.6c-1-1-2.7-1-3.6,0l-2,2c-3.2,3.2-1.4,10.1,4.2,15.7c3.7,3.7,8,5.8,11.4,5.8c1.7,0,3.2-0.5,4.3-1.6l2-2
            								c0.5-0.5,0.8-1.1,0.8-1.8c0-0.7-0.3-1.3-0.8-1.8L20.7,16.1z M22.9,21.9l-2,2c-2.3,2.3-8.1,0.4-12.6-4.2C3.7,15.2,1.8,9.4,4.1,7.1
            								l2-2C6.2,5,6.3,5,6.4,5c0.1,0,0.2,0,0.3,0.1l3.7,3.7c0.2,0.2,0.2,0.4,0,0.6l-1.7,1.8c-1,1-1,2.6,0,3.6l4.5,4.5c1,1,2.6,1,3.6,0
            								l1.8-1.7c0.2-0.2,0.4-0.2,0.6,0l3.7,3.7c0.1,0.1,0.1,0.2,0.1,0.3C23,21.7,23,21.8,22.9,21.9z" style="fill: #283044;"></path>
            						</g>
        						</svg></a>';

    $article .= '<a href="javascript:void(0);"  class="vmg_get_price vmg_cmn_btn bfp_get_price" data-toggle="modal" data-target="#requestform" onclick="openGetYourPriceRequest(this)" data-product_title="' . $singleproduct->post_title . '" data-producturl="' . $b_url . '" id="' . $singleproduct->ID . '">Request Price <svg id="arrow--right" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                    <path id="Path_16735" data-name="Path 16735" d="M14.5,6,13.427,7.045l5.685,5.705H4v1.5H19.112l-5.685,5.68L14.5,21,22,13.5Z" transform="translate(-1 -1.5)" fill="#fff"></path>
                                    <rect id="_Transparent_Rectangle_" data-name="<Transparent Rectangle>" width="24" height="24" fill="none"></rect>
                                </svg></a>';
    $article .= '<a href="' . $b_url . '" class="vmg_view_dtl vmg_cmn_btn">
                                <svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none">
                                    <path d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z" fill="#283044"/>
                                </svg>
                            </a>';

    $article .= '</div>';

    $article .= '</div>';

    return $article;
}

// wp_register_script('buyfromphoto',get_template_directory_uri()."/assets/javascripts/buyfromphoto.js","jquery",THEME_VERSION,true);

//wp_enqueue_script('buyfromphoto');

add_action('wp_ajax_GetBuyFromPhotoAjax', 'GetBuyFromPhotoAjax');

add_action('wp_ajax_nopriv_GetBuyFromPhotoAjax', 'GetBuyFromPhotoAjax');

function GetBuyFromPhotoAjax()

{

    $cateid         = $_REQUEST['cateid'];

    $pagenumber     = $_REQUEST['pagenumber'];

    $post_per_page  = $_REQUEST['post_per_page'];



    if ($cateid == 'all') {

        $cateid = '';
    }

    $article = '';
    $evenarticles = '';
    $oddarticles = '';

    $animation = array('fadeInRight', 'fadeInLeft');

    $result = GetBFP($post_per_page, $pagenumber, $cateid, $dealer);

    if (count($result['products']) > 0) {

        $loop = 1;

        foreach ($result['products'] as $singleproduct) {

            $rem = $loop % 2;

            if ($rem == 1) {

                $article .= '<aside class="vmg_explore_main">';
            }

            $article .= GetBuyFromPhotoHtml($singleproduct);

            if ($rem == 0) {

                $article .= '</aside>';
            }

            $loop++;
        }
    }

    $return['TotalPosts'] = $result['totalpost'];

    $return['MaxPage'] = $result['totalpages'];

    $return['PostsData'] = $article;

    $return['IsLast'] = $result['islast'];

    echo json_encode($return);

    die();
}

add_action('wp_ajax_GetBuyFromPhotoAjaxManufacture', 'GetBuyFromPhotoAjaxManufacture');

add_action('wp_ajax_nopriv_GetBuyFromPhotoAjaxManufacture', 'GetBuyFromPhotoAjaxManufacture');

function GetBuyFromPhotoAjaxManufacture()

{

    $cateid         = $_REQUEST['cateid'];

    // $cateid =''

    $pagenumber     = $_REQUEST['pagenumber'];

    $post_per_page  = $_REQUEST['post_per_page'];



    if ($cateid == 'all') {

        $cateid = '';
    }

    $article = '';
    $evenarticles = '';
    $oddarticles = '';

    $animation = array('fadeInRight', 'fadeInLeft');

    $result = GetBFPManufacture($post_per_page, $pagenumber, $cateid, $dealer);

    // Initialize an array to store processed product IDs
    if (count($result['products']) > 0) {

        $loop = 1;

        foreach ($result['products'] as $singleproduct) {

            $rem = $loop % 2;

            if ($rem == 1) {

                $article .= '<aside class="vmg_explore_main">';
            }

            $article .= GetBuyFromPhotoHtml($singleproduct);

            if ($rem == 0) {

                $article .= '</aside>';
            }


            $loop++;
        }
    }

    $return['TotalPosts'] = $result['totalpost'];

    $return['MaxPage'] = $result['totalpages'];

    $return['PostsData'] = $article;

    $return['IsLast'] = $result['islast'];

    echo json_encode($return);

    die();
}

add_action('wp_ajax_GetCategoryDescriptionAjax', 'GetCategoryDescriptionAjax');

add_action('wp_ajax_nopriv_GetCategoryDescriptionAjax', 'GetCategoryDescriptionAjax');



function GetCategoryDescriptionAjax()

{

    $cateid         = $_REQUEST['cateid'];

    $pagenumber     = $_REQUEST['pagenumber'];

    $post_per_page  = $_REQUEST['post_per_page'];



    if ($cateid == 'all') {

        $cateid = '';
    }

    $article = '';
    $evenarticles = '';
    $oddarticles = '';

    $animation = array('fadeInRight', 'fadeInLeft');

    $result = GetBFP($post_per_page, $pagenumber, $cateid, $dealer);

    $article .= '<div class="tab-pane fade show active " id="" role="tabpanel" aria-labelledby="' . $cateid . '">';



    $article .= '<div class="row item-list-con" id="photolist-' . $cateid . '">';

    $article .= '<div id="bfp_cate_' . $cateid . '">';

    $article .= '<div class="bfp_product_list_con">';

    if (count($result['products']) > 0) {



        $loop = 1;

        foreach ($result['products'] as $singleproduct) {

            $rem = $loop % 2;

            if ($rem == 1) {

                $article .= '<aside class="row">';
            }

            $article .= GetBuyFromPhotoHtml($singleproduct);

            if ($rem == 0) {

                $article .= '</aside>';
            }

            $loop++;
        }
    }

    $article .= '</div>';

    $article .= '<div class="nosearchresult"></div>';

    if ($result['totalpages'] > 1) {

        $article .= '<div id="pagination_row" class="row button-row">';

        $article .= '<div class="loadmore-btncon">';

        $article .= '<div class="col-sm-12 col-sm-offset-1 text-center">';

        $article .= '<div class="borderbtn">';

        $article .= '<span id="cpage_' . $cateid . '" class="firstcategory">2</span>';

        $article .= '<button id="bfpl_' . $cateid . '" class="loadmore loadmore-style loadmore-bfp" data-termid="' . $cateid . '">load more</button>';

        $article .= '</div>';

        $article .= '</div>';

        $article .= '</div>';

        $article .= '</div>';
    }

    $article .= '</div>';



    $return['TotalPosts'] = $result['totalpost'];

    $return['MaxPage'] = $result['totalpages'];

    $return['PostsData'] = $article;

    $return['IsLast'] = $result['islast'];

    echo json_encode($return);

    die();
}

add_action('wp_ajax_GetBuyFromPhotoAjaxNew', 'GetBuyFromPhotoAjaxNew');
add_action('wp_ajax_nopriv_GetBuyFromPhotoAjaxNew', 'GetBuyFromPhotoAjaxNew');

function GetBuyFromPhotoAjaxNew()
{
    global $wpdb;
    $cateid         = $_REQUEST['cateid'];
    $pagenumber     = $_REQUEST['pagenumber'];
    $post_per_page  = $_REQUEST['post_per_page'];

    function exclude_barn_finance($where)
    {
        global $wpdb;
        $where .= " AND {$wpdb->posts}.post_title NOT LIKE '%barn%'";
        return $where;
    }
    add_filter('posts_where', 'exclude_barn_finance');
    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => $post_per_page,
        'post_status'    => 'publish',
        'paged'          => $pagenumber,
        'orderby'        => 'ID',
        'order'          => 'DESC',
    );
    $query = new WP_Query($args);
    remove_filter('posts_where', 'exclude_barn_finance');
    if ($query->have_posts()) {
        $loop = 1;
        foreach ($query->posts as $singleproduct) {
            $article .= '<div class="vmg_building_bx">';
            $article .= GetBuyFromPhotoHtmlOther($singleproduct);
            $article .= '</div>';
            $loop++;
        }
    }

    $total_posts = $query->found_posts;
    $max_pages   = $query->max_num_pages;
    $return['TotalPosts'] = $total_posts;
    $return['MaxPage'] = $max_pages;
    $return['PostsData'] = $article;
    $return['IsLast'] = $max_pages <= $pagenumber;
    echo json_encode($return);
    die();
}

add_action('wp_ajax_GetBuyFromPhotoAjaxRTO', 'GetBuyFromPhotoAjaxRTO');
add_action('wp_ajax_nopriv_GetBuyFromPhotoAjaxRTO', 'GetBuyFromPhotoAjaxRTO');

function GetBuyFromPhotoAjaxRTO()
{
    global $wpdb;
    $cateid         = $_REQUEST['cateid'];
    $pagenumber     = $_REQUEST['pagenumber'];
    $post_per_page  = $_REQUEST['post_per_page'];

    function exclude_barn_products($where)
    {
        global $wpdb;
        $where .= " AND {$wpdb->posts}.post_title NOT LIKE '%barn%'";
        return $where;
    }
    add_filter('posts_where', 'exclude_barn_products');

    $args = array(
        'post_type'      => 'product',
        'posts_per_page' => $post_per_page,
        'post_status'    => 'publish',
        'paged'          => $pagenumber,
        'meta_query'     => array(
            array(
                'key'     => 'prices',
                'value'   => 10000,
                'type'    => 'NUMERIC',
                'compare' => '<',
            ),
        ),
        'orderby'        => 'ID',
        'order'          => 'DESC',
    );
    $query = new WP_Query($args);
    remove_filter('posts_where', 'exclude_barn_products');
    if ($query->have_posts()) {
        $loop = 1;
        foreach ($query->posts as $singleproduct) {
            $article .= '<div class="vmg_building_bx">';
            $article .= GetBuyFromPhotoHtmlOther($singleproduct);
            $article .= '</div>';
            $loop++;
        }
    }

    $total_posts = $query->found_posts;
    $max_pages   = $query->max_num_pages;
    $return['TotalPosts'] = $total_posts;
    $return['MaxPage'] = $max_pages;
    $return['PostsData'] = $article;
    $return['IsLast'] = $max_pages <= $pagenumber;
    echo json_encode($return);
    die();
}


/**

 * Add custom taxonomies

 *

 * Additional custom taxonomies can be defined here

 * http://codex.wordpress.org/Function_Reference/register_taxonomy

 */

function add_custom_taxonomies()
{



    echo "Rohit";
    exit;
}

add_action('product-taxonomy', 'add_custom_taxonomies', 0);



// A callback function to add a custom field to our "presenters" taxonomy

function product_taxonomy_custom_fields($tag)
{



    // Check for existing taxonomy meta for the term you're editing

    $t_id = $tag->term_id; // Get the ID of the term you're editing

    $term_meta = get_option("taxonomy_term_$t_id"); // Do the check



    $content = $term_meta['extra_dsec'];
    $why_choose_dsec = $term_meta['why_choose_dsec'];
    $explore_category_text = $term_meta['explore_category_text'];
    $footer_heading = $term_meta['footer_heading'];
    $footer_description = $term_meta['footer_description'];
    $faq_items = isset($term_meta['faq_items']) ? $term_meta['faq_items'] : array();
    $metal_roof_desc = $term_meta['metal_roof_desc'];
    $banner_image_url = isset($term_meta['banner_image_url']) ? esc_url($term_meta['banner_image_url']) : '';
    $buy_from_title = $term_meta['buy_from_title'];
    $buy_from_text = $term_meta['buy_from_text'];
    $call_us_text = $term_meta['call_us_text'];
    $faq_title = $term_meta['faq_title'];
    $faq_description = $term_meta['faq_description'];



?>

<table class="form-table" style="width: 216%;">

    <tbody>





        <tr class="form-field">

            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Banner Text'); ?></label></th>



            <td>

                <!-- <textarea  class="theEditor" name="custom_meta_box"></textarea>-->

                <input type="text" name="term_meta[banner_description]" id="term_meta[banner_description]" size="25"
                    style="width:60%;"
                    value="<?php echo !empty($term_meta['banner_description']) ? str_replace(array('/', '\\'), '', sanitize_text_field(wp_unslash($term_meta['banner_description']))) : ''; ?>"><br />



                <span class="description"><?php _e('Add Banner Text'); ?></span>

            </td>

        </tr>

        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Explore Category Text'); ?></label></th>
            <td>
                <input type="text" name="explore_category_text" id="explore_category_text" size="25" style="width:60%;"
                    value="<?php echo $explore_category_text ? $explore_category_text : ''; ?>"><br />
                <span class="description"><?php _e('Add Explore Category Text'); ?></span>
            </td>

        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Call Us Text'); ?></label></th>
            <td>
                <input type="text" name="call_us_text" id="call_us_text" size="25" style="width:60%;"
                    value="<?php echo $call_us_text ? $call_us_text : ''; ?>"><br />
                <span class="description"><?php _e('Add Call Us Text'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Buy From Title'); ?></label></th>
            <td>
                <input type="text" name="buy_from_title" id="buy_from_title" size="25" style="width:60%;"
                    value="<?php echo $buy_from_title ? $buy_from_title : ''; ?>"><br />
                <span class="description"><?php _e('Add Buy From Title'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Buy From Text'); ?></label></th>
            <td>
                <?php
                    $buy_from_content = html_entity_decode($buy_from_text);
                    $buy_from_content = stripslashes($buy_from_content);
                    wp_editor(wp_specialchars_decode($buy_from_content), 'buy_from_text', array("media_buttons" => true));
                    ?>
                <span class="description"><?php _e('Add Buy From Text'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Add Footer Heading'); ?></label></th>
            <td>
                <input type="text" name="footer_heading" id="footer_heading" size="25" style="width:60%;"
                    value="<?php echo $footer_heading ? $footer_heading : ''; ?>"><br />
                <span class="description"><?php _e('Add Footer Heading'); ?></span>
            </td>

        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Add Footer Description'); ?></label></th>
            <td>
                <input type="text" name="footer_description" id="footer_description" size="25" style="width:60%;"
                    value="<?php echo $footer_description ? $footer_description : ''; ?>"><br />
                <span class="description"><?php _e('Add Footer Description'); ?></span>
            </td>

        </tr>

        <tr class="form-field">

            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Add Frontend Description'); ?></label>
            </th>
            <td>
                <!-- <textarea  class="theEditor" name="custom_meta_box"></textarea>-->
                <?php

                    $default_content = html_entity_decode($content);

                    $default_content = stripslashes($default_content);

                    wp_editor(wp_specialchars_decode($default_content), 'extra_dsec', array("media_buttons" => true));

                    ?>
                <span class="description"><?php _e('Add Frontend Description'); ?></span>
            </td>
        </tr>
        <tr class="form-field">

            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Add Why Choose Description'); ?></label>
            </th>
            <td>
                <!-- <textarea  class="theEditor" name="custom_meta_box"></textarea>-->
                <?php

                    $why_choose_content = html_entity_decode($why_choose_dsec);

                    $why_choose_content = stripslashes($why_choose_content);

                    wp_editor(wp_specialchars_decode($why_choose_content), 'why_choose_dsec', array("media_buttons" => true));

                    ?>
                <span class="description"><?php _e('Add Why Choose Description'); ?></span>
            </td>
        </tr>

        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Metal Roof Description'); ?></label></th>
            <td>
                <?php
                    $metal_roof_content = html_entity_decode($metal_roof_desc);
                    $metal_roof_content = stripslashes($metal_roof_content);
                    wp_editor(wp_specialchars_decode($metal_roof_content), 'metal_roof_desc', array("media_buttons" => true));
                    ?>
                <span class="description"><?php _e('Add Metal Roof Description'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('FAQ Title'); ?></label></th>
            <td>
                <input type="text" name="faq_title" id="faq_title" size="25" style="width:60%;"
                    value="<?php echo $faq_title ? $faq_title : ''; ?>"><br />
                <span class="description"><?php _e('Add FAQ Title'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('FAQ Description'); ?></label></th>
            <td>
                <?php
                    $faq_description_content = html_entity_decode($faq_description);
                    $faq_description_content = stripslashes($faq_description_content);
                    wp_editor(wp_specialchars_decode($faq_description_content), 'faq_description', array("media_buttons" => true));
                    ?>
                <span class="description"><?php _e('Add FAQ Description'); ?></span>
            </td>
        </tr>

        <tr class="form-field">
            <th scope="row" valign="top">
                <label for="tag_Image_url"><?php _e('FAQs'); ?></label>
            </th>
            <td>
                <?php
                    foreach ($faq_items['question'] as $index => $question) {
                    ?>
                <div class="faq-item">
                    <input placeholder="<?php _e('Question'); ?>" type="text" name="term_meta[faq_items][question][]"
                        value="<?php echo esc_attr($question); ?>" />
                    <textarea name="term_meta[faq_items][answer][]"
                        placeholder="<?php _e('Answer'); ?>"><?php echo esc_textarea($faq_items['answer'][$index]); ?></textarea>
                </div>
                <?php } ?>

                <button class="add-faq-item button"><?php _e('Add FAQ Item'); ?></button>

                <script>
                jQuery(document).ready(function($) {
                    // Add FAQ Item
                    $('.add-faq-item').click(function(e) {
                        e.preventDefault(); // Prevent the default form submission behavior
                        var faqItem = '<div class="faq-item">' +
                            '<input placeholder="<?php _e('Question'); ?>" type="text" name="term_meta[faq_items][question][]" />' +
                            '<textarea name="term_meta[faq_items][answer][]" placeholder="<?php _e('Answer'); ?>"></textarea>' +
                            '</div>';

                        $(this).before(faqItem);
                    });
                });
                </script>

                <br><span class="description"><?php _e('Add FAQs'); ?></span>
            </td>
        </tr>
        <tr class="form-field">
            <th scope="row" valign="top"><label for="tag_Image_url"><?php _e('Banner Image'); ?></label></th>
            <td>
                <input type="text" name="term_meta[banner_image_url]" id="banner_image_url" size="25" style="width:60%;"
                    value="<?php echo $banner_image_url; ?>" />
                <input type="button" id="upload_banner_image_button" class="button"
                    value="<?php _e('Upload Image'); ?>" />
                <br />
                <span class="description"><?php _e('Add Banner Image URL'); ?></span>
            </td>
            <script>
            jQuery(document).ready(function($) {
                // Media Uploader
                var mediaUploader;

                $('#upload_banner_image_button').click(function(e) {
                    e.preventDefault();
                    // If the uploader object has already been created, reopen the dialog
                    if (mediaUploader) {
                        mediaUploader.open();
                        return;
                    }
                    // Create the media uploader
                    mediaUploader = wp.media.frames.file_frame = wp.media({
                        title: 'Choose Banner Image',
                        button: {
                            text: 'Choose Image'
                        },
                        multiple: false
                    });

                    // When a file is selected, grab the URL and set it as the text field's value
                    mediaUploader.on('select', function() {
                        var attachment = mediaUploader.state().get('selection').first()
                            .toJSON();
                        $('#banner_image_url').val(attachment.url);
                    });

                    // Open the uploader dialog
                    mediaUploader.open();
                });
            });
            </script>
        </tr>
    </tbody>

</table>

<?php

}



// Add the fields to the "presenters" taxonomy, using our callback function

add_action('product-taxonomy_edit_form_fields', 'product_taxonomy_custom_fields', 10, 2);

// A callback function to save our extra taxonomy field(s)

function save_taxonomy_custom_fields($term_id)
{
    $_POST['term_meta']['extra_dsec'] = htmlspecialchars($_POST['extra_dsec']);
    $_POST['term_meta']['why_choose_dsec'] = htmlspecialchars($_POST['why_choose_dsec']);
    $_POST['term_meta']['faq'] = htmlspecialchars($_POST['faq']);
    $_POST['term_meta']['explore_category_text'] = htmlspecialchars($_POST['explore_category_text']);
    $_POST['term_meta']['metal_roof_desc'] = htmlspecialchars($_POST['metal_roof_desc']);
    $_POST['term_meta']['footer_heading'] = htmlspecialchars($_POST['footer_heading']);
    $_POST['term_meta']['footer_description'] = htmlspecialchars($_POST['footer_description']);
    $_POST['term_meta']['buy_from_title'] = htmlspecialchars($_POST['buy_from_title']);
    $_POST['term_meta']['buy_from_text'] = htmlspecialchars($_POST['buy_from_text']);
    $_POST['term_meta']['call_us_text'] = htmlspecialchars($_POST['call_us_text']);
    $_POST['term_meta']['faq_title'] = htmlspecialchars($_POST['faq_title']);
    $_POST['term_meta']['faq_description'] = htmlspecialchars($_POST['faq_description']);


    if (isset($_POST['term_meta'])) {
        $t_id = $term_id;
        $term_meta = get_option("taxonomy_term_$t_id");
        $cat_keys = array_keys($_POST['term_meta']);
        foreach ($cat_keys as $key) {
            if (isset($_POST['term_meta'][$key])) {
                $term_meta[$key] = $_POST['term_meta'][$key];
            }
        }
        //save the option array
        update_option("taxonomy_term_$t_id", $term_meta);
    }

    if (isset($_POST['term_meta']['faq_items']) && !empty($_POST['term_meta']['faq_items'])) {
        $faq_items = array(
            'question' => array_map('sanitize_text_field', $_POST['term_meta']['faq_items']['question']),
            'answer'   => $_POST['term_meta']['faq_items']['answer'], // Do not sanitize to allow HTML tags
        );

        update_option("taxonomy_term_$term_id", array_merge(get_option("taxonomy_term_$term_id", array()), array('faq_items' => $faq_items)));
    }
}

// Save the changes made on the "presenters" taxonomy, using our callback function

add_action('edited_product-taxonomy', 'save_taxonomy_custom_fields', 10, 2);



remove_filter('template_redirect', 'redirect_canonical');

/**

 * Remove the slug from published post permalinks. Only affect our CPT though.

 */

function remove_product_slug($post_link, $post, $leavename)
{
    if ('product' != $post->post_type || 'publish' != $post->post_status) {
        return $post_link;
    }

    $post_link = str_replace('/product/', '/', $post_link);

    return $post_link;
}
add_filter('post_type_link', 'remove_product_slug', 10, 3);


function add_product_rewrite_rules($wp_rewrite)
{
    $rules = array();
    $post_type = 'product';

    $query_args = array(
        'post_type'      => $post_type,
        'post_status'    => 'publish',
        'posts_per_page' => -1
    );

    $posts = get_posts($query_args);

    foreach ($posts as $post) {
        $rules[$post->post_name . '/?$'] = 'index.php?post_type=' . $post_type . '&p=' . $post->ID;
    }

    $wp_rewrite->rules = $rules + $wp_rewrite->rules;
}
add_action('generate_rewrite_rules', 'add_product_rewrite_rules');



add_action('wp_enqueue_scripts', 'load_old_jquery', 100);

function load_old_jquery()
{

    if (! is_admin()) {

        wp_deregister_script('jquery');

        wp_register_script('jquery', ("//ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"), false, '1.11.3');

        wp_enqueue_script('jquery');
    }
}


add_action("wpcf7_before_send_mail", "zoholeads");


function zoholeads($WPCF7_ContactForm)
{

    global $post;

    $submission = WPCF7_Submission::get_instance();

    if ($submission) {

        $posted_data = $submission->get_posted_data();
    }



    // $postedformid = $posted_data[_wpcf7];

    $postedformid = $WPCF7_ContactForm->id();



    $ipaddress = $_SERVER['REMOTE_ADDR'];

    $country = strtolower(get_ip_location($ipaddress, $posted_data));

    $disallow_country = array("in", "bd", "np", "pk");





    if ($ipaddress == '183.182.86.178' || !in_array($country, $disallow_country)) {



        if ($postedformid == '949') {

            $username = $lname = $email = $phone = $mobile = $city = $zipcode = $description = $product_title = $product_link = $state = $address = $notes = '';

            if (!empty($posted_data['username'])) {

                $username = $posted_data['username'];
            }

            if (!empty($posted_data['useremail'])) {

                $email = $posted_data['useremail'];
            }

            if (!empty($posted_data['State'])) {

                $state = implode(',', $posted_data['State']);
            }

            if (!empty($posted_data['usercity'])) {

                $city = $posted_data['usercity'];
            }



            if (!empty($posted_data['userphone'])) {

                $phone = $posted_data['userphone'];
            }



            if (!empty($posted_data['usermobile'])) {

                $mobile = $posted_data['usermobile'];
            }



            if (!empty($posted_data['useraddress'])) {

                $address = $posted_data['useraddress'];
            }



            if (!empty($posted_data['userzipcode'])) {

                $zipcode = $posted_data['userzipcode'];
            }



            if (!empty($posted_data['notes'])) {

                $notes = $posted_data['notes'];
            }



            if (!empty($posted_data['product_title'])) {

                $product_title = $posted_data['product_title'];
            }



            if (!empty($posted_data['product_url'])) {

                $product_url = $posted_data['product_url'];
            }

            if (!empty($posted_data['usercity'])) {

                $city = $posted_data['usercity'];
            }



            $jsondata = array(

                'data' =>

                array(

                    0 =>

                    array(

                        'First_Name' => $username,

                        'Last_Name' => 'N/A',

                        'Email' => $email,

                        'Phone' => $phone,

                        'Phone' => $mobile,

                        'State' => $state,

                        'Description' => $notes,

                        'Product_Title' => $product_title,

                        'Product_Link' => $product_url,

                        'Leads_Owner' => 'Alberto Ochoa',

                        'Lead_Source' => 'Viking Metal Garages Website',

                        'Street'      => $address,

                        'City'        => $city,

                        'Zip_Code'    => $zipcode,

                        'Lead_Status' => 'New Lead',

                        'Website_Source_Form1' => 'VMG Request Price Form',

                    ),
                ),

                'triggger' =>  array('workflow', 'approval', 'blueprint')
            );



            $xml = '<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['username'])) {

        $xml .= '<FL val="First Name">' . $posted_data['username'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['useremail'])) {

        $xml .= '<FL val="Email">' . $posted_data['useremail'] . '</FL>';
        }

        if (!empty($posted_data['State'])) {

        $xml .= '<FL val="State">' . implode(',', $posted_data['State']) . '</FL>';
        }

        if (!empty($posted_data['usercity'])) {

        $xml .= '<FL val="City">' . $posted_data['usercity'] . '</FL>';
        }

        if (!empty($posted_data['userphone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['userphone'] . '</FL>';
        }

        if (!empty($posted_data['usermobile'])) {

        $xml .= '<FL val="Phone">' . $posted_data['usermobile'] . '</FL>';
        }



        if (!empty($posted_data['useraddress'])) {

        $xml .= '<FL val="Street">' . $posted_data['useraddress'] . '</FL>';
        }

        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Description">' . $posted_data['notes'] . '</FL>';
        }

        if (!empty($posted_data['product_title'])) {

        $xml .= '<FL val="Product Title">' . $posted_data['product_title'] . '</FL>';
        }

        if (!empty($posted_data['product_url'])) {

        $xml .= '<FL val="Product Link">' . $posted_data['product_url'] . '</FL>';
        }



        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Request Price Form</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '950') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Description' => $posted_data['your-subject'],

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Website_Source_Form1' => 'VMG Contact Us Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);

$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['your-subject'])) {

        $xml .= '<FL val="Description">' . $posted_data['your-subject'] . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Contact Us Form</FL>';

        $xml .= '</row>
</Leads>';

//echo $xml; echo "<br>";

}

if ($postedformid == '951') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Phone' => $posted_data['phone'],

'Building_Type' => implode(',', $posted_data['Building']),

'Description' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG Garage Sizes Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['phone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['phone'] . '</FL>';
        }

        if (!empty($posted_data['Building'])) {

        $xml .= '<FL val="Building Type">' . implode(',', $posted_data['Building']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }



        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Garage Sizes Form</FL>';

        $xml .= '</row>
</Leads>';
}



if ($postedformid == '952') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Phone' => $posted_data['your-number'],

'Message' => $posted_data['message'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['zip-code'],

'Website_Source_Form1' => 'VMG Manufacturer Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['your-number'])) {

        $xml .= '<FL val="Phone">' . $posted_data['your-number'] . '</FL>';
        }



        if (!empty($posted_data['message'])) {

        $xml .= '<FL val="Message">' . $posted_data['message'] . '</FL>';
        }



        if (!empty($posted_data['zip-code'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['zip-code'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Manufacturer Form</FL>';

        $xml .= '</row>
</Leads>';
}



if ($postedformid == '955') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Phone' => $posted_data['phone'],

'Building_Type' => implode(',', $posted_data['Building']),

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG Metal Garage Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);

$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['phone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['your-phone'] . '</FL>';
        }

        if (!empty($posted_data['Building'])) {

        $xml .= '<FL val="Building Type">' . implode(',', $posted_data['Building']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }

        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }



        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Metal Garage Form</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '956') {



$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Phone' => $posted_data['your-phone'],

'Building_Type' => implode(',', $posted_data['Building']),

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'Metal Garages Types',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['phone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['phone'] . '</FL>';
        }

        if (!empty($posted_data['Building'])) {

        $xml .= '<FL val="Building Type">' . implode(',', $posted_data['Building']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }



        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">Metal Garages Types</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '957') {



$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['your-name'],

'Last_Name' => 'N/A',

'Email' => $posted_data['your-email'],

'Phone' => $posted_data['your-phone'],

'Building_Type' => implode(',', $posted_data['Building']),

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG Parking Garages Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['your-name'])) {

        $xml .= '<FL val="First Name">' . $posted_data['your-name'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['your-email'])) {

        $xml .= '<FL val="Email">' . $posted_data['your-email'] . '</FL>';
        }

        if (!empty($posted_data['phone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['phone'] . '</FL>';
        }

        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        if (!empty($posted_data['Building'])) {

        $xml .= '<FL val="Building Type">' . implode(',', $posted_data['Building']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }





        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Parking Garages Form</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '48131') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['username'],

'Last_Name' => 'N/A',

'Email' => $posted_data['useremail'],

'Phone' => $posted_data['userphone'],

'State' => implode(',', $posted_data['State']),

'Dimensions' => $posted_data['usercity'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Offer Popup',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG Offer Popup Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);


$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['username'])) {

        $xml .= '<FL val="First Name">' . $posted_data['username'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['useremail'])) {

        $xml .= '<FL val="Email">' . $posted_data['useremail'] . '</FL>';
        }

        if (!empty($posted_data['userphone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['userphone'] . '</FL>';
        }

        if (!empty($posted_data['State'])) {

        $xml .= '<FL val="State">' . implode(',', $posted_data['State']) . '</FL>';
        }

        if (!empty($posted_data['usercity'])) {

        $xml .= '<FL val="Dimensions">' . $posted_data['usercity'] . '</FL>';
        }

        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG RTO Form</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '953') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['username'],

'Last_Name' => 'N/A',

'Email' => $posted_data['useremail'],

'Phone' => $posted_data['userphone'],

'State' => implode(',', $posted_data['State']),

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG RTO Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['username'])) {

        $xml .= '<FL val="First Name">' . $posted_data['username'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['useremail'])) {

        $xml .= '<FL val="Email">' . $posted_data['useremail'] . '</FL>';
        }

        if (!empty($posted_data['userphone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['userphone'] . '</FL>';
        }

        if (!empty($posted_data['State'])) {

        $xml .= '<FL val="State">' . implode(',', $posted_data['State']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }



        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG RTO Form</FL>';

        $xml .= '</row>
</Leads>';
}

if ($postedformid == '954') {

$jsondata = array(

'data' =>

array(

0 =>

array(

'First_Name' => $posted_data['username'],

'Last_Name' => 'N/A',

'Email' => $posted_data['useremail'],

'Phone' => $posted_data['userphone'],

'State' => implode(',', $posted_data['State']),

'Message' => $posted_data['notes'],

'Leads_Owner' => 'Alberto Ochoa',

'Lead_Status' => 'New Lead',

'Lead_Source' => 'Viking Metal Garages Website',

'Zip_Code' => $posted_data['userzipcode'],

'Website_Source_Form1' => 'VMG Finance Form',

),
),

'triggger' => array('workflow', 'approval', 'blueprint')
);



$xml = '
<?xml version="1.0" encoding="UTF-8"?>';

$xml .= '<Leads>
    <row no="1">';

        if (!empty($posted_data['username'])) {

        $xml .= '<FL val="First Name">' . $posted_data['username'] . '</FL>';
        }

        $xml .= '<FL val="Last Name">N/A</FL>';

        if (!empty($posted_data['useremail'])) {

        $xml .= '<FL val="Email">' . $posted_data['useremail'] . '</FL>';
        }

        if (!empty($posted_data['userphone'])) {

        $xml .= '<FL val="Phone">' . $posted_data['userphone'] . '</FL>';
        }

        if (!empty($posted_data['State'])) {

        $xml .= '<FL val="State">' . implode(',', $posted_data['State']) . '</FL>';
        }

        if (!empty($posted_data['notes'])) {

        $xml .= '<FL val="Message">' . $posted_data['notes'] . '</FL>';
        }



        if (!empty($posted_data['userzipcode'])) {

        $xml .= '<FL val="Zip Code">' . $posted_data['userzipcode'] . '</FL>';
        }

        $xml .= '<FL val="Leads Owner">Alberto Ochoa</FL>';

        $xml .= '<FL val="Lead Source">Viking Metal Garages Website</FL>';

        $xml .= '<FL val="Web Form">VMG Finance Form</FL>';

        $xml .= '</row>
</Leads>';
}



if (
$postedformid == '949' || $postedformid == '950' || $postedformid == '951' || $postedformid == '955' ||
$postedformid == '956' || $postedformid == '957' || $postedformid == '953' || $postedformid == '954' || $postedformid ==
'952' || $postedformid == '48131'
) {

$fields = json_encode($jsondata);

/* echo '
<pre>';

            print_r($fields);

            echo '</pre>';*/



$accessTokenData = array(

'refresh_token' => '1000.b12728aa55c88af04c9782cdf0f90a79.c81f0967bf8fcb038663a9de8be3c483',

'client_id' => '1000.6EYL4CQX6UE5JR2IQ7SJP23J278JEH',

'client_secret' => '63d7823035d27eecb75adc9839ddc8481331d07e7d',

'grant_type' => 'refresh_token'

);



$access_token_url = 'https://accounts.zoho.com/oauth/v2/token';

$curlPost = curl_init();

curl_setopt($curlPost, CURLOPT_URL, $access_token_url);

curl_setopt($curlPost, CURLOPT_POST, 0);

curl_setopt($curlPost, CURLOPT_RETURNTRANSFER, true);

curl_setopt($curlPost, CURLOPT_TIMEOUT, 30);

curl_setopt($curlPost, CURLOPT_SSL_VERIFYPEER, false);

curl_setopt($curlPost, CURLOPT_SSL_VERIFYHOST, false);

curl_setopt($curlPost, CURLOPT_POSTFIELDS, $accessTokenData);

$access_token_result = curl_exec($curlPost);

$access_token_post = json_decode($access_token_result);

$access_token = $access_token_post->access_token;

//------ End Refresh Access Token==================//





$url = 'https://www.zohoapis.com/crm/v2/Leads';

$key = 'Zoho-oauthtoken ' . $access_token;

$header = array("Content-Type: application/json", "Content-Length: " . strlen($fields), "Authorization: " . $key);

$curl = curl_init();

curl_setopt($curl, CURLOPT_URL, $url);

curl_setopt($curl, CURLOPT_HTTPHEADER, $header);

curl_setopt($curl, CURLOPT_POST, 0);

curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

curl_setopt($curl, CURLOPT_TIMEOUT, 30);

curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);

$result = curl_exec($curl);

$zohotxt = fopen("zohojson.txt", "a");

fwrite($zohotxt, print_r($result, true) . " , CF7 form id : " . $postedformid . ' , ' . $fields . PHP_EOL);

fclose($zohotxt);

curl_close($curl);
} else {

$url = "https://crm.zoho.com/crm/private/xml/Leads/insertRecords";

$query = "authtoken=224e4627463acc007cacc5801aa52734&scope=crmapi&newFormat=1&xmlData=" . $xml;

if (!empty($url)) {

$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $url);

curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

curl_setopt($ch, CURLOPT_TIMEOUT, 30);

curl_setopt($ch, CURLOPT_POST, 1);

curl_setopt($ch, CURLOPT_POSTFIELDS, $query); // Set the request as a POST FIELD for curl.

$response = curl_exec($ch);



$zohotxt = fopen("zoho.txt", "a");

fwrite($zohotxt, print_r($response, true) . " , CF7 form id : " . $postedformid . ' , ' . $query . PHP_EOL);

fclose($zohotxt);



curl_close($ch);
}
}
} else {

$WPCF7_ContactForm->skip_mail = true;
}
}

function get_ip_location($ipaddress, $posted_data)

{

$url = 'https://freegeoip.net/json/' . $ipaddress;

$data = file_get_contents($url);

$data = json_decode($data);

// $cf7txt = fopen("cf7.txt","a");

// fwrite($cf7txt, $url." , ".print_r($data,true). " \n user data : ".print_r($posted_data,true)." , \n");

// fclose($cf7txt);

return $data->country_code;
}

function wpse_101072_flatten_hierarchies($post_link, $post)
{

if ('page' != $post->post_type)

return $post_link;



$uri = '';

foreach ($post->ancestors as $parent) {

$uri = get_post($parent)->post_name . "/" . $uri;
}



return str_replace($uri, '', $post_link);
}

add_filter('post_type_link', 'wpse_101072_flatten_hierarchies', 10, 2);



add_action('wp_ajax_filter_products', 'filter_products');
add_action('wp_ajax_nopriv_filter_products', 'filter_products');

function filter_products()
{
global $wpdb;

$selected_width = $_POST['selectedWidth'];
$selected_length = $_POST['selectedLength'];
$selected_height = $_POST['selectedheight'];
$selected_roof = $_POST['selectedroof'];
$currentUrl = $_POST['currentUrl'];
$path = parse_url($currentUrl, PHP_URL_PATH); // Extract the path from the URL
$segments = explode('/', rtrim($path, '/')); // Split the path into segments
$category_slug = end($segments); // Get the last segment

// Check if all parameters are provided
if (empty($selected_width) && empty($selected_length) && empty($selected_height) && empty($selected_roof)) {
// Query to retrieve products by category slug
$query = $wpdb->prepare("
SELECT p.*
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
INNER JOIN {$wpdb->term_taxonomy} AS tt
ON tr.term_taxonomy_id = tt.term_taxonomy_id
INNER JOIN {$wpdb->terms} AS t
ON tt.term_id = t.term_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND tt.taxonomy = 'product-taxonomy'
AND t.slug = %s
ORDER BY p.post_date DESC
", $category_slug);
} elseif (!empty($selected_width) && !empty($selected_length) && !empty($selected_height) && !empty($selected_roof)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_length
ON p.ID = pm_length.post_id
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_length.meta_key = 'length'
AND pm_length.meta_value = %s
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_length, $selected_height, $selected_roof, $category_slug);
} elseif (!empty($selected_width) && !empty($selected_length) && !empty($selected_height)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_length
ON p.ID = pm_length.post_id
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_length.meta_key = 'length'
AND pm_length.meta_value = %s
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_length, $selected_height, $category_slug);
} elseif (!empty($selected_width) && !empty($selected_height) && !empty($selected_roof)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_height, $selected_roof, $category_slug);
} elseif (!empty($selected_length) && !empty($selected_height)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_length
ON p.ID = pm_length.post_id
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_length.meta_key = 'length'
AND pm_length.meta_value = %s
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_length, $selected_height, $category_slug);
} elseif (!empty($selected_width) && !empty($selected_length)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_length
ON p.ID = pm_length.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_length.meta_key = 'length'
AND pm_length.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_length, $category_slug);
} elseif (!empty($selected_width) && !empty($selected_height)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_height, $category_slug);
} elseif (!empty($selected_width) && !empty($selected_roof)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_width
ON p.ID = pm_width.post_id
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_width.meta_key = 'width'
AND pm_width.meta_value = %s
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $selected_roof, $category_slug);
} elseif (!empty($selected_length) && !empty($selected_roof)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_length
ON p.ID = pm_length.post_id
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_length.meta_key = 'length'
AND pm_length.meta_value = %s
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_length, $selected_roof, $category_slug);
} elseif (!empty($selected_height) && !empty($selected_roof)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_height
ON p.ID = pm_height.post_id
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_height.meta_key = 'height'
AND pm_height.meta_value = %s
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_height, $selected_roof, $category_slug);
} elseif (!empty($selected_length)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm
ON p.ID = pm.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm.meta_key = 'length'
AND pm.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_length, $category_slug);
} elseif (!empty($selected_height)) {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm
ON p.ID = pm.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm.meta_key = 'height'
AND pm.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_height, $category_slug);
} elseif (!empty($selected_width)) {
// Old query without length condition
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm
ON p.ID = pm.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm.meta_key = 'width'
AND pm.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_width, $category_slug);
} else {
$query = $wpdb->prepare("
SELECT *
FROM {$wpdb->posts} AS p
INNER JOIN {$wpdb->postmeta} AS pm_roof
ON p.ID = pm_roof.post_id
INNER JOIN {$wpdb->term_relationships} AS tr
ON p.ID = tr.object_id
WHERE p.post_type = 'product'
AND p.post_status = 'publish'
AND pm_roof.meta_key = 'roof_style'
AND pm_roof.meta_value = %s
AND tr.term_taxonomy_id IN (
SELECT t.term_id
FROM {$wpdb->terms} AS t
INNER JOIN {$wpdb->term_taxonomy} AS tt ON t.term_id = tt.term_id
WHERE tt.taxonomy = 'product-taxonomy' AND t.slug = %s
)
", $selected_roof, $category_slug);
}

$products = $wpdb->get_results($query);

?>

<div class=" vmg_product_div" id="photolist-<?php echo $term ?>">
    <div class="vmg_product_tag">
        <ul>
            <?php if (!empty($selected_width)) { ?>
            <li id="filter-width">
                <?php echo  $selected_width; ?> Width
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                    data-filter-type="width" id="cancel-width">
                    <g id="Close-2" transform="translate(-1070 -1739)">
                        <rect id="Rectangle_1592" data-name="Rectangle 1592" width="16" height="16"
                            transform="translate(1070 1739)" fill="none" />
                        <path id="x-bold"
                            d="M55.716,54.494A.858.858,0,1,1,54.5,55.708l-4.533-4.534-4.534,4.533a.858.858,0,0,1-1.214-1.214l4.534-4.533-4.533-4.534a.858.858,0,0,1,1.214-1.214l4.533,4.534L54.5,44.211a.858.858,0,1,1,1.214,1.214L51.183,49.96Z"
                            transform="translate(1028.031 1697.041)" />
                    </g>
                </svg>
            </li>
            <?php }
                if (!empty($selected_length)) { ?>
            <li id="filter-length">
                <?php echo  $selected_length; ?> Length
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" id="cancel-length"
                    data-filter-type="length">
                    <g id="Close-2" transform="translate(-1070 -1739)">
                        <rect id="Rectangle_1592" data-name="Rectangle 1592" width="16" height="16"
                            transform="translate(1070 1739)" fill="none" />
                        <path id="x-bold"
                            d="M55.716,54.494A.858.858,0,1,1,54.5,55.708l-4.533-4.534-4.534,4.533a.858.858,0,0,1-1.214-1.214l4.534-4.533-4.533-4.534a.858.858,0,0,1,1.214-1.214l4.533,4.534L54.5,44.211a.858.858,0,1,1,1.214,1.214L51.183,49.96Z"
                            transform="translate(1028.031 1697.041)" />
                    </g>
                </svg>
            </li>
            <?php }
                if (!empty($selected_height)) { ?>
            <li id="filter-height">
                <?php echo  $selected_height; ?> Height
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                    data-filter-type="height" id="cancel-height">
                    <g id="Close-2" transform="translate(-1070 -1739)">
                        <rect id="Rectangle_1592" data-name="Rectangle 1592" width="16" height="16"
                            transform="translate(1070 1739)" fill="none" />
                        <path id="x-bold"
                            d="M55.716,54.494A.858.858,0,1,1,54.5,55.708l-4.533-4.534-4.534,4.533a.858.858,0,0,1-1.214-1.214l4.534-4.533-4.533-4.534a.858.858,0,0,1,1.214-1.214l4.533,4.534L54.5,44.211a.858.858,0,1,1,1.214,1.214L51.183,49.96Z"
                            transform="translate(1028.031 1697.041)" />
                    </g>
                </svg>
            </li>
            <?php }
                if (!empty($selected_roof)) { ?>
            <li id="filter-roof">
                <?php echo  $selected_roof; ?>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"
                    data-filter-type="roof" id="cancel-roof">
                    <g id="Close-2" transform="translate(-1070 -1739)">
                        <rect id="Rectangle_1592" data-name="Rectangle 1592" width="16" height="16"
                            transform="translate(1070 1739)" fill="none" />
                        <path id="x-bold"
                            d="M55.716,54.494A.858.858,0,1,1,54.5,55.708l-4.533-4.534-4.534,4.533a.858.858,0,0,1-1.214-1.214l4.534-4.533-4.533-4.534a.858.858,0,0,1,1.214-1.214l4.533,4.534L54.5,44.211a.858.858,0,1,1,1.214,1.214L51.183,49.96Z"
                            transform="translate(1028.031 1697.041)" />
                    </g>
                </svg>
            </li>
            <?php }  ?>
        </ul>
    </div>

    <div class="vmg_explore_main">
        <?php
            if (!empty($products)) {

                foreach ($products as $singleproduct) {
                    $img = wp_get_attachment_image_src(get_post_thumbnail_id($singleproduct->ID), 'medium_large');
                    $b_url = get_permalink($singleproduct->ID);
                    //  $b_url = rtrim($b_url, '/');
                    $excerpt = $singleproduct->post_excerpt;
                    $excerpt = substr($excerpt, 0, 250);
                    $excerptshort = substr($excerpt, 0, strrpos($excerpt, ' '));
                    $price = get_post_meta($singleproduct->ID, 'prices', true);
                    // echo GetBuyFromPhotoHtml($singleproduct);
            ?>

        <div class="vmg_building_bx" id="product-id-<?php echo $singleproduct->ID; ?>">
            <div class="vmg_card_bximg">
                <a href="<?php echo $b_url; ?>"><img src="<?php echo $img[0]; ?>" alt="" class="img-fluid"></a>
                <div class="product_hover">
                    <p class=""><?php echo $excerpt; ?></p>
                    <a href="<?php echo $b_url; ?>" class="btn btn-white-outline">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none">
                            <path
                                d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z"
                                fill="#fff"></path>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="vmg_building_info">
                <h3><a href="<?php echo $b_url; ?>"><?php echo $singleproduct->post_title; ?></a></h3>
                <p class="vmg_building_price">Starting from: <span><?php echo number_format($price); ?></span></p>
                <div class="vmg_building_action">
                    <a href="tel:+1(704)-741-1587" class="vmg_view_call vmg_cmn_btn">
                        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg"
                            xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 28 28"
                            style="enable-background:new 0 0 28 28;" xml:space="preserve">
                            <g>
                                <polygon class="st0"
                                    points="19.4,1 19.4,3.2 23.3,3.2 16.5,10 18,11.5 24.8,4.7 24.8,8.6 27,8.6 27,1"
                                    style="fill: #283044;"></polygon>
                                <path class="st0" d="M20.7,16.1c-1-1-2.6-1-3.6,0l-1.8,1.7c-0.2,0.2-0.4,0.2-0.6,0l-4.5-4.5c-0.2-0.2-0.2-0.4,0-0.6l1.7-1.8
         c1-1,1-2.6,0-3.6L8.2,3.6c-1-1-2.7-1-3.6,0l-2,2c-3.2,3.2-1.4,10.1,4.2,15.7c3.7,3.7,8,5.8,11.4,5.8c1.7,0,3.2-0.5,4.3-1.6l2-2
         c0.5-0.5,0.8-1.1,0.8-1.8c0-0.7-0.3-1.3-0.8-1.8L20.7,16.1z M22.9,21.9l-2,2c-2.3,2.3-8.1,0.4-12.6-4.2C3.7,15.2,1.8,9.4,4.1,7.1
         l2-2C6.2,5,6.3,5,6.4,5c0.1,0,0.2,0,0.3,0.1l3.7,3.7c0.2,0.2,0.2,0.4,0,0.6l-1.7,1.8c-1,1-1,2.6,0,3.6l4.5,4.5c1,1,2.6,1,3.6,0
         l1.8-1.7c0.2-0.2,0.4-0.2,0.6,0l3.7,3.7c0.1,0.1,0.1,0.2,0.1,0.3C23,21.7,23,21.8,22.9,21.9z"
                                    style="fill: #283044;"></path>
                            </g>
                        </svg>
                    </a>
                    <a href="javascript:void(0);" class="vmg_get_price vmg_cmn_btn bfp_get_price" data-toggle="modal"
                        data-target="#requestform" onclick="openGetYourPriceRequest(this)"
                        data-product_title="'.$singleproduct->post_title.'" data-producturl="'.$b_url.'"
                        id="'.$singleproduct->ID.'">Request Price <svg id="arrow--right"
                            xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path id="Path_16735" data-name="Path 16735"
                                d="M14.5,6,13.427,7.045l5.685,5.705H4v1.5H19.112l-5.685,5.68L14.5,21,22,13.5Z"
                                transform="translate(-1 -1.5)" fill="#fff"></path>
                            <rect id="_Transparent_Rectangle_" data-name="<Transparent Rectangle>" width="24"
                                height="24" fill="none"></rect>
                        </svg></a>

                    <a href="<?php echo $b_url; ?>" class="vmg_view_dtl vmg_cmn_btn">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="18" viewBox="0 0 22 18" fill="none">
                            <path
                                d="M11.0003 0C16.3924 0 20.8784 3.87976 21.8189 9C20.8784 14.1202 16.3924 18 11.0003 18C5.60812 18 1.12215 14.1202 0.181641 9C1.12215 3.87976 5.60812 0 11.0003 0ZM11.0003 16C15.2359 16 18.8603 13.052 19.7777 9C18.8603 4.94803 15.2359 2 11.0003 2C6.7646 2 3.14022 4.94803 2.22278 9C3.14022 13.052 6.7646 16 11.0003 16ZM11.0003 13.5C8.51498 13.5 6.50026 11.4853 6.50026 9C6.50026 6.51472 8.51498 4.5 11.0003 4.5C13.4855 4.5 15.5003 6.51472 15.5003 9C15.5003 11.4853 13.4855 13.5 11.0003 13.5ZM11.0003 11.5C12.381 11.5 13.5003 10.3807 13.5003 9C13.5003 7.6193 12.381 6.5 11.0003 6.5C9.6196 6.5 8.50026 7.6193 8.50026 9C8.50026 10.3807 9.6196 11.5 11.0003 11.5Z"
                                fill="#283044"></path>
                        </svg>
                    </a>

                </div>

            </div>
        </div>

        <?php }
            } else {
                echo '<div class="no-products-found">No Match Found.</div>';
            } ?>

    </div>
</div>
<?php die();
}

add_action('wp_ajax_clear_product', 'clear_product');
add_action('wp_ajax_nopriv_clear_product', 'clear_product');

function clear_product()
{
    $currentUrl  = $_POST['currentUrl'];
    $path = parse_url($currentUrl, PHP_URL_PATH); // Extract the path from the URL
    $segments = explode('/', rtrim($path, '/')); // Split the path into segments
    $term = end($segments); // Get the last segment
?>
<div class=" vmg_product_div" id="photolist-<?php echo $term ?>">

    <?php

    echo '<div class="vmg_explore_main" id="bfp_cate_' . $term . '">';
    echo '<div class="bfp_product_list_con">';
    $bfp_products = GetBFPManufacture(10, 1, $term);

    if (count($bfp_products['products']) > 0) {
        $row = 1;
        foreach (array_chunk($bfp_products['products'], 2, true) as $chunk) {
            echo '<aside class="vmg_explore_main">';
            foreach ($chunk as $singleproduct) {
                echo GetBuyFromPhotoHtml($singleproduct);
            }
            echo '</aside>';
            $row++;
        }
    } else {
        // No products found for the current category, display all products
        $all_products = GetBFPManufacture(10, 1, '', '', 'ID', '');
        foreach (array_chunk($all_products['products'], 2, true) as $chunk) {
            echo '<aside class="vmg_explore_main">';
            foreach ($chunk as $singleproduct) {
                echo GetBuyFromPhotoHtml($singleproduct);
            }
            echo '</aside>';
        }

        // Set $bfp_products values for load more button condition
        $bfp_products['totalpages'] = $all_products['totalpages'];
        $bfp_products['totalpost'] = $all_products['totalpost'];
    }

    echo '</div>';
    echo '<div class="nosearchresult"></div>';
    if ($bfp_products['totalpages'] > 1) {
        echo '<aside id="pagination_row" class="col-md-12 text-center">';
        echo '<div class="loadmore-btncon">';
        echo '<div class="col-sm-12 col-sm-offset-1 text-center">';
        echo '<div class="borderbtn">';
        echo '<span id="cpage_' . $term . '" class="firstcategory" style="display:none;">2</span>';
        echo '<a id="bfpl_' . $term . '" class="btn btn-primary-outline loadmore loadmore-style loadmore-bfp-manufacture" data-termid="' . $term . '">load more</a>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
        echo '</aside>';
    }
    echo '</div>';
    die();
}

/**
 * Move pages with template "City State page" to draft status
 */
//  function move_pages_with_city_state_template_to_draft() {
//     // Get pages with template "City State page"
//     $city_state_pages = get_posts(array(
//         'post_type' => 'page',
//         'meta_key' => '_wp_page_template',
//         'meta_value' => 'city-state-pages.php', // Change this to the filename of your City State template
//         'posts_per_page' => -1,
//     ));

//     // Loop through found pages and update status to draft
//     foreach ($city_state_pages as $page) {
//         wp_update_post(array(
//             'ID' => $page->ID,
//             'post_status' => 'draft',
//         ));
//     }
// }

// // Hook the function to a WordPress action
// add_action('init', 'move_pages_with_city_state_template_to_draft');




// Redirect attachment page
function disable_attachment_pages()
{
     global $post, $wp_query;
    if (is_attachment()) {

        $post_url = get_permalink($post->ID);
        $slug = basename(parse_url($post_url, PHP_URL_PATH));
        // if ( !empty( $post->post_parent ) ) {
        //     wp_redirect( get_permalink( $post->post_parent ), 301 );
        //     exit;
        // } else
        if ($slug == '24x30x10-side-entry-garage') {
            wp_redirect(home_url('20x30x10-side-entry-garage'), 301);
            exit;
        } else {
            $wp_query->set_404();
            status_header(404);
            include(get_query_template('404'));
            exit;
        }
    }
    if ( $wp_query->is_tax() && $wp_query->is_feed() ) {

        $term = $wp_query->get_queried_object();

        wp_redirect( get_term_link( $term ), 301 );
        exit;
    }
}
add_action('template_redirect', 'disable_attachment_pages');

