$(document).ready(function() {
    autosize($("#id_user_notes"));
    lightcasePopup();
    $(document).on("click",".loadmore-bfp",function(){
        currentcategoryid = $(this).data('termid'); 
        pagenumber = $('#cpage_'+currentcategoryid).text(); 
        loadproducts('append',pagenumber,currentcategoryid);
    });

    firstcateid = $("#bfp_cate_dropdown .catetitle").data('firstcateid');
    selectedcateid(firstcateid);
    $("#bfp_dropdown_list li a").click(function(){
        cateid = $(this).parent().data('cateid');
        selectedcateid(cateid);
    });

    width = $(window).width();

   // if(width>767) 
   // {
    //    CloudZoom.quickStart();
    //}

    if (width>767)
    {
        VminSlides=1;
        VmaxSlides=3;
        VmoveSlides=1;
        VslideWidth=350;
        VslideMargin=30;
    }
    else
    {
        VminSlides=1;
        VmaxSlides=1;
        VmoveSlides=1;
        VslideWidth=0;
        VslideMargin=15;
    }

    if($('#relatedproduct').length>0)
    {
        $('#relatedproduct').bxSlider({
            pager: false,
            controls: true,
            infiniteLoop: false,
            minSlides: VminSlides,
            maxSlides: VmaxSlides,
            moveSlides: VmoveSlides,
            slideWidth: VslideWidth,
            slideMargin: VslideMargin,
            touchEnabled: true,
            hideControlOnEnd: true,
            prevText: '<i class="related-nav"></i>',
            nextText: '<i class="related-nav"></i>'
        });
    }

    if($('#bfp_slider').length>0)
    {
        $('#bfp_slider').slick({
            autoplay: true,
            autoplaySpeed: 3000,
            dots: true,
            infinite: true,
            arrows: false,
        });
    }
});

function selectedcateid(cateid)
{
    $("#bfp_dropdown_list li").removeClass('activecate');
    $(".bfp_cate_"+cateid).addClass('activecate');
}

function loadproducts(loadtype,pagenumber,currentcategoryid)
{
    tabarea = "#bfp_cate_"+currentcategoryid+" .bfp_product_list_con";
    $("#bfpl_"+currentcategoryid).text('loading...');
    $(tabarea).addClass("ajaxloading");
    $.ajax({
        url: ajaxurl,
        dataType: "json",
        type: "post",
        async: true,
        data: {
            'action':'GetBuyFromPhotoAjax',
            'pagenumber': pagenumber,
            'cateid': currentcategoryid,
            'post_per_page': 10,
        },
        success:function(data) {
            if(data.TotalPosts>0)
            {
                if(loadtype=='append') {
                    $(tabarea).append(data.PostsData);
                } else {
                    $(tabarea).html(data.PostsData);
                }
                $("#cpage_"+currentcategoryid).text(parseInt(pagenumber)+parseInt(1));
            }
            else
            {
                if(loadtype=='append') {
                    $(tabarea).append('<div class="nomoreposts text-center">No products available.</div>');
                } else {
                    $(tabarea).html('<div class="nomoreposts text-center">No products available.</div>');
                }
            }
            $("#bfpl_"+currentcategoryid).text('load more');

            if(data.IsLast==true) {
                $("#bfpl_"+currentcategoryid).hide();
            } else {
                $("#bfpl_"+currentcategoryid).show();
            }

            wow = new WOW(
                {
                    boxClass:     'wow'+pagenumber,
                    animateClass: 'animated',
                    offset:       0,
                    mobile:       true,
                    live:         true
                }
            )
            wow.init();
            lightcasePopup();
        },
        error: function(errorThrown){
            console.log(errorThrown);
        }
    });
}

function lightcasePopup()
{
    $('a[data-rel^=lightcase]').lightcase({
        'closeOnOverlayClick' : false,
        'navigateEndless' : false,
        'maxWidth' : 1600,
        'maxHeight' : 900,
        // onStart : {
        //     startfn: function() {
        //         $("body").attr('data-stop_scroll','body_ovreflow');
        //     }
        // },
        // onClose : {
        //     closefn: function() {
        //         $("body").removeAttr('data-stop_scroll');
        //     }
        // },
    });
}

function changetab(tabid)
{
    $(".tab-pane").removeClass('active');
    $("#bfp_cate_"+tabid).addClass('active');
    $("#bfp_cate_dropdown .btn-text").html($("#bfp_term_"+tabid).html());
}