<?php

/*

    "Contact Form to Database" Copyright (C) 2011-2012 Michael Simpson  (email : michael.d.simpson@gmail.com)



    This file is part of Contact Form to Database.



    Contact Form to Database is free software: you can redistribute it and/or modify

    it under the terms of the GNU General Public License as published by

    the Free Software Foundation, either version 3 of the License, or

    (at your option) any later version.



    Contact Form to Database is distributed in the hope that it will be useful,

    but WITHOUT ANY WARRANTY; without even the implied warranty of

    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the

    GNU General Public License for more details.



    You should have received a copy of the GNU General Public License

    along with Contact Form to Database.

    If not, see <http://www.gnu.org/licenses/>.

*/



function CF7DBPlugin_init($file) {



    require_once('CF7DBPlugin.php');

    $aPlugin = new CF7DBPlugin();



    // Install the plugin

    // NOTE: this file gets run each time you *activate* the plugin.

    // So in WP when you "install" the plugin, all that does it dump its files in the plugin-templates directory

    // but it does not call any of its code.

    // So here, the plugin tracks whether or not it has run its install operation, and we ensure it is run only once

    // on the first activation

    if (!$aPlugin->isInstalled()) {

        $aPlugin->install();

    }

    else {

        // Perform any version-upgrade activities prior to activation (e.g. database changes)

        $aPlugin->upgrade();

    }



    // Add callbacks to hooks

    $aPlugin->addActionsAndFilters();



    if (!$file) {

        $file = __FILE__;

    }

    // Register the Plugin Activation Hook

    register_activation_hook($file, array(&$aPlugin, 'activate'));





    // Register the Plugin Deactivation Hook

    register_deactivation_hook($file, array(&$aPlugin, 'deactivate'));

}

